/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.enumtype.QuantityType;
import hdi.util.NumbersUtils;
import java.math.BigDecimal;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"QTY"})
public class Quantity
implements EdiEntity {
    private static final EdiObjectMapper<Quantity> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    @Prop(edi={"QTY01"}, desc={"Code specifying the type of quantity (quantity qualifier code)"}, isRequired=true)
    private String qualifierCode;
    @EdiElt.Exclude
    @Prop(edi={"QTY01"}, desc={"Type of quantity; qualifier code translated to a mnemonic string constant (enum)"}, codeLookupQuery="type=X12_QUANTITY_QUALIFIER_CODE")
    private QuantityType type;
    @Prop(edi={"QTY02"}, isRequired=true)
    private BigDecimal quantity;

    public Quantity(QuantityType type, BigDecimal quantity) {
        this.type = type;
        this.quantity = NumbersUtils.removeTrailingZerosUpToDecimal(quantity);
        this.qualifierCode = type.ediValue();
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
    }

    @EdiElt(pos=1)
    @EdiElt.Exclude
    public void setQualifierCode(String qualifierCode) {
        this.qualifierCode = qualifierCode;
        this.type = QuantityType.fromEdi(qualifierCode);
    }

    @EdiElt(pos=2)
    public void setQuantity(BigDecimal quantity) {
        this.quantity = NumbersUtils.removeTrailingZerosUpToDecimal(quantity);
    }

    @Generated
    public String toString() {
        return "Quantity(qualifierCode=" + this.qualifierCode() + ", type=" + String.valueOf(this.type()) + ", quantity=" + String.valueOf(this.quantity()) + ")";
    }

    @Generated
    public String qualifierCode() {
        return this.qualifierCode;
    }

    @Generated
    public QuantityType type() {
        return this.type;
    }

    @Generated
    public BigDecimal quantity() {
        return this.quantity;
    }

    @Generated
    public Quantity() {
    }
}

