/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.csv.ClaimLineCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiMappingUtils;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.Amount;
import hdi.model.Attachment;
import hdi.model.DrugQuantity;
import hdi.model.LineAdjudication;
import hdi.model.PlaceOfServiceType;
import hdi.model.ProvidersUtils;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.dental.ToothInfo;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.CarcRarcType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.DrugIdentificationType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.enumtype.UnitType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.orgperson.ProviderHolder;
import hdi.model.payment.Adjustment;
import hdi.model.payment.GroupedAdjustments;
import hdi.util.CollectionUtils;
import hdi.util.DateRange;
import hdi.util.NumbersUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@EdiObj(seg={"835:SVC", "837P:SV1", "837I:SV2", "837D:SV3"}, loop={"835:2110", "837:2400"})
public class ServiceLine
implements EdiEntity,
ProviderHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceLine.class);
    public static final EdiObjectMapper<ServiceLine> mapper = new EdiObjectMapper();
    public static final EdiObjectMapper<DrugQuantity> drugQuantityMapper = new EdiObjectMapper();
    private static final String ADJUDICATION_LOOP = "2430";
    private static final String SERVICE_PAYMENT_LOOP = "2110";
    private static final String DRUG_IDENTIFICATION_LOOP = "2410";
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private EdiSeg seg;
    @EdiElt(value={"line_item_control_number"}, seg="REF")
    @Prop(refType={ReferenceType.PROVIDER_CONTROL_NUMBER}, desc={"Line item control number"})
    private String sourceLineId;
    private PlaceOfServiceType placeOfServiceType;
    @Prop(masterClass=ClaimLineCsv.class)
    private String placeOfServiceCode;
    @Prop(masterClass=ClaimLineCsv.class)
    private String emergencyIndicator;
    @Prop(masterClass=ClaimLineCsv.class)
    private String epsdtIndicator;
    @Prop(masterClass=ClaimLineCsv.class)
    private String familyPlanningIndicator;
    @EdiElt(pos=15, seg="SV1")
    @Prop(masterClass=ClaimLineCsv.class)
    private String copayStatusCode;
    @Prop(edi={"SV304"}, tran={TransactionType.DENTAL}, objType=ObjType.STRING)
    private List<String> oralCavityDesignationCodes;
    @Prop(edi={"SV305"}, tran={TransactionType.DENTAL})
    private String prosthesisCrownOrInlayCode;
    @Prop(refType={ReferenceType.PREDETERMINATION_OF_BENEFITS_NUMBER}, tran={TransactionType.DENTAL})
    private String predeterminationOfBenefitsIdentifier;
    @EdiElt(value={"repriced_line_item_reference_number", "repriced_reference_number"}, seg="REF")
    @Prop(refType={ReferenceType.REPRICED_LINE_REFERENCE_NUMBER})
    private String repricedReferenceNumber;
    @EdiElt(value={"adjusted_repriced_line_item_reference_number", "adjusted_repriced_reference_number"}, seg="REF")
    @Prop(refType={ReferenceType.ADJUSTED_REPRICED_LINE_REFERENCE_NUMBER})
    private String adjustedRepricedReferenceNumber;
    @Prop(refType={ReferenceType.PRIOR_AUTHORIZATION_NUMBER}, tran={TransactionType.PROF, TransactionType.DENTAL})
    private String priorAuthorization;
    @Prop(refType={ReferenceType.REFERRAL_NUMBER}, tran={TransactionType.PROF, TransactionType.DENTAL})
    private String referralNumber;
    @Prop(refType={ReferenceType.HEALTHCARE_POLICY_IDENTIFICATION}, tran={TransactionType.PAYMENT})
    private String healthcarePolicyId;
    @Prop(edi={"837P:SV102", "837I:SV203", "837D:SV302"}, isRequired=true)
    private BigDecimal chargeAmount;
    @EdiElt(value={"monetary_amount", "Line_Item_Denied_Charge"})
    @Prop(edi={"SV207"}, tran={TransactionType.INST})
    private BigDecimal nonCoveredAmount;
    @Prop(amtType=AmountType.TAX, tran={TransactionType.PROF, TransactionType.DENTAL})
    private BigDecimal salesTaxAmount;
    @Prop(amtType=AmountType.SERVICE_TAX, tran={TransactionType.INST})
    private BigDecimal serviceTaxAmount;
    @Prop(amtType=AmountType.MISC_TAX, tran={TransactionType.INST})
    private BigDecimal facilityTaxAmount;
    @EdiElt(value={"provider_payment"})
    @Prop(edi={"SVC03"}, tran={TransactionType.PAYMENT}, isRequired=true)
    private BigDecimal paidAmount;
    @Prop(desc={"Supplemental amounts, such as allowed amount, deduction amount, etc."}, edi={"AMT"}, objType=ObjType.AMOUNT, tran={TransactionType.PAYMENT})
    private List<Amount> supplementalAmounts;
    @Prop(desc={"Supplemental quantities"}, edi={"QTY"}, objType=ObjType.QUANTITY, tran={TransactionType.PAYMENT})
    private List<Quantity> supplementalQuantities;
    @EdiElt(value={"service_date", "service_period_start"})
    @Prop(dateType={DateType.SERVICE}, relatedFieldName="serviceDateTo", tran={TransactionType.PROF, TransactionType.DENTAL, TransactionType.INST, TransactionType.PAYMENT})
    private LocalDate serviceDateFrom;
    @EdiElt(value={"service_date_to", "service_period_end"})
    @Prop(dateType={DateType.SERVICE}, tran={TransactionType.PROF, TransactionType.DENTAL, TransactionType.INST, TransactionType.PAYMENT})
    private LocalDate serviceDateTo;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.PRESCRIPTION})
    private LocalDate prescriptionDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.BEGIN_THERAPY})
    private LocalDate beginTherapyDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.LAST_SEEN})
    private LocalDate lastSeenDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.HEMOGLOBIN_TEST, DateType.CREATINE_TEST})
    private LocalDate testPerformedDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.LAST_X_RAY})
    private LocalDate lastXRayDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.INITIAL_TREATMENT})
    private LocalDate initialTreatmentDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.PRIOR_PLACEMENT, DateType.ESTIMATED})
    private LocalDate priorPlacementDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.APPLIANCE_PLACEMENT})
    private LocalDate orthodonticBandingDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.REPLACEMENT})
    private LocalDate replacementDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.START})
    private LocalDate treatmentStartDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.COMPLETION})
    private LocalDate treatmentCompletionDate;
    @EdiElt(value={"unit_or_basis_for_measurement_code"})
    @Prop(edi={"837P:SV103", "837I:SV204", "837D:SV304"}, required={"835:N", "837:Y"})
    private UnitType unitType;
    @Prop(edi={"837P:SV104", "837I:SV205", "837D:SV305", "835:SVC05"}, required={"835:N", "837:Y"})
    private BigDecimal unitCount;
    @Prop(edi={"SVC07"}, tran={TransactionType.PAYMENT})
    private BigDecimal originalUnitCount;
    @Prop(edi={"835:SVC01", "837P:LIN03"}, tran={TransactionType.PROF, TransactionType.PAYMENT}, desc={"Drug code (NDC)"}, codeLookupQuery="type=drug", objType=ObjType.CODE)
    private CodeEntity drug;
    @EdiElt(value={"national_drug_unit_count"})
    @Prop(edi={"837P:CTP04"}, tran={TransactionType.PROF})
    private BigDecimal drugQuantity;
    @Prop(edi={"837P:CTP05-1"}, tran={TransactionType.PROF})
    private UnitType drugUnitType;
    @EdiElt(value={"prescription_number", "link_sequence_number"})
    @Prop(refType={ReferenceType.PHARMACY_PRESCRIPTION_NUMBER}, tran={TransactionType.PROF}, ignoreForEdiGen=true)
    private String prescriptionNumber;
    @EdiElt(value={"line_note", "line_note_text"})
    @Prop(edi={"NTE02 *ADD, NTE02 *DCP"}, tran={TransactionType.PROF})
    private String lineNote;
    @EdiElt(value={"third_party_organization_notes"})
    @Prop(edi={"NTE02 *TPO"}, tran={TransactionType.PROF, TransactionType.INST})
    private String thirdPartyNote;
    @EdiElt.Exclude
    @Prop(edi={"835:SVC01", "837P:SV101", "837I:SV202", "837D:SV302"}, objType=ObjType.PROCEDURE, procType={ProcType.HCPCS, ProcType.ADA, ProcType.ABC, ProcType.HIEC})
    private CodeEntity procedure;
    @EdiElt.Exclude
    @Prop(edi={"835:SVC01", "835:SVC04", "837I:SV201"}, objType=ObjType.REV_CODE, ubType={UbCodeType.REVENUE_CODE}, tran={TransactionType.PAYMENT, TransactionType.INST})
    private CodeEntity revenueCode;
    @EdiElt.Exclude
    @Prop(edi={"SVC06"}, desc={"Submitted procedure code from the claim if it is different from the adjudicated procedure"}, objType=ObjType.PROCEDURE, procType={ProcType.HCPCS, ProcType.ADA, ProcType.ABC, ProcType.HIEC}, codeLookupQuery="type=procedure", tran={TransactionType.PAYMENT})
    private CodeEntity originalProcedure;
    @EdiElt.Exclude
    @Prop(edi={"SVC06"}, desc={"Submitted revenue code from the claim if it is different from the adjudicated revenue code"}, objType=ObjType.REV_CODE, ubType={UbCodeType.REVENUE_CODE}, tran={TransactionType.PAYMENT})
    private CodeEntity originalRevenueCode;
    @EdiElt.Exclude
    @Prop(edi={"SVC06"}, desc={"Submitted drug (NDC) code from the claim if it is different from the adjudicated drug code"}, codeLookupQuery="type=drug", objType=ObjType.CODE, tran={TransactionType.PAYMENT})
    private CodeEntity originalDrug;
    @Prop(edi={"PWK"}, objType=ObjType.ATTACHMENT, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL})
    private List<Attachment> attachments;
    @EdiElt.Exclude
    @Prop(objType=ObjType.PROVIDER, desc={"Providers for this service line"})
    private Set<OrgOrPerson> providers;
    @EdiElt.Exclude
    @Prop(edi={"SVD"}, loop={"2430"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, objType=ObjType.ADJUDICATION)
    private List<LineAdjudication> adjudications;
    @EdiElt.Exclude
    @Prop(desc={"835:Line adjustments", "837:Copy of line adjustments from the adjudication list for backward compatibility"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT)
    private List<Adjustment> adjustments;
    @Prop(edi={"K301"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, objType=ObjType.STRING)
    private List<String> fixedFormatRecords;
    @Prop(desc={"Remark codes"}, edi={"LQ"}, codeType=PrimaryCodeType.REMITTANCE_ADVICE_REMARK_CODE, objType=ObjType.STRING, tran={TransactionType.PAYMENT})
    private List<String> remarkCodes;
    @Prop(desc={"Remark codes"}, edi={"LQ"}, codeType=PrimaryCodeType.REMITTANCE_ADVICE_REMARK_CODE, objType=ObjType.CODE, tran={TransactionType.PAYMENT})
    private List<CodeEntity> remarks;
    @JsonIgnore
    private int index = 0;
    @Prop(desc={"Related service-specific identifiers that were used in the process of adjudicating this service"}, edi={"REF"}, objType=ObjType.REFERENCE, tran={TransactionType.PAYMENT})
    private List<Reference> serviceIds;
    @Prop(desc={"Rendering provider identifiers"}, edi={"REF"}, objType=ObjType.REFERENCE, tran={TransactionType.PAYMENT})
    private List<Reference> renderingProviderIds;
    @Prop(objType=ObjType.TOOTH_INFO, tran={TransactionType.DENTAL})
    private List<ToothInfo> toothInfos;
    @EdiElt(value={"composite_diagnosis_code_pointer"})
    @Transient
    @JsonIgnore
    private PointersHolder diagPointersHolder;
    @Prop(edi={"837P:SV107", "837D:SV302"}, desc={"Diagnosis pointers. Each pointer is an index of the diagnosis in the 'diags' array at the claim level."}, objType=ObjType.INTEGER, tran={TransactionType.PROF, TransactionType.DENTAL}, isRequired=true)
    private List<Integer> diagPointers;
    @Prop(edi={"837P:SV107", "837D:SV302"}, desc={"Copy of diagnosis codes from the claim based on diagnosis pointers"}, objType=ObjType.INST_DIAGNOSIS, tran={TransactionType.PROF, TransactionType.DENTAL}, ignoreForEdiGen=true)
    private List<CodeEntity> diags;

    public static ServiceLine createProfLine(String procedureCode, BigDecimal chargeAmt, BigDecimal quantity, LocalDate serviceDate, List<Integer> diagPointers) {
        ServiceLine serviceLine = new ServiceLine().chargeAmount(chargeAmt).unitCount(quantity).unitType(UnitType.UNIT).serviceDateFrom(serviceDate).diagPointers(diagPointers);
        serviceLine.procedure(new CodeEntity(PrimaryCodeType.PROCEDURE, ProcType.HCPCS, procedureCode));
        return serviceLine;
    }

    public static ServiceLine createInstLine(String revenueCode, BigDecimal chargeAmt, BigDecimal quantity) {
        ServiceLine serviceLine = new ServiceLine().chargeAmount(chargeAmt).unitCount(quantity).unitType(UnitType.UNIT);
        serviceLine.revenueCode(new CodeEntity(PrimaryCodeType.UB04_REVENUE_CODE, UbCodeType.REVENUE_CODE, revenueCode));
        return serviceLine;
    }

    public String sourceLineId() {
        if (this.sourceLineId != null) {
            return this.sourceLineId;
        }
        return Integer.toString(this.index + 1);
    }

    public String lineControlNumber() {
        return this.sourceLineId;
    }

    public BigDecimal unitCount() {
        if (this.paidAmount != null && this.unitCount == null) {
            return BigDecimal.ONE;
        }
        return this.unitCount;
    }

    public int unitCountAsInt() {
        return this.unitCount != null ? this.unitCount.intValue() : 0;
    }

    @EdiElt(value={"service_unit_count", "service_units_days", "service_units_count", "units_of_service_paid_count", "procedure_count"})
    public void setUnitCount(BigDecimal quantity) {
        this.unitCount = NumbersUtils.removeTrailingZerosUpToDecimal(quantity);
    }

    @EdiElt(value={"original_units_of_service_count"})
    public void setOriginalUnitCount(BigDecimal quantity) {
        this.originalUnitCount = NumbersUtils.removeTrailingZerosUpToDecimal(quantity);
    }

    public Set<OrgOrPerson> providers() {
        if (this.providers == null) {
            return Set.of();
        }
        return this.providers;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        this.seg = EdiSeg.cloneKeySegInfo(seg);
        if (seg.type() == SegmentType.SV3) {
            this.oralCavityDesignationCodes = EdiMappingUtils.convertStringCompositeToList(seg, 4);
        }
    }

    public LocalDate serviceDateTo() {
        if (this.serviceDateTo != null) {
            return this.serviceDateTo;
        }
        return this.serviceDateFrom;
    }

    public DateRange serviceDates() {
        return new DateRange(this.serviceDateFrom, this.serviceDateTo);
    }

    public String serviceCode() {
        if (this.procedure != null) {
            return this.procedure.code();
        }
        if (this.revenueCode != null) {
            return this.revenueCode.code();
        }
        return null;
    }

    public ServiceLine placeOfServiceCode(String code) {
        this.placeOfServiceCode = code = PlaceOfServiceType.cleanupCode(code);
        this.placeOfServiceType = PlaceOfServiceType.fromCode(TransactionType.PROF, code);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiEntity ediEntity;
        EdiEntity ent;
        if (seg.isInType(SegmentType.DTP, SegmentType.AMT, SegmentType.QTY, SegmentType.REF, SegmentType.NTE, SegmentType.DTM, SegmentType.LQ, SegmentType.K3) && (this.seg.isSameLoopOf(seg) || seg.isInLoop(ADJUDICATION_LOOP, DRUG_IDENTIFICATION_LOOP))) {
            mapper.populate(this, seg);
            if (seg.isInType(SegmentType.LQ) && seg.isInLoop(SERVICE_PAYMENT_LOOP)) {
                seg.codeEntityConsumer(this::addRemarkCodeEnt);
            }
        }
        if ((ent = seg.entity()) instanceof Attachment) {
            Attachment attachment = (Attachment)ent;
            if (this.seg.isSameLoopOf(seg)) {
                if (this.attachments == null) {
                    this.attachments = new ArrayList<Attachment>();
                }
                this.attachments.add(attachment);
            }
        }
        if (StringUtils.startsWithAny((CharSequence)seg.loop(), (CharSequence[])new CharSequence[]{"24"})) {
            if (seg.isInType(SegmentType.NM1)) {
                OrgOrPerson namedEntity = (OrgOrPerson)seg.entity();
                if (namedEntity.entityRole().isProvider()) {
                    if (this.providers == null) {
                        this.providers = new LinkedHashSet<OrgOrPerson>();
                    }
                    this.providers.add(namedEntity);
                }
            } else if (seg.isInType(SegmentType.CTP)) {
                DrugQuantity drugQuantity = new DrugQuantity();
                drugQuantityMapper.populate(drugQuantity, seg);
                this.drugQuantity = drugQuantity.drugQuantity();
                if (drugQuantity.unitTypeHolder() != null) {
                    this.drugUnitType = drugQuantity.unitTypeHolder().unitType();
                }
            } else if (seg.isInType(SegmentType.LIN)) {
                seg.codeEntityConsumer(codeEnt -> {
                    this.drug = codeEnt;
                });
            }
        }
        if (seg.isInLoop(SERVICE_PAYMENT_LOOP) && ent instanceof GroupedAdjustments) {
            GroupedAdjustments groupedAdjs = (GroupedAdjustments)ent;
            if (this.adjustments == null) {
                this.adjustments = new ArrayList<Adjustment>();
            }
            this.adjustments.addAll(groupedAdjs.adjustments());
        } else if (seg.isInLoop(ADJUDICATION_LOOP) && (ediEntity = seg.entity()) instanceof LineAdjudication) {
            LineAdjudication adjudication = (LineAdjudication)ediEntity;
            this.adjudications = CollectionUtils.addWithInit(this.adjudications, adjudication);
        }
        if (!this.seg.isSameLoopOf(seg)) return;
        EdiEntity ediEntity2 = seg.entity();
        if (ediEntity2 instanceof Amount) {
            Amount amt = (Amount)ediEntity2;
            if (StringUtils.containsIgnoreCase((CharSequence)seg.name(), (CharSequence)"supplemental")) {
                this.supplementalAmounts = CollectionUtils.addWithInit(this.supplementalAmounts, amt);
                return;
            }
        }
        if ((ediEntity2 = seg.entity()) instanceof Quantity) {
            Quantity qty = (Quantity)ediEntity2;
            if (StringUtils.containsIgnoreCase((CharSequence)seg.name(), (CharSequence)"supplemental")) {
                this.supplementalQuantities = CollectionUtils.addWithInit(this.supplementalQuantities, qty);
                return;
            }
        }
        if (!((ediEntity2 = seg.entity()) instanceof Reference)) {
            ediEntity2 = seg.entity();
            if (!(ediEntity2 instanceof ToothInfo)) return;
            ToothInfo toothInfo = (ToothInfo)ediEntity2;
            this.toothInfos = CollectionUtils.addWithInit(this.toothInfos, toothInfo);
            return;
        }
        Reference reference = (Reference)ediEntity2;
        if (StringUtils.startsWith((CharSequence)seg.name(), (CharSequence)"service_identification")) {
            this.serviceIds = CollectionUtils.addWithInit(this.serviceIds, reference);
        }
        if (!StringUtils.equals((CharSequence)seg.name(), (CharSequence)"rendering_provider_information")) return;
        this.renderingProviderIds = CollectionUtils.addWithInit(this.renderingProviderIds, reference);
    }

    private void addRemarkCodeEnt(CodeEntity codeEntity) {
        if (codeEntity.subType() == CarcRarcType.RARC) {
            if (this.remarks == null) {
                this.remarks = new ArrayList<CodeEntity>();
            }
            this.remarks.add(codeEntity);
        }
    }

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType().equals(UbCodeType.REVENUE_CODE)) {
            if (this.revenueCode == null) {
                this.revenueCode = codeEntity;
            } else {
                this.originalRevenueCode = codeEntity;
            }
        } else if (codeEntity.subType() instanceof ProcType) {
            if (this.procedure == null) {
                this.procedure = codeEntity;
            } else {
                this.originalProcedure = codeEntity;
            }
        } else if (codeEntity.subType() == DrugIdentificationType.NDC) {
            if (this.drug == null) {
                this.drug = codeEntity;
            } else {
                this.originalDrug = codeEntity;
            }
        }
    }

    @EdiElt(seg="K3", pos=1)
    public void addFixedFormatRecord(String record) {
        this.fixedFormatRecords = CollectionUtils.addWithInit(this.fixedFormatRecords, record);
    }

    @EdiElt(value={"remark_code"})
    public void addRemarkCode(String remarkCode) {
        this.remarkCodes = CollectionUtils.addWithInit(this.remarkCodes, remarkCode);
    }

    public boolean containsCodeEntity(CodeEntity codeEntity) {
        for (CodeEntity codeEnt : this.allCodeEntities()) {
            if (!CodeEntity.isSameCode(codeEnt, codeEntity)) continue;
            return true;
        }
        return codeEntity.type() == PrimaryCodeType.RBCS_TAXONOMY && this.procedure != null && this.procedure.containsCategory(codeEntity);
    }

    public ServiceLine diagPointersHolder(PointersHolder pointersHolder) {
        this.diagPointers = pointersHolder.pointers;
        return this;
    }

    public void addDiag(CodeEntity claimDiag, int i) {
        if (this.diagPointers == null) {
            return;
        }
        for (Integer diagPointer : this.diagPointers) {
            if (diagPointer <= 0 || diagPointer - 1 != i) continue;
            if (this.diags == null) {
                this.diags = new ArrayList<CodeEntity>();
            }
            this.diags.add(claimDiag);
        }
    }

    @Override
    public OrgOrPerson getProvider(EntityRole entityRole) {
        return ProvidersUtils.findProvider(entityRole, this.providers);
    }

    public List<CodeEntity> allCodeEntities() {
        ArrayList<CodeEntity> allCodeEntities = new ArrayList<CodeEntity>();
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.revenueCode);
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.originalRevenueCode);
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.procedure);
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.originalProcedure);
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.drug);
        CollectionUtils.addLineCodeEnt(this, allCodeEntities, this.originalDrug);
        List<Adjustment> adjs = this.getAllAdjustments();
        if (adjs != null) {
            for (Adjustment adj : adjs) {
                CollectionUtils.addIfNotNull(allCodeEntities, adj.reason());
            }
        }
        if (this.remarks != null) {
            for (CodeEntity remark : this.remarks) {
                CollectionUtils.addIfNotNull(allCodeEntities, remark);
            }
        }
        return allCodeEntities;
    }

    @JsonIgnore
    public BigDecimal getTotalAdjustmentAmount() {
        return Adjustment.sumAdjustments(this.adjustments, null);
    }

    @JsonIgnore
    public BigDecimal getAllowedAmount() {
        return Amount.findAmountByType(this.supplementalAmounts, AmountType.ALLOWED_ACTUAL);
    }

    @JsonIgnore
    public List<Adjustment> getAllAdjustments() {
        if (this.adjudications != null) {
            ArrayList<Adjustment> allAdjustments = new ArrayList<Adjustment>();
            for (LineAdjudication adjudication : this.adjudications) {
                if (adjudication.adjustments() == null) continue;
                allAdjustments.addAll(adjudication.adjustments());
            }
            return allAdjustments;
        }
        return this.adjustments == null ? List.of() : this.adjustments;
    }

    public List<Adjustment> adjustments() {
        return this.adjustments == null ? List.of() : this.adjustments;
    }

    public List<LineAdjudication> adjudications() {
        return this.adjudications == null ? List.of() : this.adjudications;
    }

    public List<Amount> supplementalAmounts() {
        return this.supplementalAmounts == null ? List.of() : this.supplementalAmounts;
    }

    public List<Quantity> supplementalQuantities() {
        return this.supplementalQuantities == null ? List.of() : this.supplementalQuantities;
    }

    public List<Attachment> attachments() {
        return this.attachments == null ? List.of() : this.attachments;
    }

    public List<CodeEntity> remarks() {
        return this.remarks == null ? List.of() : this.remarks;
    }

    public List<String> remarkCodes() {
        return this.remarkCodes == null ? List.of() : this.remarkCodes;
    }

    public List<Reference> serviceIds() {
        return this.serviceIds == null ? List.of() : this.serviceIds;
    }

    public List<Reference> renderingProviderIds() {
        return this.renderingProviderIds == null ? List.of() : this.renderingProviderIds;
    }

    public List<ToothInfo> toothInfos() {
        return this.toothInfos == null ? List.of() : this.toothInfos;
    }

    public List<Integer> diagPointers() {
        return this.diagPointers == null ? List.of() : this.diagPointers;
    }

    public List<CodeEntity> diags() {
        return this.diags == null ? List.of() : this.diags;
    }

    public List<String> fixedFormatRecords() {
        return this.fixedFormatRecords == null ? List.of() : this.fixedFormatRecords;
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public PlaceOfServiceType placeOfServiceType() {
        return this.placeOfServiceType;
    }

    @Generated
    public String placeOfServiceCode() {
        return this.placeOfServiceCode;
    }

    @Generated
    public String emergencyIndicator() {
        return this.emergencyIndicator;
    }

    @Generated
    public String epsdtIndicator() {
        return this.epsdtIndicator;
    }

    @Generated
    public String familyPlanningIndicator() {
        return this.familyPlanningIndicator;
    }

    @Generated
    public String copayStatusCode() {
        return this.copayStatusCode;
    }

    @Generated
    public List<String> oralCavityDesignationCodes() {
        return this.oralCavityDesignationCodes;
    }

    @Generated
    public String prosthesisCrownOrInlayCode() {
        return this.prosthesisCrownOrInlayCode;
    }

    @Generated
    public String predeterminationOfBenefitsIdentifier() {
        return this.predeterminationOfBenefitsIdentifier;
    }

    @Generated
    public String repricedReferenceNumber() {
        return this.repricedReferenceNumber;
    }

    @Generated
    public String adjustedRepricedReferenceNumber() {
        return this.adjustedRepricedReferenceNumber;
    }

    @Generated
    public String priorAuthorization() {
        return this.priorAuthorization;
    }

    @Generated
    public String referralNumber() {
        return this.referralNumber;
    }

    @Generated
    public String healthcarePolicyId() {
        return this.healthcarePolicyId;
    }

    @Generated
    public BigDecimal chargeAmount() {
        return this.chargeAmount;
    }

    @Generated
    public BigDecimal nonCoveredAmount() {
        return this.nonCoveredAmount;
    }

    @Generated
    public BigDecimal salesTaxAmount() {
        return this.salesTaxAmount;
    }

    @Generated
    public BigDecimal serviceTaxAmount() {
        return this.serviceTaxAmount;
    }

    @Generated
    public BigDecimal facilityTaxAmount() {
        return this.facilityTaxAmount;
    }

    @Generated
    public BigDecimal paidAmount() {
        return this.paidAmount;
    }

    @Generated
    public LocalDate serviceDateFrom() {
        return this.serviceDateFrom;
    }

    @Generated
    public LocalDate prescriptionDate() {
        return this.prescriptionDate;
    }

    @Generated
    public LocalDate beginTherapyDate() {
        return this.beginTherapyDate;
    }

    @Generated
    public LocalDate lastSeenDate() {
        return this.lastSeenDate;
    }

    @Generated
    public LocalDate testPerformedDate() {
        return this.testPerformedDate;
    }

    @Generated
    public LocalDate lastXRayDate() {
        return this.lastXRayDate;
    }

    @Generated
    public LocalDate initialTreatmentDate() {
        return this.initialTreatmentDate;
    }

    @Generated
    public LocalDate priorPlacementDate() {
        return this.priorPlacementDate;
    }

    @Generated
    public LocalDate orthodonticBandingDate() {
        return this.orthodonticBandingDate;
    }

    @Generated
    public LocalDate replacementDate() {
        return this.replacementDate;
    }

    @Generated
    public LocalDate treatmentStartDate() {
        return this.treatmentStartDate;
    }

    @Generated
    public LocalDate treatmentCompletionDate() {
        return this.treatmentCompletionDate;
    }

    @Generated
    public UnitType unitType() {
        return this.unitType;
    }

    @Generated
    public BigDecimal originalUnitCount() {
        return this.originalUnitCount;
    }

    @Generated
    public CodeEntity drug() {
        return this.drug;
    }

    @Generated
    public BigDecimal drugQuantity() {
        return this.drugQuantity;
    }

    @Generated
    public UnitType drugUnitType() {
        return this.drugUnitType;
    }

    @Generated
    public String prescriptionNumber() {
        return this.prescriptionNumber;
    }

    @Generated
    public String lineNote() {
        return this.lineNote;
    }

    @Generated
    public String thirdPartyNote() {
        return this.thirdPartyNote;
    }

    @Generated
    public CodeEntity procedure() {
        return this.procedure;
    }

    @Generated
    public CodeEntity revenueCode() {
        return this.revenueCode;
    }

    @Generated
    public CodeEntity originalProcedure() {
        return this.originalProcedure;
    }

    @Generated
    public CodeEntity originalRevenueCode() {
        return this.originalRevenueCode;
    }

    @Generated
    public CodeEntity originalDrug() {
        return this.originalDrug;
    }

    @JsonIgnore
    @Generated
    public int index() {
        return this.index;
    }

    @JsonIgnore
    @Generated
    public PointersHolder diagPointersHolder() {
        return this.diagPointersHolder;
    }

    @JsonIgnore
    @Generated
    public ServiceLine seg(EdiSeg seg) {
        this.seg = seg;
        return this;
    }

    @Generated
    public ServiceLine sourceLineId(String sourceLineId) {
        this.sourceLineId = sourceLineId;
        return this;
    }

    @Generated
    public ServiceLine placeOfServiceType(PlaceOfServiceType placeOfServiceType) {
        this.placeOfServiceType = placeOfServiceType;
        return this;
    }

    @Generated
    public ServiceLine emergencyIndicator(String emergencyIndicator) {
        this.emergencyIndicator = emergencyIndicator;
        return this;
    }

    @Generated
    public ServiceLine epsdtIndicator(String epsdtIndicator) {
        this.epsdtIndicator = epsdtIndicator;
        return this;
    }

    @Generated
    public ServiceLine familyPlanningIndicator(String familyPlanningIndicator) {
        this.familyPlanningIndicator = familyPlanningIndicator;
        return this;
    }

    @Generated
    public ServiceLine copayStatusCode(String copayStatusCode) {
        this.copayStatusCode = copayStatusCode;
        return this;
    }

    @Generated
    public ServiceLine oralCavityDesignationCodes(List<String> oralCavityDesignationCodes) {
        this.oralCavityDesignationCodes = oralCavityDesignationCodes;
        return this;
    }

    @Generated
    public ServiceLine prosthesisCrownOrInlayCode(String prosthesisCrownOrInlayCode) {
        this.prosthesisCrownOrInlayCode = prosthesisCrownOrInlayCode;
        return this;
    }

    @Generated
    public ServiceLine predeterminationOfBenefitsIdentifier(String predeterminationOfBenefitsIdentifier) {
        this.predeterminationOfBenefitsIdentifier = predeterminationOfBenefitsIdentifier;
        return this;
    }

    @Generated
    public ServiceLine repricedReferenceNumber(String repricedReferenceNumber) {
        this.repricedReferenceNumber = repricedReferenceNumber;
        return this;
    }

    @Generated
    public ServiceLine adjustedRepricedReferenceNumber(String adjustedRepricedReferenceNumber) {
        this.adjustedRepricedReferenceNumber = adjustedRepricedReferenceNumber;
        return this;
    }

    @Generated
    public ServiceLine priorAuthorization(String priorAuthorization) {
        this.priorAuthorization = priorAuthorization;
        return this;
    }

    @Generated
    public ServiceLine referralNumber(String referralNumber) {
        this.referralNumber = referralNumber;
        return this;
    }

    @Generated
    public ServiceLine healthcarePolicyId(String healthcarePolicyId) {
        this.healthcarePolicyId = healthcarePolicyId;
        return this;
    }

    @Generated
    public ServiceLine chargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @Generated
    public ServiceLine nonCoveredAmount(BigDecimal nonCoveredAmount) {
        this.nonCoveredAmount = nonCoveredAmount;
        return this;
    }

    @Generated
    public ServiceLine salesTaxAmount(BigDecimal salesTaxAmount) {
        this.salesTaxAmount = salesTaxAmount;
        return this;
    }

    @Generated
    public ServiceLine serviceTaxAmount(BigDecimal serviceTaxAmount) {
        this.serviceTaxAmount = serviceTaxAmount;
        return this;
    }

    @Generated
    public ServiceLine facilityTaxAmount(BigDecimal facilityTaxAmount) {
        this.facilityTaxAmount = facilityTaxAmount;
        return this;
    }

    @Generated
    public ServiceLine paidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
        return this;
    }

    @Generated
    public ServiceLine supplementalAmounts(List<Amount> supplementalAmounts) {
        this.supplementalAmounts = supplementalAmounts;
        return this;
    }

    @Generated
    public ServiceLine supplementalQuantities(List<Quantity> supplementalQuantities) {
        this.supplementalQuantities = supplementalQuantities;
        return this;
    }

    @Generated
    public ServiceLine serviceDateFrom(LocalDate serviceDateFrom) {
        this.serviceDateFrom = serviceDateFrom;
        return this;
    }

    @Generated
    public ServiceLine serviceDateTo(LocalDate serviceDateTo) {
        this.serviceDateTo = serviceDateTo;
        return this;
    }

    @Generated
    public ServiceLine prescriptionDate(LocalDate prescriptionDate) {
        this.prescriptionDate = prescriptionDate;
        return this;
    }

    @Generated
    public ServiceLine beginTherapyDate(LocalDate beginTherapyDate) {
        this.beginTherapyDate = beginTherapyDate;
        return this;
    }

    @Generated
    public ServiceLine lastSeenDate(LocalDate lastSeenDate) {
        this.lastSeenDate = lastSeenDate;
        return this;
    }

    @Generated
    public ServiceLine testPerformedDate(LocalDate testPerformedDate) {
        this.testPerformedDate = testPerformedDate;
        return this;
    }

    @Generated
    public ServiceLine lastXRayDate(LocalDate lastXRayDate) {
        this.lastXRayDate = lastXRayDate;
        return this;
    }

    @Generated
    public ServiceLine initialTreatmentDate(LocalDate initialTreatmentDate) {
        this.initialTreatmentDate = initialTreatmentDate;
        return this;
    }

    @Generated
    public ServiceLine priorPlacementDate(LocalDate priorPlacementDate) {
        this.priorPlacementDate = priorPlacementDate;
        return this;
    }

    @Generated
    public ServiceLine orthodonticBandingDate(LocalDate orthodonticBandingDate) {
        this.orthodonticBandingDate = orthodonticBandingDate;
        return this;
    }

    @Generated
    public ServiceLine replacementDate(LocalDate replacementDate) {
        this.replacementDate = replacementDate;
        return this;
    }

    @Generated
    public ServiceLine treatmentStartDate(LocalDate treatmentStartDate) {
        this.treatmentStartDate = treatmentStartDate;
        return this;
    }

    @Generated
    public ServiceLine treatmentCompletionDate(LocalDate treatmentCompletionDate) {
        this.treatmentCompletionDate = treatmentCompletionDate;
        return this;
    }

    @Generated
    public ServiceLine unitType(UnitType unitType) {
        this.unitType = unitType;
        return this;
    }

    @Generated
    public ServiceLine unitCount(BigDecimal unitCount) {
        this.unitCount = unitCount;
        return this;
    }

    @Generated
    public ServiceLine originalUnitCount(BigDecimal originalUnitCount) {
        this.originalUnitCount = originalUnitCount;
        return this;
    }

    @Generated
    public ServiceLine drug(CodeEntity drug) {
        this.drug = drug;
        return this;
    }

    @Generated
    public ServiceLine drugQuantity(BigDecimal drugQuantity) {
        this.drugQuantity = drugQuantity;
        return this;
    }

    @Generated
    public ServiceLine drugUnitType(UnitType drugUnitType) {
        this.drugUnitType = drugUnitType;
        return this;
    }

    @Generated
    public ServiceLine prescriptionNumber(String prescriptionNumber) {
        this.prescriptionNumber = prescriptionNumber;
        return this;
    }

    @Generated
    public ServiceLine lineNote(String lineNote) {
        this.lineNote = lineNote;
        return this;
    }

    @Generated
    public ServiceLine thirdPartyNote(String thirdPartyNote) {
        this.thirdPartyNote = thirdPartyNote;
        return this;
    }

    @Generated
    public ServiceLine procedure(CodeEntity procedure) {
        this.procedure = procedure;
        return this;
    }

    @Generated
    public ServiceLine revenueCode(CodeEntity revenueCode) {
        this.revenueCode = revenueCode;
        return this;
    }

    @Generated
    public ServiceLine originalProcedure(CodeEntity originalProcedure) {
        this.originalProcedure = originalProcedure;
        return this;
    }

    @Generated
    public ServiceLine originalRevenueCode(CodeEntity originalRevenueCode) {
        this.originalRevenueCode = originalRevenueCode;
        return this;
    }

    @Generated
    public ServiceLine originalDrug(CodeEntity originalDrug) {
        this.originalDrug = originalDrug;
        return this;
    }

    @Generated
    public ServiceLine attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @Generated
    public ServiceLine providers(Set<OrgOrPerson> providers) {
        this.providers = providers;
        return this;
    }

    @Generated
    public ServiceLine adjudications(List<LineAdjudication> adjudications) {
        this.adjudications = adjudications;
        return this;
    }

    @Generated
    public ServiceLine adjustments(List<Adjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    @Generated
    public ServiceLine fixedFormatRecords(List<String> fixedFormatRecords) {
        this.fixedFormatRecords = fixedFormatRecords;
        return this;
    }

    @Generated
    public ServiceLine remarkCodes(List<String> remarkCodes) {
        this.remarkCodes = remarkCodes;
        return this;
    }

    @Generated
    public ServiceLine remarks(List<CodeEntity> remarks) {
        this.remarks = remarks;
        return this;
    }

    @Generated
    public ServiceLine serviceIds(List<Reference> serviceIds) {
        this.serviceIds = serviceIds;
        return this;
    }

    @Generated
    public ServiceLine renderingProviderIds(List<Reference> renderingProviderIds) {
        this.renderingProviderIds = renderingProviderIds;
        return this;
    }

    @Generated
    public ServiceLine toothInfos(List<ToothInfo> toothInfos) {
        this.toothInfos = toothInfos;
        return this;
    }

    @Generated
    public ServiceLine diagPointers(List<Integer> diagPointers) {
        this.diagPointers = diagPointers;
        return this;
    }

    @Generated
    public ServiceLine diags(List<CodeEntity> diags) {
        this.diags = diags;
        return this;
    }

    @Generated
    public String toString() {
        return "ServiceLine(sourceLineId=" + this.sourceLineId() + ", placeOfServiceType=" + String.valueOf((Object)this.placeOfServiceType()) + ", placeOfServiceCode=" + this.placeOfServiceCode() + ", emergencyIndicator=" + this.emergencyIndicator() + ", epsdtIndicator=" + this.epsdtIndicator() + ", familyPlanningIndicator=" + this.familyPlanningIndicator() + ", copayStatusCode=" + this.copayStatusCode() + ", oralCavityDesignationCodes=" + String.valueOf(this.oralCavityDesignationCodes()) + ", prosthesisCrownOrInlayCode=" + this.prosthesisCrownOrInlayCode() + ", predeterminationOfBenefitsIdentifier=" + this.predeterminationOfBenefitsIdentifier() + ", repricedReferenceNumber=" + this.repricedReferenceNumber() + ", adjustedRepricedReferenceNumber=" + this.adjustedRepricedReferenceNumber() + ", priorAuthorization=" + this.priorAuthorization() + ", referralNumber=" + this.referralNumber() + ", healthcarePolicyId=" + this.healthcarePolicyId() + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", nonCoveredAmount=" + String.valueOf(this.nonCoveredAmount()) + ", salesTaxAmount=" + String.valueOf(this.salesTaxAmount()) + ", serviceTaxAmount=" + String.valueOf(this.serviceTaxAmount()) + ", facilityTaxAmount=" + String.valueOf(this.facilityTaxAmount()) + ", paidAmount=" + String.valueOf(this.paidAmount()) + ", supplementalAmounts=" + String.valueOf(this.supplementalAmounts()) + ", supplementalQuantities=" + String.valueOf(this.supplementalQuantities()) + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom()) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo()) + ", prescriptionDate=" + String.valueOf(this.prescriptionDate()) + ", beginTherapyDate=" + String.valueOf(this.beginTherapyDate()) + ", lastSeenDate=" + String.valueOf(this.lastSeenDate()) + ", testPerformedDate=" + String.valueOf(this.testPerformedDate()) + ", lastXRayDate=" + String.valueOf(this.lastXRayDate()) + ", initialTreatmentDate=" + String.valueOf(this.initialTreatmentDate()) + ", priorPlacementDate=" + String.valueOf(this.priorPlacementDate()) + ", orthodonticBandingDate=" + String.valueOf(this.orthodonticBandingDate()) + ", replacementDate=" + String.valueOf(this.replacementDate()) + ", treatmentStartDate=" + String.valueOf(this.treatmentStartDate()) + ", treatmentCompletionDate=" + String.valueOf(this.treatmentCompletionDate()) + ", unitType=" + String.valueOf(this.unitType()) + ", unitCount=" + String.valueOf(this.unitCount()) + ", originalUnitCount=" + String.valueOf(this.originalUnitCount()) + ", drug=" + String.valueOf(this.drug()) + ", drugQuantity=" + String.valueOf(this.drugQuantity()) + ", drugUnitType=" + String.valueOf(this.drugUnitType()) + ", prescriptionNumber=" + this.prescriptionNumber() + ", lineNote=" + this.lineNote() + ", thirdPartyNote=" + this.thirdPartyNote() + ", procedure=" + String.valueOf(this.procedure()) + ", revenueCode=" + String.valueOf(this.revenueCode()) + ", originalProcedure=" + String.valueOf(this.originalProcedure()) + ", originalRevenueCode=" + String.valueOf(this.originalRevenueCode()) + ", originalDrug=" + String.valueOf(this.originalDrug()) + ", attachments=" + String.valueOf(this.attachments()) + ", adjudications=" + String.valueOf(this.adjudications()) + ", adjustments=" + String.valueOf(this.adjustments()) + ", fixedFormatRecords=" + String.valueOf(this.fixedFormatRecords()) + ", remarkCodes=" + String.valueOf(this.remarkCodes()) + ", remarks=" + String.valueOf(this.remarks()) + ", index=" + this.index() + ", serviceIds=" + String.valueOf(this.serviceIds()) + ", renderingProviderIds=" + String.valueOf(this.renderingProviderIds()) + ", toothInfos=" + String.valueOf(this.toothInfos()) + ", diagPointersHolder=" + String.valueOf(this.diagPointersHolder()) + ", diagPointers=" + String.valueOf(this.diagPointers()) + ", diags=" + String.valueOf(this.diags()) + ")";
    }

    @JsonIgnore
    @Generated
    public ServiceLine index(int index) {
        this.index = index;
        return this;
    }

    public static class PointersHolder {
        @EdiElt(value={"pointer"})
        private final List<Integer> pointers = new ArrayList<Integer>();

        @Generated
        public String toString() {
            return "ServiceLine.PointersHolder(pointers=" + String.valueOf(this.pointers) + ")";
        }
    }
}

