/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.claim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.codeent.NormalizedCodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.EdiTransaction;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.Attachment;
import hdi.model.ClaimOrPayment;
import hdi.model.DateTimePeriod;
import hdi.model.ObjectType;
import hdi.model.ProvidersUtils;
import hdi.model.ServiceLine;
import hdi.model.claim.ClaimTransaction;
import hdi.model.dental.OrthodonticInfo;
import hdi.model.dental.ToothStatus;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.DiagType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.orgperson.ProviderHolder;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Adjustment;
import hdi.util.CollectionUtils;
import hdi.util.SearchWordsUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2300"}, seg={"CLM"}, jsonExample={"837P:837/837P-all-fields", "837I:837/837I-all-fields", "837D:837/837D-all-fields"}, interactiveExample={"837P:claims/comprehensive/", "837I:claims/institutional-837i/all-fields/"})
public class Claim
extends ClaimOrPayment
implements ProviderHolder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Claim.class);
    public static EdiObjectMapper<Claim> mapper = new EdiObjectMapper();
    @Transient
    @JsonIgnore
    private EdiSeg seg;
    @Schema(example="PROF")
    @JsonIgnore
    private TransactionType transactionType;
    @EdiElt(seg="CLM", pos=6, tran={TransactionType.PROF, TransactionType.DENTAL}, isRequired=true)
    private String providerSignatureIndicator;
    @EdiElt(seg="CLM", pos=7, isRequired=true)
    private String assignmentParticipationCode;
    @EdiElt(seg="CLM", pos=8, isRequired=true)
    private String assignmentCertificationIndicator;
    @EdiElt(seg="CLM", pos=9, isRequired=true)
    private String releaseOfInformationCode;
    @EdiElt(seg="CLM", pos=12, tran={TransactionType.PROF, TransactionType.DENTAL})
    private String specialProgramCode;
    @EdiElt(seg="CLM", pos=20)
    private String delayReasonCode;
    @JsonIgnore
    private String sourceClaimId;
    @EdiElt.Exclude
    private String sourceClaimVersionId;
    @EdiElt.Exclude
    private LocalDate paidDate;
    @Prop(refType={ReferenceType.SPECIAL_PAYMENT_REFERENCE_NUMBER})
    private String serviceAuthorizationExceptionCode;
    @Prop(refType={ReferenceType.REFERRAL_NUMBER})
    private String referralNumber;
    @Prop(refType={ReferenceType.PRIOR_AUTHORIZATION_NUMBER})
    @EdiElt(value={"prior_authorization"})
    private String priorAuthorizationNumber;
    @EdiElt(value={"claim_original_reference_number"})
    @Prop(refType={ReferenceType.ORIGINAL_REFERENCE_NUMBER})
    private String originalReferenceNumber;
    @Prop(refType={ReferenceType.REPRICED_REFERENCE_NUMBER})
    private String repricedReferenceNumber;
    @Prop(refType={ReferenceType.ADJUSTED_REPRICED_REFERENCE_NUMBER})
    private String adjustedRepricedReferenceNumber;
    @Prop(refType={ReferenceType.CLAIM_NUMBER})
    private String clearinghouseTraceNumber;
    @Prop(refType={ReferenceType.LOCATION_NUMBER}, tran={TransactionType.INST})
    @EdiElt(value={"auto_accident_state_or_province"})
    private String accidentState;
    @Prop(refType={ReferenceType.MEDICAL_RECORD_NUMBER})
    private String medicalRecordNumber;
    @Prop(refType={ReferenceType.PPO_APPROVAL_NUMBER}, tran={TransactionType.INST})
    private String peerReviewAuthorizationNumber;
    @Prop(refType={ReferenceType.PROJECT_CODE}, tran={TransactionType.INST, TransactionType.PROF, TransactionType.DENTAL})
    private String demonstrationProjectIdentifier;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.ONSET_OF_CURRENT_ILLNESS})
    private LocalDate onsetOfCurrentIllnessOrInjuryDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.INITIAL_TREATMENT})
    private LocalDate initialTreatmentDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.LAST_SEEN})
    private LocalDate lastSeenDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.ACUTE_MANIFESTATION})
    private LocalDate acuteManifestationDate;
    @Prop(tran={TransactionType.PROF, TransactionType.DENTAL}, dateType={DateType.ACCIDENT})
    private LocalDate accidentDate;
    @Prop(tran={TransactionType.DENTAL}, dateType={DateType.APPLIANCE_PLACEMENT})
    private LocalDate orthodonticBandingDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.LAST_MENSTRUAL_PERIOD})
    private LocalDate lastMenstrualPeriodDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.LAST_X_RAY})
    private LocalDate lastXRayDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.PRESCRIPTION}, desc={"Hearing and vision prescription date"})
    private LocalDate prescriptionDate;
    @EdiElt(value={"disability_date"})
    @Prop(dateType={DateType.DISABILITY_FROM_TO}, relatedFieldName="disabilityDateTo", tran={TransactionType.PROF})
    private LocalDate disabilityDateFrom;
    @Prop(dateType={DateType.DISABILITY_END}, tran={TransactionType.PROF})
    private LocalDate disabilityDateTo;
    @Prop(dateType={DateType.LAST_DAY_WORKED}, tran={TransactionType.PROF})
    private LocalDate lastWorkedDate;
    @EdiElt(value={"work_return_date"})
    @Prop(dateType={DateType.RETURN_TO_WORK}, tran={TransactionType.PROF})
    private LocalDate authorizedReturnToWorkDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.ADMISSION}, desc={"Admission date for ambulance claims"})
    private LocalDate admissionDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.DISCHARGE})
    private LocalDate dischargeDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.ASSUMED_CARE})
    private LocalDate assumedCareDate;
    @Prop(tran={TransactionType.PROF}, dateType={DateType.RELINQUISHED_CARE})
    private LocalDate relinquishedCareDate;
    @Prop(dateType={DateType.FIRST_VISIT_OR_CONSULTATION}, tran={TransactionType.PROF})
    private LocalDate propertyCasualtyFirstContactDate;
    @Prop(tran={TransactionType.INST}, dateType={DateType.ADMISSION})
    private LocalDateTime admissionDateAndHour;
    @EdiElt(value={"discharge_time"})
    @Schema(type="String", format="date-time")
    @Prop(tran={TransactionType.INST}, dateType={DateType.DISCHARGE})
    private LocalTime dischargeTime;
    @Prop(dateType={DateType.RECEIVED}, tran={TransactionType.PROF, TransactionType.DENTAL})
    private LocalDate repricerReceivedDate;
    @EdiElt.Exclude
    @Prop(tran={TransactionType.DENTAL}, objType=ObjType.ORTHODONTIC_INFO)
    private OrthodonticInfo orthodonticInfo;
    @EdiElt.Exclude
    @Prop(tran={TransactionType.DENTAL}, objType=ObjType.TOOTH_STATUS)
    private List<ToothStatus> toothStatuses;
    @Prop(edi={"CL101"}, tran={TransactionType.INST})
    @EdiElt(value={"admission_type_code"})
    private String admissionTypeCode;
    @EdiElt(value={"admission_source_code"})
    @Prop(edi={"CL102"}, tran={TransactionType.INST})
    private String admissionSourceCode;
    @EdiElt(value={"patient_status_code"})
    @Prop(edi={"CL103"}, tran={TransactionType.INST}, isRequired=true)
    private String patientStatusCode;
    @Prop(tran={TransactionType.INST}, amtType=AmountType.PATIENT_RESP)
    private BigDecimal patientResponsibilityAmount;
    @Prop(refType={ReferenceType.PREDETERMINATION_OF_BENEFITS_NUMBER}, tran={TransactionType.DENTAL})
    private String predeterminationOfBenefitsIdentifier;
    @EdiElt.Exclude
    @Prop(edi={"K301"}, objType=ObjType.STRING)
    private List<String> fixedFormatRecords;
    @Prop(edi={"NTE02"}, desc={"Free-form comments or instructions. All note segments are concatenated together into this field."})
    private String claimNote;
    @EdiElt(value={"billing_note_text"})
    @Prop(edi={"NTE02 *ADD"}, tran={TransactionType.INST})
    private String billingNote;
    @Transient
    @EdiElt.Exclude
    @Prop(edi={"NM1"}, entityRole=EntityRole.BILLING_PROVIDER, objType=ObjType.PROVIDER)
    private OrgOrPerson billingProvider;
    @Transient
    @EdiElt.Exclude
    @Prop(objType=ObjType.PROVIDER, desc={"Providers for this claim, except for the billing provider"})
    private Set<OrgOrPerson> providers;
    @Prop(desc={"Diagnosis codes"}, edi={"HI"}, tran={TransactionType.INST, TransactionType.PROF}, objType=ObjType.INST_DIAGNOSIS, isRequired=true)
    private List<CodeEntity> diags;
    @EdiElt.Exclude
    @Prop(edi={"HI"}, tran={TransactionType.INST}, objType=ObjType.CODE, ubType={UbCodeType.DRG})
    private CodeEntity drg;
    @Prop(tran={TransactionType.INST, TransactionType.PROF}, edi={"HI"}, desc={"837I:Claim-level procedures", "837P:Anesthesia-related procedures"}, objType=ObjType.PROCEDURE_WITH_DATE)
    private List<CodeEntity> procs;
    @Prop(tran={TransactionType.INST}, objType=ObjType.OCCURRENCE_SPAN, ubType={UbCodeType.OCCURRENCE_SPAN})
    private List<CodeEntity> occurrenceSpans;
    @Prop(tran={TransactionType.INST}, objType=ObjType.OCCURRENCE, ubType={UbCodeType.OCCURRENCE})
    private List<CodeEntity> occurrences;
    @Prop(tran={TransactionType.INST}, objType=ObjType.CODE_AND_AMOUNT, ubType={UbCodeType.VALUE})
    private List<CodeEntity> valueInfos;
    @Prop(objType=ObjType.CONDITION, ubType={UbCodeType.CONDITION}, tran={TransactionType.INST, TransactionType.PROF})
    private List<CodeEntity> conditions;
    @Prop(edi={"PWK"}, objType=ObjType.ATTACHMENT, tran={TransactionType.INST, TransactionType.PROF, TransactionType.DENTAL})
    private List<Attachment> attachments;
    @EdiElt.Exclude
    @JsonIgnore
    private int lineCount;
    @JsonIgnore
    private LocalDateTime checkTimestamp;
    @Transient
    @JsonIgnore
    private ClaimTransaction claimTransaction;
    @JsonIgnore
    private Set<String> tags;
    @JsonIgnore
    private Set<String> searchWords;

    public String sourceClaimId() {
        if (this.sourceClaimId != null) {
            return this.sourceClaimId;
        }
        return this.patientControlNumber;
    }

    @Override
    public String id() {
        return this.claimTransaction.id();
    }

    public Claim() {
        this.objectType = ObjectType.CLAIM;
    }

    public static Claim createProfClaim(String pcn, BigDecimal chargeAmt, String placeOfServiceCode) {
        Claim claim = new Claim();
        claim.patientControlNumber(pcn).chargeAmount(chargeAmt);
        claim.transactionType(TransactionType.PROF);
        claim.facilityCode(new CodeEntity(UbCodeType.PLACE_OF_SERVICE, placeOfServiceCode));
        claim.frequencyCode(new CodeEntity(UbCodeType.FREQUENCY_CODE, "1"));
        claim.providerSignatureIndicator("Y").assignmentParticipationCode("A").assignmentCertificationIndicator("Y").releaseOfInformationCode("Y");
        return claim;
    }

    public static Claim createInstClaim(String pcn, BigDecimal chargeAmt, String facilityCode, String patientStatusCode, LocalDate statementDateFrom, LocalDate statementDateTo) {
        Claim claim = new Claim();
        claim.patientControlNumber(pcn).chargeAmount(chargeAmt);
        claim.transactionType(TransactionType.INST);
        claim.facilityCode(new CodeEntity(UbCodeType.FACILITY_TYPE, facilityCode));
        claim.frequencyCode(new CodeEntity(UbCodeType.FREQUENCY_CODE, "1"));
        claim.assignmentParticipationCode("A").assignmentCertificationIndicator("Y").releaseOfInformationCode("Y");
        claim.serviceDateFrom(statementDateFrom);
        claim.serviceDateTo(statementDateTo);
        claim.patientStatusCode(patientStatusCode);
        return claim;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        this.transaction = new EdiTransaction();
        this.claimTransaction = new ClaimTransaction();
        this.claimTransaction.claim(this);
        if (results != null && results.curTransaction() != null) {
            this.transaction = results.curTransaction();
            this.claimTransaction.chargeAmount(this.chargeAmount);
            this.populateBillingProviderPatient(this.claimTransaction, results);
            this.transactionType = this.transaction.transactionType();
            results.claimTransactions().add(this.claimTransaction);
            results.claims().add(this);
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    public Temporal admissionDateOrDateTime() {
        return this.admissionDate != null ? this.admissionDate : this.admissionDateAndHour;
    }

    private void populateBillingProviderPatient(ClaimTransaction myClaimTran, EdiParsingResults results) {
        for (EdiEntity ent : results.curTranEntities()) {
            OrgOrPerson billingProvider = null;
            if (ent instanceof OrgOrPerson) {
                OrgOrPerson orgOrPerson = (OrgOrPerson)ent;
                if (orgOrPerson.entityRole() == EntityRole.BILLING_PROVIDER) {
                    billingProvider = orgOrPerson;
                }
            } else if (ent instanceof PatientSubscriber) {
                PatientSubscriber patSub = (PatientSubscriber)ent;
                if (patSub.isSubscriber()) {
                    this.subscriber = patSub;
                } else {
                    this.patient = patSub;
                }
            }
            if (billingProvider == null) continue;
            myClaimTran.billingProvider(billingProvider);
            myClaimTran.addProvider(billingProvider);
            this.billingProvider = billingProvider;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        block11: {
            block14: {
                block13: {
                    block12: {
                        block10: {
                            if (this.seg.isParentOf(seg)) {
                                if (seg.isInType(new SegmentType[]{SegmentType.DTP, SegmentType.AMT, SegmentType.QTY, SegmentType.REF, SegmentType.NTE, SegmentType.CL1, SegmentType.K3})) {
                                    Claim.mapper.populate(this, seg);
                                }
                                if (seg.isInType(new SegmentType[]{SegmentType.REF})) {
                                    EdiTransaction.mapper.populate(this.transaction, seg);
                                }
                            }
                            if ((ent = seg.entity()) instanceof ServiceLine) {
                                line = (ServiceLine)ent;
                                if (this.seg.isAncestorOf(seg)) {
                                    this.addLine(line);
                                }
                            }
                            if (!(ent instanceof Attachment)) break block10;
                            attachment = (Attachment)ent;
                            if (!this.seg.isParentOf(seg)) break block10;
                            this.attachments = CollectionUtils.addWithInit(this.attachments, attachment);
                            break block11;
                        }
                        if (!(ent instanceof PatientSubscriber) || !(sub = (PatientSubscriber)ent).isSubscriber() || !this.seg.isParentOf(seg)) break block12;
                        this.otherSubscribers = CollectionUtils.addWithInit(this.otherSubscribers, sub);
                        break block11;
                    }
                    if (!(ent instanceof OrgOrPerson) || !(prov = (OrgOrPerson)ent).entityRole().isProvider() || !this.seg.isParentOf(seg)) break block13;
                    this.claimTransaction.addProvider(prov);
                    this.addProvider(prov);
                    break block11;
                }
                if (!(ent instanceof ToothStatus)) break block14;
                toothStatus = (ToothStatus)ent;
                if (!this.seg.isParentOf(seg)) break block14;
                this.toothStatuses = CollectionUtils.addWithInit(this.toothStatuses, toothStatus);
                break block11;
            }
            if (!(ent instanceof OrthodonticInfo)) ** GOTO lbl-1000
            orthoInfo = (OrthodonticInfo)ent;
            if (this.seg.isParentOf(seg)) {
                this.orthodonticInfo = orthoInfo;
            } else if (ent instanceof DateTimePeriod && (dateTimePeriod = (DateTimePeriod)ent).type() == DateType.SERVICE && this.seg.isParentOf(seg)) {
                this.serviceDateFrom = dateTimePeriod.date();
                this.serviceDateTo = dateTimePeriod.dateTo();
                if (this.serviceDateTo == null) {
                    this.serviceDateTo = this.serviceDateFrom;
                }
            }
        }
        if (seg.isInType(new SegmentType[]{SegmentType.HI}) && this.seg.isParentOf(seg)) {
            seg.codeEntityConsumer((Consumer<CodeEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addCodeEntity(hdi.codeent.CodeEntity ), (Lhdi/codeent/CodeEntity;)V)((Claim)this));
        }
    }

    public List<CodeEntity> allCodeEntities() {
        ArrayList<CodeEntity> allCodeEntities = new ArrayList<CodeEntity>(this.allClaimLevelCodeEntities());
        for (ServiceLine l : this.lines) {
            allCodeEntities.addAll(l.allCodeEntities());
        }
        return allCodeEntities;
    }

    public List<CodeEntity> allClaimLevelCodeEntities() {
        ArrayList<CodeEntity> allCodeEntities = new ArrayList<CodeEntity>();
        CollectionUtils.addIfNotNull(allCodeEntities, this.diags);
        CollectionUtils.addIfNotNull(allCodeEntities, this.procs);
        CollectionUtils.addIfNotNull(allCodeEntities, this.occurrences);
        CollectionUtils.addIfNotNull(allCodeEntities, this.occurrenceSpans);
        CollectionUtils.addIfNotNull(allCodeEntities, this.conditions);
        CollectionUtils.addIfNotNull(allCodeEntities, this.valueInfos);
        CollectionUtils.addIfNotNull(allCodeEntities, this.frequencyCode);
        CollectionUtils.addIfNotNull(allCodeEntities, this.facilityCode);
        CollectionUtils.addIfNotNull(allCodeEntities, this.drg);
        return allCodeEntities;
    }

    public List<CodeEntity> procCodeEntities() {
        return this.allCodeEntities().stream().filter(codeEntity -> codeEntity.subType() instanceof ProcType).collect(Collectors.toList());
    }

    @EdiElt(seg="K3", pos=1)
    public void addFixedFormatRecord(String record) {
        this.fixedFormatRecords = CollectionUtils.addWithInit(this.fixedFormatRecords, record);
    }

    public Claim claimNote(String note) {
        this.claimNote = this.claimNote == null ? note : this.claimNote + "\n" + note;
        return this;
    }

    public void addDiagCodes(List<String> diagCodes) {
        diagCodes.forEach(this::addDiagCode);
    }

    public CodeEntity addDiagCode(String diagCode) {
        DiagType type = DiagType.ICD_10;
        if (this.diags == null || this.diags.isEmpty()) {
            type = DiagType.ICD_10_PRINCIPAL;
        }
        CodeEntity diag = new CodeEntity(PrimaryCodeType.DIAGNOSIS, type, diagCode);
        this.addCodeEntity(diag);
        return diag;
    }

    public void addCodeEntity(CodeEntity codeEntity) {
        if (codeEntity.subType() instanceof DiagType) {
            if (this.diags == null) {
                this.diags = new ArrayList<CodeEntity>();
            }
            this.diags.add(codeEntity);
            if (this.lines != null) {
                for (ServiceLine line : this.lines) {
                    line.addDiag(codeEntity, this.diags.size() - 1);
                }
            }
        }
        if (codeEntity.subType() instanceof ProcType) {
            if (codeEntity.subType() == ProcType.ICD_10_PCS || codeEntity.subType() == ProcType.ICD_10_PCS_PRINCIPAL || codeEntity.subType() == ProcType.HCPCS_PRINCIPAL) {
                if (this.procs == null) {
                    this.procs = new ArrayList<CodeEntity>();
                }
                this.procs.add(codeEntity);
            }
        } else if (codeEntity.subType() == UbCodeType.OCCURRENCE) {
            if (this.occurrences == null) {
                this.occurrences = new ArrayList<CodeEntity>();
            }
            this.occurrences.add(codeEntity);
        } else if (codeEntity.subType() == UbCodeType.OCCURRENCE_SPAN) {
            if (this.occurrenceSpans == null) {
                this.occurrenceSpans = new ArrayList<CodeEntity>();
            }
            this.occurrenceSpans.add(codeEntity);
        } else if (codeEntity.subType() == UbCodeType.CONDITION) {
            if (this.conditions == null) {
                this.conditions = new ArrayList<CodeEntity>();
            }
            this.conditions.add(codeEntity);
        } else if (codeEntity.subType() == UbCodeType.VALUE) {
            if (this.valueInfos == null) {
                this.valueInfos = new ArrayList<CodeEntity>();
            }
            this.valueInfos.add(codeEntity);
        } else if (codeEntity.subType() == UbCodeType.DRG) {
            this.drg = codeEntity;
        }
    }

    public String summaryStringAsParent() {
        return "Claim " + this.summaryString();
    }

    public BigDecimal totalLinesChargeAmount() {
        BigDecimal amt = new BigDecimal("0.00");
        for (ServiceLine line : this.lines) {
            if (line.chargeAmount() == null) continue;
            amt = amt.add(line.chargeAmount());
        }
        return amt;
    }

    @Override
    public void prepForPersistence() {
        super.prepForPersistence();
        if (this.dateFrom == null && this.transaction != null) {
            this.dateFrom = this.transaction.creationDate();
        }
        this.prepSourceClaimId();
        List<CodeEntity> allCodeEnts = this.allCodeEntities();
        if (this.claimTransaction.billingProvider() != null && this.claimTransaction.billingProvider().providerTaxonomy() != null) {
            allCodeEnts.add(this.claimTransaction.billingProvider().providerTaxonomy());
        }
        this.prepNormalizedCodeEnts(allCodeEnts);
        this.claimTransaction.codeEnts(this.codeEnts);
        this.codeEnts = null;
        this.claimTransaction.prepForPersistence();
        this.searchWords = this.prepSearchWords();
        this.lineCount = 0;
        if (this.lines != null) {
            this.lineCount = this.lines.size();
        }
    }

    @Override
    protected Set<String> prepSearchWords() {
        Set<String> tokens = super.prepSearchWords();
        tokens.add(this.referralNumber);
        tokens.add(this.priorAuthorizationNumber);
        tokens.add(this.sourceClaimId);
        tokens.add(this.clearinghouseTraceNumber);
        tokens.addAll(SearchWordsUtils.tokenizeTextFields(this.claimNote));
        tokens.add(this.medicalRecordNumber);
        tokens.add(this.peerReviewAuthorizationNumber);
        tokens.add(this.patientStatusCode);
        List<NormalizedCodeEntity> normalizedCodeEnts = this.claimTransaction.codeEnts();
        if (normalizedCodeEnts != null && !normalizedCodeEnts.isEmpty()) {
            for (NormalizedCodeEntity codeEnt : normalizedCodeEnts) {
                tokens.addAll(codeEnt.searchWords());
            }
        }
        return tokens;
    }

    private void prepSourceClaimId() {
        if (this.sourceClaimId == null) {
            this.sourceClaimId = this.patientControlNumber;
        }
    }

    public List<CodeEntity> diags() {
        return CollectionUtils.getOrEmpty(this.diags);
    }

    public List<CodeEntity> procs() {
        return CollectionUtils.getOrEmpty(this.procs);
    }

    public List<CodeEntity> occurrences() {
        return CollectionUtils.getOrEmpty(this.occurrences);
    }

    public List<CodeEntity> occurrenceSpans() {
        return CollectionUtils.getOrEmpty(this.occurrenceSpans);
    }

    public List<CodeEntity> valueInfos() {
        return CollectionUtils.getOrEmpty(this.valueInfos);
    }

    public List<CodeEntity> conditions() {
        return CollectionUtils.getOrEmpty(this.conditions);
    }

    public List<Attachment> attachments() {
        return CollectionUtils.getOrEmpty(this.attachments);
    }

    @JsonIgnore
    public CodeEntity getPrincipalDiagnosis() {
        if (this.diags == null) {
            return null;
        }
        for (CodeEntity codeEntity : this.diags) {
            if (!this.isPrincipalDiag(codeEntity)) continue;
            return codeEntity;
        }
        return null;
    }

    @JsonIgnore
    public CodeEntity getDiagByType(DiagType type) {
        return this.getCodeEntByType(this.diags, type);
    }

    @JsonIgnore
    public CodeEntity getProcByType(ProcType type) {
        return this.getCodeEntByType(this.procs, type);
    }

    @JsonIgnore
    public List<CodeEntity> getDiagsByType(DiagType type) {
        return this.getCodeEntsByType(this.diags, type);
    }

    @JsonIgnore
    public List<CodeEntity> getProcsByType(ProcType type) {
        return this.getCodeEntsByType(this.procs, type);
    }

    public CodeEntity getCodeEntByType(List<CodeEntity> codeEntities, EdiQualifier type) {
        if (codeEntities == null) {
            return null;
        }
        CodeEntity codeEntity = null;
        List<CodeEntity> matchingDiags = this.getCodeEntsByType(codeEntities, type);
        if (!matchingDiags.isEmpty()) {
            codeEntity = matchingDiags.get(0);
        }
        return codeEntity;
    }

    public List<CodeEntity> getCodeEntsByType(List<CodeEntity> codeEntities, EdiQualifier type) {
        if (codeEntities == null) {
            return List.of();
        }
        ArrayList<CodeEntity> matchingProcs = new ArrayList<CodeEntity>();
        for (CodeEntity codeEntity : codeEntities) {
            if (codeEntity.subType() == null || !codeEntity.subType().equals(type)) continue;
            matchingProcs.add(codeEntity);
        }
        return matchingProcs;
    }

    private boolean isPrincipalDiag(CodeEntity codeEntity) {
        return codeEntity.subType() instanceof DiagType && codeEntity.subType() == DiagType.ICD_10_PRINCIPAL;
    }

    public void addProvider(OrgOrPerson provider) {
        if (this.providers == null) {
            this.providers = new LinkedHashSet<OrgOrPerson>();
        }
        this.providers.add(provider);
    }

    @Override
    public void prepForApi() {
        if (this.isLoadedFromDb()) {
            this.id = this.claimTransaction.id();
            this.billingProvider = this.claimTransaction.billingProvider();
            this.copyProvsFromClaimTran();
        } else {
            this.generateId();
        }
        if (this.billingProvider != null && this.billingProvider.providerTaxonomy() != null) {
            this.billingProvider.providerTaxonomy().trimNiceToHave();
        }
        if (this.providers != null) {
            for (OrgOrPerson p : this.providers) {
                if (p.providerTaxonomy() == null) continue;
                p.providerTaxonomy().trimNiceToHave();
            }
        }
        if (this.frequencyCode != null) {
            this.frequencyCode.trimNiceToHave();
        }
        this.dateFrom = null;
        this.dateTo = null;
        this.allCodeEntities().forEach(CodeEntity::trimNiceToHave);
        this.prepLineDiagsForApi();
        if (this.otherSubscribers != null) {
            for (PatientSubscriber sub : this.otherSubscribers) {
                this.prepSubscriberForApi(sub);
            }
        }
    }

    private void prepSubscriberForApi(PatientSubscriber subscriber) {
        if (subscriber.adjustments() != null) {
            for (Adjustment adj : subscriber.adjustments()) {
                if (adj.reason() == null) continue;
                adj.reason().trimNiceToHave();
            }
        }
    }

    public void copyProvsFromClaimTran() {
        if (this.claimTransaction != null) {
            this.providers = null;
            for (OrgOrPerson p : this.claimTransaction.providers()) {
                if (p.entityRole() == EntityRole.BILLING_PROVIDER) continue;
                this.addProvider(p);
            }
        }
    }

    private boolean isLoadedFromDb() {
        return this.claimTransaction != null && this.claimTransaction.id() != null;
    }

    public OrgOrPerson findRenderingOrAttending() {
        OrgOrPerson prov = ProvidersUtils.findClaimProvider(EntityRole.ATTENDING, this.claimTransaction);
        if (prov == null) {
            prov = ProvidersUtils.findClaimProvider(EntityRole.RENDERING, this.claimTransaction);
        }
        return prov;
    }

    @Override
    public OrgOrPerson getProvider(EntityRole entityRole) {
        return ProvidersUtils.findProvider(entityRole, this.providers);
    }

    public Set<OrgOrPerson> providers() {
        if (this.providers == null) {
            return Set.of();
        }
        return this.providers;
    }

    @JsonIgnore
    @Generated
    public Claim seg(EdiSeg seg) {
        this.seg = seg;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim transactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Generated
    public Claim providerSignatureIndicator(String providerSignatureIndicator) {
        this.providerSignatureIndicator = providerSignatureIndicator;
        return this;
    }

    @Generated
    public Claim assignmentParticipationCode(String assignmentParticipationCode) {
        this.assignmentParticipationCode = assignmentParticipationCode;
        return this;
    }

    @Generated
    public Claim assignmentCertificationIndicator(String assignmentCertificationIndicator) {
        this.assignmentCertificationIndicator = assignmentCertificationIndicator;
        return this;
    }

    @Generated
    public Claim releaseOfInformationCode(String releaseOfInformationCode) {
        this.releaseOfInformationCode = releaseOfInformationCode;
        return this;
    }

    @Generated
    public Claim specialProgramCode(String specialProgramCode) {
        this.specialProgramCode = specialProgramCode;
        return this;
    }

    @Generated
    public Claim delayReasonCode(String delayReasonCode) {
        this.delayReasonCode = delayReasonCode;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim sourceClaimId(String sourceClaimId) {
        this.sourceClaimId = sourceClaimId;
        return this;
    }

    @Generated
    public Claim sourceClaimVersionId(String sourceClaimVersionId) {
        this.sourceClaimVersionId = sourceClaimVersionId;
        return this;
    }

    @Generated
    public Claim paidDate(LocalDate paidDate) {
        this.paidDate = paidDate;
        return this;
    }

    @Generated
    public Claim serviceAuthorizationExceptionCode(String serviceAuthorizationExceptionCode) {
        this.serviceAuthorizationExceptionCode = serviceAuthorizationExceptionCode;
        return this;
    }

    @Generated
    public Claim referralNumber(String referralNumber) {
        this.referralNumber = referralNumber;
        return this;
    }

    @Generated
    public Claim priorAuthorizationNumber(String priorAuthorizationNumber) {
        this.priorAuthorizationNumber = priorAuthorizationNumber;
        return this;
    }

    @Generated
    public Claim originalReferenceNumber(String originalReferenceNumber) {
        this.originalReferenceNumber = originalReferenceNumber;
        return this;
    }

    @Generated
    public Claim repricedReferenceNumber(String repricedReferenceNumber) {
        this.repricedReferenceNumber = repricedReferenceNumber;
        return this;
    }

    @Generated
    public Claim adjustedRepricedReferenceNumber(String adjustedRepricedReferenceNumber) {
        this.adjustedRepricedReferenceNumber = adjustedRepricedReferenceNumber;
        return this;
    }

    @Generated
    public Claim clearinghouseTraceNumber(String clearinghouseTraceNumber) {
        this.clearinghouseTraceNumber = clearinghouseTraceNumber;
        return this;
    }

    @Generated
    public Claim accidentState(String accidentState) {
        this.accidentState = accidentState;
        return this;
    }

    @Generated
    public Claim medicalRecordNumber(String medicalRecordNumber) {
        this.medicalRecordNumber = medicalRecordNumber;
        return this;
    }

    @Generated
    public Claim peerReviewAuthorizationNumber(String peerReviewAuthorizationNumber) {
        this.peerReviewAuthorizationNumber = peerReviewAuthorizationNumber;
        return this;
    }

    @Generated
    public Claim demonstrationProjectIdentifier(String demonstrationProjectIdentifier) {
        this.demonstrationProjectIdentifier = demonstrationProjectIdentifier;
        return this;
    }

    @Generated
    public Claim onsetOfCurrentIllnessOrInjuryDate(LocalDate onsetOfCurrentIllnessOrInjuryDate) {
        this.onsetOfCurrentIllnessOrInjuryDate = onsetOfCurrentIllnessOrInjuryDate;
        return this;
    }

    @Generated
    public Claim initialTreatmentDate(LocalDate initialTreatmentDate) {
        this.initialTreatmentDate = initialTreatmentDate;
        return this;
    }

    @Generated
    public Claim lastSeenDate(LocalDate lastSeenDate) {
        this.lastSeenDate = lastSeenDate;
        return this;
    }

    @Generated
    public Claim acuteManifestationDate(LocalDate acuteManifestationDate) {
        this.acuteManifestationDate = acuteManifestationDate;
        return this;
    }

    @Generated
    public Claim accidentDate(LocalDate accidentDate) {
        this.accidentDate = accidentDate;
        return this;
    }

    @Generated
    public Claim orthodonticBandingDate(LocalDate orthodonticBandingDate) {
        this.orthodonticBandingDate = orthodonticBandingDate;
        return this;
    }

    @Generated
    public Claim lastMenstrualPeriodDate(LocalDate lastMenstrualPeriodDate) {
        this.lastMenstrualPeriodDate = lastMenstrualPeriodDate;
        return this;
    }

    @Generated
    public Claim lastXRayDate(LocalDate lastXRayDate) {
        this.lastXRayDate = lastXRayDate;
        return this;
    }

    @Generated
    public Claim prescriptionDate(LocalDate prescriptionDate) {
        this.prescriptionDate = prescriptionDate;
        return this;
    }

    @Generated
    public Claim disabilityDateFrom(LocalDate disabilityDateFrom) {
        this.disabilityDateFrom = disabilityDateFrom;
        return this;
    }

    @Generated
    public Claim disabilityDateTo(LocalDate disabilityDateTo) {
        this.disabilityDateTo = disabilityDateTo;
        return this;
    }

    @Generated
    public Claim lastWorkedDate(LocalDate lastWorkedDate) {
        this.lastWorkedDate = lastWorkedDate;
        return this;
    }

    @Generated
    public Claim authorizedReturnToWorkDate(LocalDate authorizedReturnToWorkDate) {
        this.authorizedReturnToWorkDate = authorizedReturnToWorkDate;
        return this;
    }

    @Generated
    public Claim admissionDate(LocalDate admissionDate) {
        this.admissionDate = admissionDate;
        return this;
    }

    @Generated
    public Claim dischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
        return this;
    }

    @Generated
    public Claim assumedCareDate(LocalDate assumedCareDate) {
        this.assumedCareDate = assumedCareDate;
        return this;
    }

    @Generated
    public Claim relinquishedCareDate(LocalDate relinquishedCareDate) {
        this.relinquishedCareDate = relinquishedCareDate;
        return this;
    }

    @Generated
    public Claim propertyCasualtyFirstContactDate(LocalDate propertyCasualtyFirstContactDate) {
        this.propertyCasualtyFirstContactDate = propertyCasualtyFirstContactDate;
        return this;
    }

    @Generated
    public Claim admissionDateAndHour(LocalDateTime admissionDateAndHour) {
        this.admissionDateAndHour = admissionDateAndHour;
        return this;
    }

    @Generated
    public Claim dischargeTime(LocalTime dischargeTime) {
        this.dischargeTime = dischargeTime;
        return this;
    }

    @Generated
    public Claim repricerReceivedDate(LocalDate repricerReceivedDate) {
        this.repricerReceivedDate = repricerReceivedDate;
        return this;
    }

    @Generated
    public Claim orthodonticInfo(OrthodonticInfo orthodonticInfo) {
        this.orthodonticInfo = orthodonticInfo;
        return this;
    }

    @Generated
    public Claim toothStatuses(List<ToothStatus> toothStatuses) {
        this.toothStatuses = toothStatuses;
        return this;
    }

    @Generated
    public Claim admissionTypeCode(String admissionTypeCode) {
        this.admissionTypeCode = admissionTypeCode;
        return this;
    }

    @Generated
    public Claim admissionSourceCode(String admissionSourceCode) {
        this.admissionSourceCode = admissionSourceCode;
        return this;
    }

    @Generated
    public Claim patientStatusCode(String patientStatusCode) {
        this.patientStatusCode = patientStatusCode;
        return this;
    }

    @Generated
    public Claim patientResponsibilityAmount(BigDecimal patientResponsibilityAmount) {
        this.patientResponsibilityAmount = patientResponsibilityAmount;
        return this;
    }

    @Generated
    public Claim predeterminationOfBenefitsIdentifier(String predeterminationOfBenefitsIdentifier) {
        this.predeterminationOfBenefitsIdentifier = predeterminationOfBenefitsIdentifier;
        return this;
    }

    @Generated
    public Claim fixedFormatRecords(List<String> fixedFormatRecords) {
        this.fixedFormatRecords = fixedFormatRecords;
        return this;
    }

    @Generated
    public Claim billingNote(String billingNote) {
        this.billingNote = billingNote;
        return this;
    }

    @Generated
    public Claim billingProvider(OrgOrPerson billingProvider) {
        this.billingProvider = billingProvider;
        return this;
    }

    @Generated
    public Claim providers(Set<OrgOrPerson> providers) {
        this.providers = providers;
        return this;
    }

    @Generated
    public Claim diags(List<CodeEntity> diags) {
        this.diags = diags;
        return this;
    }

    @Generated
    public Claim drg(CodeEntity drg) {
        this.drg = drg;
        return this;
    }

    @Generated
    public Claim procs(List<CodeEntity> procs) {
        this.procs = procs;
        return this;
    }

    @Generated
    public Claim occurrenceSpans(List<CodeEntity> occurrenceSpans) {
        this.occurrenceSpans = occurrenceSpans;
        return this;
    }

    @Generated
    public Claim occurrences(List<CodeEntity> occurrences) {
        this.occurrences = occurrences;
        return this;
    }

    @Generated
    public Claim valueInfos(List<CodeEntity> valueInfos) {
        this.valueInfos = valueInfos;
        return this;
    }

    @Generated
    public Claim conditions(List<CodeEntity> conditions) {
        this.conditions = conditions;
        return this;
    }

    @Generated
    public Claim attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim lineCount(int lineCount) {
        this.lineCount = lineCount;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim checkTimestamp(LocalDateTime checkTimestamp) {
        this.checkTimestamp = checkTimestamp;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim claimTransaction(ClaimTransaction claimTransaction) {
        this.claimTransaction = claimTransaction;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim tags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    @JsonIgnore
    @Generated
    public Claim searchWords(Set<String> searchWords) {
        this.searchWords = searchWords;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "Claim(super=" + super.toString() + ", transactionType=" + String.valueOf((Object)this.transactionType()) + ", providerSignatureIndicator=" + this.providerSignatureIndicator() + ", assignmentParticipationCode=" + this.assignmentParticipationCode() + ", assignmentCertificationIndicator=" + this.assignmentCertificationIndicator() + ", releaseOfInformationCode=" + this.releaseOfInformationCode() + ", specialProgramCode=" + this.specialProgramCode() + ", delayReasonCode=" + this.delayReasonCode() + ", sourceClaimId=" + this.sourceClaimId() + ", sourceClaimVersionId=" + this.sourceClaimVersionId() + ", paidDate=" + String.valueOf(this.paidDate()) + ", serviceAuthorizationExceptionCode=" + this.serviceAuthorizationExceptionCode() + ", referralNumber=" + this.referralNumber() + ", priorAuthorizationNumber=" + this.priorAuthorizationNumber() + ", originalReferenceNumber=" + this.originalReferenceNumber() + ", repricedReferenceNumber=" + this.repricedReferenceNumber() + ", adjustedRepricedReferenceNumber=" + this.adjustedRepricedReferenceNumber() + ", clearinghouseTraceNumber=" + this.clearinghouseTraceNumber() + ", accidentState=" + this.accidentState() + ", medicalRecordNumber=" + this.medicalRecordNumber() + ", peerReviewAuthorizationNumber=" + this.peerReviewAuthorizationNumber() + ", demonstrationProjectIdentifier=" + this.demonstrationProjectIdentifier() + ", onsetOfCurrentIllnessOrInjuryDate=" + String.valueOf(this.onsetOfCurrentIllnessOrInjuryDate()) + ", initialTreatmentDate=" + String.valueOf(this.initialTreatmentDate()) + ", lastSeenDate=" + String.valueOf(this.lastSeenDate()) + ", acuteManifestationDate=" + String.valueOf(this.acuteManifestationDate()) + ", accidentDate=" + String.valueOf(this.accidentDate()) + ", orthodonticBandingDate=" + String.valueOf(this.orthodonticBandingDate()) + ", lastMenstrualPeriodDate=" + String.valueOf(this.lastMenstrualPeriodDate()) + ", lastXRayDate=" + String.valueOf(this.lastXRayDate()) + ", prescriptionDate=" + String.valueOf(this.prescriptionDate()) + ", disabilityDateFrom=" + String.valueOf(this.disabilityDateFrom()) + ", disabilityDateTo=" + String.valueOf(this.disabilityDateTo()) + ", lastWorkedDate=" + String.valueOf(this.lastWorkedDate()) + ", authorizedReturnToWorkDate=" + String.valueOf(this.authorizedReturnToWorkDate()) + ", admissionDate=" + String.valueOf(this.admissionDate()) + ", dischargeDate=" + String.valueOf(this.dischargeDate()) + ", assumedCareDate=" + String.valueOf(this.assumedCareDate()) + ", relinquishedCareDate=" + String.valueOf(this.relinquishedCareDate()) + ", propertyCasualtyFirstContactDate=" + String.valueOf(this.propertyCasualtyFirstContactDate()) + ", admissionDateAndHour=" + String.valueOf(this.admissionDateAndHour()) + ", dischargeTime=" + String.valueOf(this.dischargeTime()) + ", repricerReceivedDate=" + String.valueOf(this.repricerReceivedDate()) + ", orthodonticInfo=" + String.valueOf(this.orthodonticInfo()) + ", toothStatuses=" + String.valueOf(this.toothStatuses()) + ", admissionTypeCode=" + this.admissionTypeCode() + ", admissionSourceCode=" + this.admissionSourceCode() + ", patientStatusCode=" + this.patientStatusCode() + ", patientResponsibilityAmount=" + String.valueOf(this.patientResponsibilityAmount()) + ", predeterminationOfBenefitsIdentifier=" + this.predeterminationOfBenefitsIdentifier() + ", fixedFormatRecords=" + String.valueOf(this.fixedFormatRecords()) + ", claimNote=" + this.claimNote() + ", billingNote=" + this.billingNote() + ", billingProvider=" + String.valueOf(this.billingProvider()) + ", providers=" + String.valueOf(this.providers()) + ", diags=" + String.valueOf(this.diags()) + ", drg=" + String.valueOf(this.drg()) + ", procs=" + String.valueOf(this.procs()) + ", occurrenceSpans=" + String.valueOf(this.occurrenceSpans()) + ", occurrences=" + String.valueOf(this.occurrences()) + ", valueInfos=" + String.valueOf(this.valueInfos()) + ", conditions=" + String.valueOf(this.conditions()) + ", attachments=" + String.valueOf(this.attachments()) + ", lineCount=" + this.lineCount() + ", checkTimestamp=" + String.valueOf(this.checkTimestamp()) + ", tags=" + String.valueOf(this.tags()) + ", searchWords=" + String.valueOf(this.searchWords()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Claim)) {
            return false;
        }
        Claim other = (Claim)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransactionType this$transactionType = this.transactionType();
        TransactionType other$transactionType = other.transactionType();
        return !(this$transactionType == null ? other$transactionType != null : !((Object)((Object)this$transactionType)).equals((Object)other$transactionType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Claim;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TransactionType $transactionType = this.transactionType();
        result = result * 59 + ($transactionType == null ? 43 : ((Object)((Object)$transactionType)).hashCode());
        return result;
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @JsonIgnore
    @Generated
    public TransactionType transactionType() {
        return this.transactionType;
    }

    @Generated
    public String providerSignatureIndicator() {
        return this.providerSignatureIndicator;
    }

    @Generated
    public String assignmentParticipationCode() {
        return this.assignmentParticipationCode;
    }

    @Generated
    public String assignmentCertificationIndicator() {
        return this.assignmentCertificationIndicator;
    }

    @Generated
    public String releaseOfInformationCode() {
        return this.releaseOfInformationCode;
    }

    @Generated
    public String specialProgramCode() {
        return this.specialProgramCode;
    }

    @Generated
    public String delayReasonCode() {
        return this.delayReasonCode;
    }

    @Generated
    public String sourceClaimVersionId() {
        return this.sourceClaimVersionId;
    }

    @Generated
    public LocalDate paidDate() {
        return this.paidDate;
    }

    @Generated
    public String serviceAuthorizationExceptionCode() {
        return this.serviceAuthorizationExceptionCode;
    }

    @Generated
    public String referralNumber() {
        return this.referralNumber;
    }

    @Generated
    public String priorAuthorizationNumber() {
        return this.priorAuthorizationNumber;
    }

    @Generated
    public String originalReferenceNumber() {
        return this.originalReferenceNumber;
    }

    @Generated
    public String repricedReferenceNumber() {
        return this.repricedReferenceNumber;
    }

    @Generated
    public String adjustedRepricedReferenceNumber() {
        return this.adjustedRepricedReferenceNumber;
    }

    @Generated
    public String clearinghouseTraceNumber() {
        return this.clearinghouseTraceNumber;
    }

    @Generated
    public String accidentState() {
        return this.accidentState;
    }

    @Generated
    public String medicalRecordNumber() {
        return this.medicalRecordNumber;
    }

    @Generated
    public String peerReviewAuthorizationNumber() {
        return this.peerReviewAuthorizationNumber;
    }

    @Generated
    public String demonstrationProjectIdentifier() {
        return this.demonstrationProjectIdentifier;
    }

    @Generated
    public LocalDate onsetOfCurrentIllnessOrInjuryDate() {
        return this.onsetOfCurrentIllnessOrInjuryDate;
    }

    @Generated
    public LocalDate initialTreatmentDate() {
        return this.initialTreatmentDate;
    }

    @Generated
    public LocalDate lastSeenDate() {
        return this.lastSeenDate;
    }

    @Generated
    public LocalDate acuteManifestationDate() {
        return this.acuteManifestationDate;
    }

    @Generated
    public LocalDate accidentDate() {
        return this.accidentDate;
    }

    @Generated
    public LocalDate orthodonticBandingDate() {
        return this.orthodonticBandingDate;
    }

    @Generated
    public LocalDate lastMenstrualPeriodDate() {
        return this.lastMenstrualPeriodDate;
    }

    @Generated
    public LocalDate lastXRayDate() {
        return this.lastXRayDate;
    }

    @Generated
    public LocalDate prescriptionDate() {
        return this.prescriptionDate;
    }

    @Generated
    public LocalDate disabilityDateFrom() {
        return this.disabilityDateFrom;
    }

    @Generated
    public LocalDate disabilityDateTo() {
        return this.disabilityDateTo;
    }

    @Generated
    public LocalDate lastWorkedDate() {
        return this.lastWorkedDate;
    }

    @Generated
    public LocalDate authorizedReturnToWorkDate() {
        return this.authorizedReturnToWorkDate;
    }

    @Generated
    public LocalDate admissionDate() {
        return this.admissionDate;
    }

    @Generated
    public LocalDate dischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public LocalDate assumedCareDate() {
        return this.assumedCareDate;
    }

    @Generated
    public LocalDate relinquishedCareDate() {
        return this.relinquishedCareDate;
    }

    @Generated
    public LocalDate propertyCasualtyFirstContactDate() {
        return this.propertyCasualtyFirstContactDate;
    }

    @Generated
    public LocalDateTime admissionDateAndHour() {
        return this.admissionDateAndHour;
    }

    @Generated
    public LocalTime dischargeTime() {
        return this.dischargeTime;
    }

    @Generated
    public LocalDate repricerReceivedDate() {
        return this.repricerReceivedDate;
    }

    @Generated
    public OrthodonticInfo orthodonticInfo() {
        return this.orthodonticInfo;
    }

    @Generated
    public List<ToothStatus> toothStatuses() {
        return this.toothStatuses;
    }

    @Generated
    public String admissionTypeCode() {
        return this.admissionTypeCode;
    }

    @Generated
    public String admissionSourceCode() {
        return this.admissionSourceCode;
    }

    @Generated
    public String patientStatusCode() {
        return this.patientStatusCode;
    }

    @Generated
    public BigDecimal patientResponsibilityAmount() {
        return this.patientResponsibilityAmount;
    }

    @Generated
    public String predeterminationOfBenefitsIdentifier() {
        return this.predeterminationOfBenefitsIdentifier;
    }

    @Generated
    public List<String> fixedFormatRecords() {
        return this.fixedFormatRecords;
    }

    @Generated
    public String claimNote() {
        return this.claimNote;
    }

    @Generated
    public String billingNote() {
        return this.billingNote;
    }

    @Generated
    public OrgOrPerson billingProvider() {
        return this.billingProvider;
    }

    @Generated
    public CodeEntity drg() {
        return this.drg;
    }

    @JsonIgnore
    @Generated
    public int lineCount() {
        return this.lineCount;
    }

    @JsonIgnore
    @Generated
    public LocalDateTime checkTimestamp() {
        return this.checkTimestamp;
    }

    @JsonIgnore
    @Generated
    public ClaimTransaction claimTransaction() {
        return this.claimTransaction;
    }

    @JsonIgnore
    @Generated
    public Set<String> tags() {
        return this.tags;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }
}

