/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.claim;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import hdi.codeent.NormalizedCodeEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.ProvidersUtils;
import hdi.model.ServiceLine;
import hdi.model.claim.Claim;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClaimTransaction
implements EdiEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClaimTransaction.class);
    @EdiElt.Exclude
    @JsonIgnore
    private String id;
    @EdiElt.Exclude
    @JsonIgnore
    private List<NormalizedCodeEntity> codeEnts = new ArrayList<NormalizedCodeEntity>();
    @JsonIgnore
    private BigDecimal chargeAmount = new BigDecimal("0.0");
    @EdiElt.Exclude
    @JsonIgnore
    private Claim claim;
    @EdiElt.Exclude
    @JsonIgnore
    private Set<OrgOrPerson> providers = new LinkedHashSet<OrgOrPerson>();
    @JsonIgnore
    private OrgOrPerson billingProvider;
    @LastModifiedDate
    private LocalDateTime updateTimestamp;
    @CreatedDate
    private LocalDateTime createTimestamp;

    public void addProvider(OrgOrPerson prov) {
        this.providers.add(prov);
    }

    public Claim claim() {
        if (this.claim != null) {
            this.claim.claimTransaction(this);
        }
        return this.claim;
    }

    public List<ServiceLine> lines() {
        List<ServiceLine> lines = List.of();
        if (this.claim() != null) {
            lines = this.claim().lines();
        }
        return lines;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults ediParsingResults) {
    }

    @Override
    public String summaryString() {
        return this.claim.summaryString();
    }

    public void prepForPersistence() {
        this.id = ObjectId.get().toHexString();
        this.createTimestamp = LocalDateTime.now();
        this.populateProvidersPatientsLineCount();
        for (OrgOrPerson prov : this.providers) {
            prov.prepForPersistence();
        }
    }

    public OrgOrPerson billingProvider() {
        if (this.billingProvider != null) {
            return this.billingProvider;
        }
        return this.findBillingProvider();
    }

    private OrgOrPerson findBillingProvider() {
        return ProvidersUtils.findClaimProvider(EntityRole.BILLING_PROVIDER, this);
    }

    public boolean hasClaimOrLineProvider(EntityRole entityRole) {
        if (this.claim() == null || this.claim().lines() == null || this.claim().lines().isEmpty()) {
            return ProvidersUtils.findClaimProvider(entityRole, this) != null;
        }
        for (ServiceLine line : this.claim().lines()) {
            if (ProvidersUtils.findLineOrClaimProvider(entityRole, line, this) == null) continue;
            return true;
        }
        return false;
    }

    private void populateProvidersPatientsLineCount() {
        int count = this.lines().size();
        for (OrgOrPerson orgOrPerson : this.providers) {
            orgOrPerson.lineCount(count);
        }
    }

    public FileInfo fileInfo() {
        if (this.claim() == null) {
            return null;
        }
        return this.claim().transaction().fileInfo();
    }

    public LocalDateTime getCreationDateTime() {
        if (this.claim() == null) {
            return null;
        }
        return this.claim().transaction().getCreationDateTime();
    }

    public LocalTime creationTime() {
        if (this.claim() == null) {
            return null;
        }
        return this.claim().transaction().creationTime();
    }

    @JsonIgnore
    @Generated
    public String id() {
        return this.id;
    }

    @JsonIgnore
    @Generated
    public List<NormalizedCodeEntity> codeEnts() {
        return this.codeEnts;
    }

    @JsonIgnore
    @Generated
    public BigDecimal chargeAmount() {
        return this.chargeAmount;
    }

    @JsonIgnore
    @Generated
    public Set<OrgOrPerson> providers() {
        return this.providers;
    }

    @Generated
    public LocalDateTime updateTimestamp() {
        return this.updateTimestamp;
    }

    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimTransaction)) {
            return false;
        }
        ClaimTransaction other = (ClaimTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimTransaction(id=" + this.id() + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", claim=" + String.valueOf(this.claim()) + ", providers=" + String.valueOf(this.providers()) + ", billingProvider=" + String.valueOf(this.billingProvider()) + ", updateTimestamp=" + String.valueOf(this.updateTimestamp()) + ", createTimestamp=" + String.valueOf(this.createTimestamp()) + ")";
    }

    @JsonIgnore
    @Generated
    public ClaimTransaction codeEnts(List<NormalizedCodeEntity> codeEnts) {
        this.codeEnts = codeEnts;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimTransaction chargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimTransaction claim(Claim claim) {
        this.claim = claim;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimTransaction billingProvider(OrgOrPerson billingProvider) {
        this.billingProvider = billingProvider;
        return this;
    }
}

