/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.claim.ambulance;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum AmbulanceConditionCode implements EdiQualifier
{
    HOSPITAL("01", "Patient was admitted to a hospital"),
    STRETCHER("04", "Patient was moved by stretcher"),
    UNCONSCIOUS("05", "Patient was unconscious or in shock"),
    EMERGENCY("06", "Patient was transported in an emergency situation"),
    RESTRAINED("07", "Patient had to be physically restrained"),
    HEMORR("08", "Patient had visible hemorrhaging"),
    MEDICALLY_NECESSARY("09", "Ambulance service was medically necessary"),
    CONFINED_TO_BED("12", "Patient is confined to a bed or chair");

    private final String ediValue;
    private final String desc;

    public static AmbulanceConditionCode fromEdi(String ediCode) {
        for (AmbulanceConditionCode v : AmbulanceConditionCode.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private AmbulanceConditionCode(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

