/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.claim.ambulance;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum AmbulanceTransportReason implements EdiQualifier
{
    NEAREST_FACILITY("A", "Patient was transported to nearest facility for care of symptoms, complaints, or both"),
    RESIDENTIAL_FACILITY("618", "patient was transferred to a residential facility"),
    PHYSICIAN("B", "Patient was transported for the benefit of a preferred physician"),
    FAMILY_MEMBER("C", "Patient was transported for the nearness of family members"),
    SPECIALIST("D", "Patient was transported for the care of a specialist or for availability of specialized equipment"),
    REHAB("E", "Patient Transferred to Rehabilitation Facility");

    private final String ediValue;
    private final String desc;

    public static AmbulanceTransportReason fromEdi(String ediCode) {
        for (AmbulanceTransportReason v : AmbulanceTransportReason.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private AmbulanceTransportReason(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

