/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.control;

import hdi.edi.dict.annotations.Prop;
import hdi.edi.parser.TransactionType;
import java.time.LocalDate;
import java.time.LocalTime;
import lombok.Generated;

public class FunctionalGroup {
    @Prop(edi={"GS01"}, minWidth=2, maxWidth=2)
    private String functionalIdentifierCode;
    @Prop(edi={"GS02"}, minWidth=2, maxWidth=15)
    private String senderCode;
    @Prop(edi={"GS03"}, minWidth=2, maxWidth=15)
    private String receiverCode;
    @Prop(edi={"GS04"})
    private LocalDate date;
    @Prop(edi={"GS05"})
    private LocalTime time;
    @Prop(edi={"GS06"})
    private Integer controlNumber;
    @Prop(edi={"GS07"})
    private String responsibleAgencyCode = "X";
    @Prop(edi={"GS08"})
    private String version;

    public FunctionalGroup(TransactionType transactionType, String senderCode, String receiverCode) {
        this.senderCode = senderCode;
        this.receiverCode = receiverCode;
        this.date = LocalDate.now();
        this.time = LocalTime.now();
        this.functionalIdentifierCode = transactionType.functionalIdentifierCode();
        this.version = "005010X" + transactionType.subTypeCode() + "A1";
    }

    public FunctionalGroup(FunctionalGroup other) {
        this.functionalIdentifierCode = other.functionalIdentifierCode;
        this.senderCode = other.senderCode;
        this.receiverCode = other.receiverCode;
        this.date = other.date;
        this.time = other.time;
        this.controlNumber = other.controlNumber;
        this.responsibleAgencyCode = other.responsibleAgencyCode;
        this.version = other.version;
    }

    @Generated
    public String functionalIdentifierCode() {
        return this.functionalIdentifierCode;
    }

    @Generated
    public String senderCode() {
        return this.senderCode;
    }

    @Generated
    public String receiverCode() {
        return this.receiverCode;
    }

    @Generated
    public LocalDate date() {
        return this.date;
    }

    @Generated
    public LocalTime time() {
        return this.time;
    }

    @Generated
    public Integer controlNumber() {
        return this.controlNumber;
    }

    @Generated
    public String responsibleAgencyCode() {
        return this.responsibleAgencyCode;
    }

    @Generated
    public String version() {
        return this.version;
    }

    @Generated
    public FunctionalGroup functionalIdentifierCode(String functionalIdentifierCode) {
        this.functionalIdentifierCode = functionalIdentifierCode;
        return this;
    }

    @Generated
    public FunctionalGroup senderCode(String senderCode) {
        this.senderCode = senderCode;
        return this;
    }

    @Generated
    public FunctionalGroup receiverCode(String receiverCode) {
        this.receiverCode = receiverCode;
        return this;
    }

    @Generated
    public FunctionalGroup date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Generated
    public FunctionalGroup time(LocalTime time) {
        this.time = time;
        return this;
    }

    @Generated
    public FunctionalGroup controlNumber(Integer controlNumber) {
        this.controlNumber = controlNumber;
        return this;
    }

    @Generated
    public FunctionalGroup responsibleAgencyCode(String responsibleAgencyCode) {
        this.responsibleAgencyCode = responsibleAgencyCode;
        return this;
    }

    @Generated
    public FunctionalGroup version(String version) {
        this.version = version;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionalGroup)) {
            return false;
        }
        FunctionalGroup other = (FunctionalGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$controlNumber = this.controlNumber();
        Integer other$controlNumber = other.controlNumber();
        if (this$controlNumber == null ? other$controlNumber != null : !((Object)this$controlNumber).equals(other$controlNumber)) {
            return false;
        }
        String this$functionalIdentifierCode = this.functionalIdentifierCode();
        String other$functionalIdentifierCode = other.functionalIdentifierCode();
        if (this$functionalIdentifierCode == null ? other$functionalIdentifierCode != null : !this$functionalIdentifierCode.equals(other$functionalIdentifierCode)) {
            return false;
        }
        String this$senderCode = this.senderCode();
        String other$senderCode = other.senderCode();
        if (this$senderCode == null ? other$senderCode != null : !this$senderCode.equals(other$senderCode)) {
            return false;
        }
        String this$receiverCode = this.receiverCode();
        String other$receiverCode = other.receiverCode();
        if (this$receiverCode == null ? other$receiverCode != null : !this$receiverCode.equals(other$receiverCode)) {
            return false;
        }
        LocalDate this$date = this.date();
        LocalDate other$date = other.date();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        LocalTime this$time = this.time();
        LocalTime other$time = other.time();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$responsibleAgencyCode = this.responsibleAgencyCode();
        String other$responsibleAgencyCode = other.responsibleAgencyCode();
        if (this$responsibleAgencyCode == null ? other$responsibleAgencyCode != null : !this$responsibleAgencyCode.equals(other$responsibleAgencyCode)) {
            return false;
        }
        String this$version = this.version();
        String other$version = other.version();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionalGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $controlNumber = this.controlNumber();
        result = result * 59 + ($controlNumber == null ? 43 : ((Object)$controlNumber).hashCode());
        String $functionalIdentifierCode = this.functionalIdentifierCode();
        result = result * 59 + ($functionalIdentifierCode == null ? 43 : $functionalIdentifierCode.hashCode());
        String $senderCode = this.senderCode();
        result = result * 59 + ($senderCode == null ? 43 : $senderCode.hashCode());
        String $receiverCode = this.receiverCode();
        result = result * 59 + ($receiverCode == null ? 43 : $receiverCode.hashCode());
        LocalDate $date = this.date();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        LocalTime $time = this.time();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $responsibleAgencyCode = this.responsibleAgencyCode();
        result = result * 59 + ($responsibleAgencyCode == null ? 43 : $responsibleAgencyCode.hashCode());
        String $version = this.version();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FunctionalGroup(functionalIdentifierCode=" + this.functionalIdentifierCode() + ", senderCode=" + this.senderCode() + ", receiverCode=" + this.receiverCode() + ", date=" + String.valueOf(this.date()) + ", time=" + String.valueOf(this.time()) + ", controlNumber=" + this.controlNumber() + ", responsibleAgencyCode=" + this.responsibleAgencyCode() + ", version=" + this.version() + ")";
    }
}

