/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.csv.CsvUtils;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.Amount;
import hdi.model.DateTimePeriod;
import hdi.model.Reference;
import hdi.model.coverage.ChangeReason;
import hdi.model.coverage.CoordinationOfBenefits;
import hdi.model.coverage.IdCard;
import hdi.model.coverage.MemberCoverage;
import hdi.model.coverage.ProviderWithChangeReason;
import hdi.model.enumtype.ReferenceType;
import hdi.util.CollectionUtils;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2300"}, seg={"HD"})
public class HealthCoverage
extends BaseEdiEntity {
    @EdiElt(pos=1, seg="HD")
    private String maintenanceTypeCode;
    @EdiElt(pos=3, seg="HD")
    private String insuranceLineCode;
    @EdiElt(pos=4, seg="HD")
    private String planDescription;
    @EdiElt(pos=5, seg="HD")
    private String coverageLevelCode;
    @EdiElt(pos=9, seg="HD")
    private String lateEnrollmentIndicator;
    @Prop(objType=ObjType.DATE)
    private List<DateTimePeriod> coverageDates;
    @Prop(objType=ObjType.AMOUNT)
    private List<Amount> contractAmounts;
    @Prop(objType=ObjType.REFERENCE)
    private List<Reference> groupOrPolicyNumbers;
    @EdiElt.Exclude
    @Prop(refType={ReferenceType.UNIT_NUMBER})
    private String priorCoverageMonthCount;
    private List<IdCard> idCards;
    @Prop(objType=ObjType.PARTY)
    private List<ProviderWithChangeReason> providers;
    @Prop(objType=ObjType.COB, desc={"Coordination of Benefits"})
    private List<CoordinationOfBenefits> cobs;

    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiEntity segEnt = seg.entity();
        if (this.seg.isParentOf(seg)) {
            if (segEnt instanceof DateTimePeriod) {
                DateTimePeriod dateTimePeriod = (DateTimePeriod)segEnt;
                this.coverageDates = CollectionUtils.addWithInit(this.coverageDates, dateTimePeriod);
            } else if (segEnt instanceof Amount) {
                Amount amount = (Amount)segEnt;
                this.contractAmounts = CollectionUtils.addWithInit(this.contractAmounts, amount);
            } else if (segEnt instanceof CoordinationOfBenefits) {
                CoordinationOfBenefits cob = (CoordinationOfBenefits)segEnt;
                this.cobs = CollectionUtils.addWithInit(this.cobs, cob);
            } else if (segEnt instanceof IdCard) {
                IdCard idCard = (IdCard)segEnt;
                this.idCards = CollectionUtils.addWithInit(this.idCards, idCard);
            } else if (segEnt instanceof Reference) {
                Reference reference = (Reference)segEnt;
                if (reference.type() == ReferenceType.UNIT_NUMBER) {
                    this.priorCoverageMonthCount = reference.identification();
                } else {
                    this.groupOrPolicyNumbers = CollectionUtils.addWithInit(this.groupOrPolicyNumbers, reference);
                }
            }
        }
        if (this.seg.isAncestorOf(seg) && segEnt instanceof ProviderWithChangeReason) {
            ProviderWithChangeReason provider = (ProviderWithChangeReason)segEnt;
            this.providers = CollectionUtils.addWithInit(this.providers, provider);
        }
    }

    void prepForCsv() {
        this.coverageDates = CsvUtils.prepList(this.coverageDates, new DateTimePeriod());
        this.contractAmounts = CsvUtils.prepList(this.contractAmounts, new Amount());
        this.groupOrPolicyNumbers = CsvUtils.prepReferenceList(this.groupOrPolicyNumbers);
        this.providers = CsvUtils.prepList(this.providers, new ProviderWithChangeReason());
        this.providers.forEach(this::prepProvider);
        this.cobs = CsvUtils.prepList(this.cobs, new CoordinationOfBenefits());
        this.cobs.forEach(CoordinationOfBenefits::prepForCsv);
        this.idCards = CsvUtils.prepList(this.idCards, new IdCard());
    }

    private void prepProvider(ProviderWithChangeReason provider) {
        MemberCoverage.prepOrgOrPersonWithAddressAndContacts(provider);
        if (provider.changeReason() == null) {
            provider.changeReason(new ChangeReason());
        }
    }

    @Generated
    public String maintenanceTypeCode() {
        return this.maintenanceTypeCode;
    }

    @Generated
    public String insuranceLineCode() {
        return this.insuranceLineCode;
    }

    @Generated
    public String planDescription() {
        return this.planDescription;
    }

    @Generated
    public String coverageLevelCode() {
        return this.coverageLevelCode;
    }

    @Generated
    public String lateEnrollmentIndicator() {
        return this.lateEnrollmentIndicator;
    }

    @Generated
    public List<DateTimePeriod> coverageDates() {
        return this.coverageDates;
    }

    @Generated
    public List<Amount> contractAmounts() {
        return this.contractAmounts;
    }

    @Generated
    public List<Reference> groupOrPolicyNumbers() {
        return this.groupOrPolicyNumbers;
    }

    @Generated
    public String priorCoverageMonthCount() {
        return this.priorCoverageMonthCount;
    }

    @Generated
    public List<IdCard> idCards() {
        return this.idCards;
    }

    @Generated
    public List<ProviderWithChangeReason> providers() {
        return this.providers;
    }

    @Generated
    public List<CoordinationOfBenefits> cobs() {
        return this.cobs;
    }

    @Generated
    public String toString() {
        return "HealthCoverage(maintenanceTypeCode=" + this.maintenanceTypeCode() + ", insuranceLineCode=" + this.insuranceLineCode() + ", planDescription=" + this.planDescription() + ", coverageLevelCode=" + this.coverageLevelCode() + ", lateEnrollmentIndicator=" + this.lateEnrollmentIndicator() + ", coverageDates=" + String.valueOf(this.coverageDates()) + ", contractAmounts=" + String.valueOf(this.contractAmounts()) + ", groupOrPolicyNumbers=" + String.valueOf(this.groupOrPolicyNumbers()) + ", priorCoverageMonthCount=" + this.priorCoverageMonthCount() + ", idCards=" + String.valueOf(this.idCards()) + ", providers=" + String.valueOf(this.providers()) + ", cobs=" + String.valueOf(this.cobs()) + ")";
    }
}

