/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.CsvUtils;
import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.Amount;
import hdi.model.ClaimOrPayment;
import hdi.model.DateTimePeriod;
import hdi.model.ObjectType;
import hdi.model.Reference;
import hdi.model.RootObj;
import hdi.model.coverage.Disability;
import hdi.model.coverage.HealthCoverage;
import hdi.model.coverage.Member;
import hdi.model.coverage.ReportingCategory;
import hdi.model.coverage.TpaWithAccountInfo;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.Address;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.util.CollectionUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2000"}, seg={"INS"}, desc={"Main object for 834, contains the member and their health coverage information."}, jsonExample={"834/834-all-fields"}, csvExample={"834/834-all-fields"}, interactiveExample={"834/834-all-fields/"})
public class MemberCoverage
implements EdiEntity,
RootObj {
    private static final EdiObjectMapper<MemberCoverage> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    private String id = ObjectId.get().toHexString();
    @EdiElt.Exclude
    protected ObjectType objectType = ObjectType.MEMBER_COVERAGE;
    @EdiElt.Exclude
    private String fileName;
    @EdiElt.Exclude
    @Prop(edi={"ST02"}, variantTypes={VariantType.CSV})
    private String transactionControlNumber;
    @EdiElt.Exclude
    @Prop(edi={"BGN01"}, variantTypes={VariantType.CSV})
    private String transactionSetPurposeCode;
    @EdiElt.Exclude
    @Prop(edi={"BGN02"}, variantTypes={VariantType.CSV})
    private String originatorApplicationTransactionId;
    @EdiElt.Exclude
    @Prop(edi={"BGN03,BGN04"}, variantTypes={VariantType.CSV})
    private LocalDateTime transactionCreationDateTime;
    @EdiElt.Exclude
    @Prop(edi={"BGN08"}, variantTypes={VariantType.CSV})
    private String transactionActionCode;
    @EdiElt.Exclude
    @Prop(objType=ObjType.DATE)
    private List<DateTimePeriod> fileEffectiveDates;
    @Prop(refType={ReferenceType.MASTER_POLICY_NUMBER})
    private String masterPolicyNumber;
    @EdiElt.Exclude
    @Prop(objType=ObjType.PARTY_ID_NAME, loop={"1000A"})
    private OrgOrPerson sponsor;
    @EdiElt.Exclude
    @Prop(objType=ObjType.PARTY_ID_NAME, loop={"1000B"})
    private OrgOrPerson insurer;
    @Prop(objType=ObjType.TPA, loop={"1000C"})
    private List<TpaWithAccountInfo> tpas;
    @EdiElt(seg="INS", pos=1)
    @Prop(edi={"INS01"})
    private String memberIndicator;
    @EdiElt(seg="INS", pos=2)
    private String relationshipCode;
    @EdiElt(seg="INS", pos=3)
    private String maintenanceTypeCode;
    @EdiElt(seg="INS", pos=4)
    private String maintenanceReasonCode;
    @EdiElt(seg="INS", pos=5)
    private String benefitStatusCode;
    @EdiElt(seg="INS", pos=7)
    private String cobraEventCode;
    @EdiElt(seg="INS", pos=8)
    private String employmentStatusCode;
    @EdiElt(seg="INS", pos=9)
    private String studentStatusCode;
    @EdiElt(seg="INS", pos=10)
    private String handicapIndicator;
    @EdiElt(seg="INS", pos=13)
    private String confidentialityCode;
    @EdiElt(seg="INS", pos=17)
    private Integer birthSequenceNumber;
    @Prop(refType={ReferenceType.SUBSCRIBER_IDENTIFIER}, desc={"Member identifier"})
    @EdiElt(seg="REF", pos=2, qualifier="0F")
    private String identifier;
    @Prop(refType={ReferenceType.GROUP_OR_POLICY_NUMBER})
    @EdiElt(seg="REF", pos=2, qualifier="1L")
    private String groupOrPolicyNumber;
    @Prop(objType=ObjType.REFERENCE)
    private List<Reference> supplementalIdentifiers;
    @Prop(objType=ObjType.DATE)
    private List<DateTimePeriod> statusInfoEffectiveDates;
    @Prop(edi={"NM1"}, entityRole=EntityRole.INSURED_SUBSCRIBER, objType=ObjType.MEMBER, loop={"2100A"})
    private Member member;
    private Member incorrectMember;
    @Prop(objType=ObjType.AMOUNT, desc={"Member policy amounts from the member loop 2100A"})
    private List<Amount> contractAmounts;
    @Prop(objType=ObjType.ADDRESS, desc={"Member mailing address"})
    private Address mailingAddress;
    @Prop(objType=ObjType.PARTY, loop={"2100D"})
    private List<OrgOrPerson> employers;
    @Prop(objType=ObjType.PARTY, loop={"2100E"})
    private List<OrgOrPerson> schools;
    @Prop(objType=ObjType.PARTY, loop={"2100F"})
    private OrgOrPerson custodialParent;
    @Prop(objType=ObjType.PARTY, loop={"2100G"})
    private List<OrgOrPerson> responsiblePersons;
    private OrgOrPerson dropOffLocation;
    private List<Disability> disabilities;
    @Prop(objType=ObjType.REPORTING_CATEGORY, loop={"2750"})
    private List<ReportingCategory> reportingCategories;
    @Prop(objType=ObjType.HEALTH_COVERAGE, loop={"2300"})
    private List<HealthCoverage> healthCoverages;
    @EdiElt.Exclude
    @Prop(masterClass=ClaimOrPayment.class)
    private EdiTransaction transaction;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private EdiSeg seg;

    public MemberCoverage(MemberCoverage other) {
        this.id = ObjectId.get().toHexString();
        this.objectType = other.objectType;
        this.fileName = other.fileName;
        this.transactionControlNumber = other.transactionControlNumber;
        this.transactionSetPurposeCode = other.transactionSetPurposeCode;
        this.originatorApplicationTransactionId = other.originatorApplicationTransactionId;
        this.transactionCreationDateTime = other.transactionCreationDateTime;
        this.transactionActionCode = other.transactionActionCode;
        this.fileEffectiveDates = other.fileEffectiveDates != null ? new ArrayList<DateTimePeriod>(other.fileEffectiveDates) : null;
        this.masterPolicyNumber = other.masterPolicyNumber;
        this.sponsor = other.sponsor;
        this.insurer = other.insurer;
        this.tpas = other.tpas != null ? new ArrayList<TpaWithAccountInfo>(other.tpas) : null;
        this.memberIndicator = other.memberIndicator;
        this.relationshipCode = other.relationshipCode;
        this.maintenanceTypeCode = other.maintenanceTypeCode;
        this.maintenanceReasonCode = other.maintenanceReasonCode;
        this.benefitStatusCode = other.benefitStatusCode;
        this.cobraEventCode = other.cobraEventCode;
        this.employmentStatusCode = other.employmentStatusCode;
        this.studentStatusCode = other.studentStatusCode;
        this.handicapIndicator = other.handicapIndicator;
        this.confidentialityCode = other.confidentialityCode;
        this.birthSequenceNumber = other.birthSequenceNumber;
        this.identifier = other.identifier;
        this.groupOrPolicyNumber = other.groupOrPolicyNumber;
        this.supplementalIdentifiers = other.supplementalIdentifiers != null ? new ArrayList<Reference>(other.supplementalIdentifiers) : null;
        this.statusInfoEffectiveDates = other.statusInfoEffectiveDates != null ? new ArrayList<DateTimePeriod>(other.statusInfoEffectiveDates) : null;
        this.member = other.member;
        this.incorrectMember = other.incorrectMember;
        this.contractAmounts = other.contractAmounts != null ? new ArrayList<Amount>(other.contractAmounts) : null;
        this.mailingAddress = other.mailingAddress;
        this.employers = other.employers != null ? new ArrayList<OrgOrPerson>(other.employers) : null;
        this.schools = other.schools != null ? new ArrayList<OrgOrPerson>(other.schools) : null;
        this.custodialParent = other.custodialParent;
        this.responsiblePersons = other.responsiblePersons != null ? new ArrayList<OrgOrPerson>(other.responsiblePersons) : null;
        this.dropOffLocation = other.dropOffLocation;
        this.disabilities = other.disabilities != null ? new ArrayList<Disability>(other.disabilities) : null;
        this.reportingCategories = other.reportingCategories != null ? new ArrayList<ReportingCategory>(other.reportingCategories) : null;
        this.healthCoverages = other.healthCoverages != null ? new ArrayList<HealthCoverage>(other.healthCoverages) : null;
        this.transaction = other.transaction;
        this.seg = other.seg;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        this.transaction = new EdiTransaction();
        if (results != null) {
            results.memberCoverages().add(this);
            this.sponsor = results.findPartyByRole(EntityRole.PLAN_SPONSOR);
            this.insurer = results.findPartyByRole(EntityRole.INSURER);
            this.tpas = EdiParsingResults.findEntitiesForClass(results, TpaWithAccountInfo.class);
            if (this.tpas.isEmpty()) {
                this.tpas = null;
            }
            if (results.curTransaction() != null) {
                this.transaction = results.curTransaction();
                this.masterPolicyNumber = this.transaction.masterPolicyNumber();
            }
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiEntity segEnt;
        block12: {
            block17: {
                EntityRole entityRole;
                OrgOrPerson party;
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                segEnt = seg.entity();
                                                if (!this.seg.isParentOf(seg)) break block12;
                                                if (!(segEnt instanceof Reference)) break block13;
                                                Reference reference = (Reference)segEnt;
                                                if (reference.type() == ReferenceType.SUBSCRIBER_IDENTIFIER) {
                                                    this.identifier = reference.identification();
                                                    break block12;
                                                } else if (reference.type() == ReferenceType.GROUP_OR_POLICY_NUMBER) {
                                                    this.groupOrPolicyNumber = reference.identification();
                                                    break block12;
                                                } else {
                                                    this.supplementalIdentifiers = CollectionUtils.addWithInit(this.supplementalIdentifiers, reference);
                                                }
                                                break block12;
                                            }
                                            if (!(segEnt instanceof DateTimePeriod)) break block14;
                                            DateTimePeriod dateTimePeriod = (DateTimePeriod)segEnt;
                                            this.statusInfoEffectiveDates = CollectionUtils.addWithInit(this.statusInfoEffectiveDates, dateTimePeriod);
                                            break block12;
                                        }
                                        if (!(segEnt instanceof Member)) break block15;
                                        Member party2 = (Member)segEnt;
                                        if (party2.entityRole() == EntityRole.PRIOR_INCORRECT_INSURED) {
                                            this.incorrectMember = party2;
                                            break block12;
                                        } else {
                                            this.member = party2;
                                        }
                                        break block12;
                                    }
                                    if (!(segEnt instanceof Disability)) break block16;
                                    Disability disability = (Disability)segEnt;
                                    this.disabilities = CollectionUtils.addWithInit(this.disabilities, disability);
                                    break block12;
                                }
                                if (!(segEnt instanceof OrgOrPerson)) break block17;
                                party = (OrgOrPerson)segEnt;
                                entityRole = party.entityRole();
                                if (entityRole != EntityRole.MAILING_ADDRESS) break block18;
                                this.mailingAddress = party.address();
                                break block12;
                            }
                            if (entityRole != EntityRole.EMPLOYER) break block19;
                            this.employers = CollectionUtils.addWithInit(this.employers, party);
                            break block12;
                        }
                        if (entityRole != EntityRole.EDUCATIONAL_INSTITUTION) break block20;
                        this.schools = CollectionUtils.addWithInit(this.schools, party);
                        break block12;
                    }
                    if (entityRole != EntityRole.CUSTODIAL_PARENT) break block21;
                    this.custodialParent = party;
                    break block12;
                }
                if ("2100G".equals(seg.loop())) {
                    this.responsiblePersons = CollectionUtils.addWithInit(this.responsiblePersons, party);
                    break block12;
                } else if (entityRole == EntityRole.DROP_OFF_LOCATION) {
                    this.dropOffLocation = party;
                }
                break block12;
            }
            if (segEnt instanceof HealthCoverage) {
                HealthCoverage healthCoverage = (HealthCoverage)segEnt;
                this.healthCoverages = CollectionUtils.addWithInit(this.healthCoverages, healthCoverage);
            }
        }
        if (!this.seg.isAncestorOf(seg)) return;
        if (segEnt instanceof Amount) {
            Amount amount = (Amount)segEnt;
            if (StringUtils.equalsIgnoreCase((CharSequence)seg.loop(), (CharSequence)"2100A")) {
                this.contractAmounts = CollectionUtils.addWithInit(this.contractAmounts, amount);
                return;
            }
        }
        if (!(segEnt instanceof ReportingCategory)) return;
        ReportingCategory reportingCategory = (ReportingCategory)segEnt;
        this.reportingCategories = CollectionUtils.addWithInit(this.reportingCategories, reportingCategory);
    }

    public void prepForCsv() {
        if (this.transaction == null) {
            this.transaction = new EdiTransaction();
        }
        if (this.transaction.fileInfo() != null) {
            this.fileName = this.transaction.fileInfo().name();
        }
        this.transactionControlNumber = this.transaction.controlNumber();
        this.transactionSetPurposeCode = this.transaction.purposeCode();
        this.originatorApplicationTransactionId = this.transaction.originatorApplicationTransactionId();
        this.transactionCreationDateTime = this.transaction.getCreationDateTime();
        this.transactionActionCode = this.transaction.actionCode();
        this.fileEffectiveDates = CsvUtils.prepList(this.transaction.fileEffectiveDates(), new DateTimePeriod());
        this.transaction = null;
        this.tpas = CollectionUtils.addWithInit(this.tpas, new TpaWithAccountInfo());
        this.sponsor = CsvUtils.prepOrgOrPerson(this.sponsor, EntityRole.PLAN_SPONSOR);
        this.insurer = CsvUtils.prepOrgOrPerson(this.insurer, EntityRole.INSURER);
        this.supplementalIdentifiers = CsvUtils.prepReferenceList(this.supplementalIdentifiers);
        this.statusInfoEffectiveDates = CsvUtils.prepList(this.statusInfoEffectiveDates, new DateTimePeriod());
        this.member = this.prepMember(this.member);
        if (this.incorrectMember == null) {
            this.incorrectMember = new Member();
        }
        this.contractAmounts = CsvUtils.prepList(this.contractAmounts, new Amount());
        if (this.mailingAddress == null) {
            this.mailingAddress = new Address();
        }
        this.employers = MemberCoverage.prepPartyWithContactsList(this.employers);
        this.schools = MemberCoverage.prepPartyWithContactsList(this.schools);
        this.custodialParent = CsvUtils.prepOrgOrPerson(this.custodialParent, EntityRole.CUSTODIAL_PARENT);
        this.responsiblePersons = MemberCoverage.prepPartyWithContactsList(this.responsiblePersons);
        this.dropOffLocation = CsvUtils.prepOrgOrPerson(this.dropOffLocation, EntityRole.DROP_OFF_LOCATION);
        this.healthCoverages = CsvUtils.prepList(this.healthCoverages, new HealthCoverage());
        this.healthCoverages.forEach(HealthCoverage::prepForCsv);
        this.disabilities = CsvUtils.prepList(this.disabilities, new Disability());
        this.reportingCategories = CsvUtils.prepList(this.reportingCategories, new ReportingCategory());
    }

    private Member prepMember(Member member) {
        if (member == null) {
            member = new Member();
        }
        member.prepForCsv();
        return member;
    }

    static List<OrgOrPerson> prepPartyWithContactsList(List<OrgOrPerson> orgOrPersons) {
        if (orgOrPersons == null) {
            orgOrPersons = new ArrayList<OrgOrPerson>();
            orgOrPersons.add(new OrgOrPerson());
        }
        for (OrgOrPerson orgOrPerson : orgOrPersons) {
            MemberCoverage.prepOrgOrPersonWithAddressAndContacts(orgOrPerson);
        }
        return orgOrPersons;
    }

    static void prepOrgOrPersonWithAddressAndContacts(OrgOrPerson orgOrPerson) {
        if (orgOrPerson.address() == null) {
            orgOrPerson.address(new Address());
        }
        CsvUtils.prepContactInfo(orgOrPerson);
        orgOrPerson.additionalIds(null);
    }

    public List<HealthCoverage> healthCoverages() {
        return this.healthCoverages != null ? this.healthCoverages : List.of();
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Generated
    public String masterPolicyNumber() {
        return this.masterPolicyNumber;
    }

    @Generated
    public OrgOrPerson sponsor() {
        return this.sponsor;
    }

    @Generated
    public OrgOrPerson insurer() {
        return this.insurer;
    }

    @Generated
    public List<TpaWithAccountInfo> tpas() {
        return this.tpas;
    }

    @Generated
    public String memberIndicator() {
        return this.memberIndicator;
    }

    @Generated
    public String relationshipCode() {
        return this.relationshipCode;
    }

    @Generated
    public String maintenanceTypeCode() {
        return this.maintenanceTypeCode;
    }

    @Generated
    public String maintenanceReasonCode() {
        return this.maintenanceReasonCode;
    }

    @Generated
    public String benefitStatusCode() {
        return this.benefitStatusCode;
    }

    @Generated
    public String cobraEventCode() {
        return this.cobraEventCode;
    }

    @Generated
    public String employmentStatusCode() {
        return this.employmentStatusCode;
    }

    @Generated
    public String studentStatusCode() {
        return this.studentStatusCode;
    }

    @Generated
    public String handicapIndicator() {
        return this.handicapIndicator;
    }

    @Generated
    public String confidentialityCode() {
        return this.confidentialityCode;
    }

    @Generated
    public Integer birthSequenceNumber() {
        return this.birthSequenceNumber;
    }

    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Generated
    public String groupOrPolicyNumber() {
        return this.groupOrPolicyNumber;
    }

    @Generated
    public List<Reference> supplementalIdentifiers() {
        return this.supplementalIdentifiers;
    }

    @Generated
    public List<DateTimePeriod> statusInfoEffectiveDates() {
        return this.statusInfoEffectiveDates;
    }

    @Generated
    public Member member() {
        return this.member;
    }

    @Generated
    public Member incorrectMember() {
        return this.incorrectMember;
    }

    @Generated
    public List<Amount> contractAmounts() {
        return this.contractAmounts;
    }

    @Generated
    public Address mailingAddress() {
        return this.mailingAddress;
    }

    @Generated
    public List<OrgOrPerson> employers() {
        return this.employers;
    }

    @Generated
    public List<OrgOrPerson> schools() {
        return this.schools;
    }

    @Generated
    public OrgOrPerson custodialParent() {
        return this.custodialParent;
    }

    @Generated
    public List<OrgOrPerson> responsiblePersons() {
        return this.responsiblePersons;
    }

    @Generated
    public OrgOrPerson dropOffLocation() {
        return this.dropOffLocation;
    }

    @Generated
    public List<Disability> disabilities() {
        return this.disabilities;
    }

    @Generated
    public List<ReportingCategory> reportingCategories() {
        return this.reportingCategories;
    }

    @Generated
    public String toString() {
        return "MemberCoverage(masterPolicyNumber=" + this.masterPolicyNumber() + ", sponsor=" + String.valueOf(this.sponsor()) + ", insurer=" + String.valueOf(this.insurer()) + ", tpas=" + String.valueOf(this.tpas()) + ", memberIndicator=" + this.memberIndicator() + ", relationshipCode=" + this.relationshipCode() + ", maintenanceTypeCode=" + this.maintenanceTypeCode() + ", maintenanceReasonCode=" + this.maintenanceReasonCode() + ", benefitStatusCode=" + this.benefitStatusCode() + ", cobraEventCode=" + this.cobraEventCode() + ", employmentStatusCode=" + this.employmentStatusCode() + ", studentStatusCode=" + this.studentStatusCode() + ", handicapIndicator=" + this.handicapIndicator() + ", confidentialityCode=" + this.confidentialityCode() + ", birthSequenceNumber=" + this.birthSequenceNumber() + ", identifier=" + this.identifier() + ", groupOrPolicyNumber=" + this.groupOrPolicyNumber() + ", supplementalIdentifiers=" + String.valueOf(this.supplementalIdentifiers()) + ", statusInfoEffectiveDates=" + String.valueOf(this.statusInfoEffectiveDates()) + ", member=" + String.valueOf(this.member()) + ", incorrectMember=" + String.valueOf(this.incorrectMember()) + ", contractAmounts=" + String.valueOf(this.contractAmounts()) + ", mailingAddress=" + String.valueOf(this.mailingAddress()) + ", employers=" + String.valueOf(this.employers()) + ", schools=" + String.valueOf(this.schools()) + ", custodialParent=" + String.valueOf(this.custodialParent()) + ", responsiblePersons=" + String.valueOf(this.responsiblePersons()) + ", dropOffLocation=" + String.valueOf(this.dropOffLocation()) + ", disabilities=" + String.valueOf(this.disabilities()) + ", reportingCategories=" + String.valueOf(this.reportingCategories()) + ", healthCoverages=" + String.valueOf(this.healthCoverages()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemberCoverage)) {
            return false;
        }
        MemberCoverage other = (MemberCoverage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$birthSequenceNumber = this.birthSequenceNumber();
        Integer other$birthSequenceNumber = other.birthSequenceNumber();
        if (this$birthSequenceNumber == null ? other$birthSequenceNumber != null : !((Object)this$birthSequenceNumber).equals(other$birthSequenceNumber)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ObjectType this$objectType = this.objectType();
        ObjectType other$objectType = other.objectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        String this$fileName = this.fileName;
        String other$fileName = other.fileName;
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$transactionControlNumber = this.transactionControlNumber;
        String other$transactionControlNumber = other.transactionControlNumber;
        if (this$transactionControlNumber == null ? other$transactionControlNumber != null : !this$transactionControlNumber.equals(other$transactionControlNumber)) {
            return false;
        }
        String this$transactionSetPurposeCode = this.transactionSetPurposeCode;
        String other$transactionSetPurposeCode = other.transactionSetPurposeCode;
        if (this$transactionSetPurposeCode == null ? other$transactionSetPurposeCode != null : !this$transactionSetPurposeCode.equals(other$transactionSetPurposeCode)) {
            return false;
        }
        String this$originatorApplicationTransactionId = this.originatorApplicationTransactionId;
        String other$originatorApplicationTransactionId = other.originatorApplicationTransactionId;
        if (this$originatorApplicationTransactionId == null ? other$originatorApplicationTransactionId != null : !this$originatorApplicationTransactionId.equals(other$originatorApplicationTransactionId)) {
            return false;
        }
        LocalDateTime this$transactionCreationDateTime = this.transactionCreationDateTime;
        LocalDateTime other$transactionCreationDateTime = other.transactionCreationDateTime;
        if (this$transactionCreationDateTime == null ? other$transactionCreationDateTime != null : !((Object)this$transactionCreationDateTime).equals(other$transactionCreationDateTime)) {
            return false;
        }
        String this$transactionActionCode = this.transactionActionCode;
        String other$transactionActionCode = other.transactionActionCode;
        if (this$transactionActionCode == null ? other$transactionActionCode != null : !this$transactionActionCode.equals(other$transactionActionCode)) {
            return false;
        }
        List<DateTimePeriod> this$fileEffectiveDates = this.fileEffectiveDates;
        List<DateTimePeriod> other$fileEffectiveDates = other.fileEffectiveDates;
        if (this$fileEffectiveDates == null ? other$fileEffectiveDates != null : !((Object)this$fileEffectiveDates).equals(other$fileEffectiveDates)) {
            return false;
        }
        String this$masterPolicyNumber = this.masterPolicyNumber();
        String other$masterPolicyNumber = other.masterPolicyNumber();
        if (this$masterPolicyNumber == null ? other$masterPolicyNumber != null : !this$masterPolicyNumber.equals(other$masterPolicyNumber)) {
            return false;
        }
        OrgOrPerson this$sponsor = this.sponsor();
        OrgOrPerson other$sponsor = other.sponsor();
        if (this$sponsor == null ? other$sponsor != null : !((Object)this$sponsor).equals(other$sponsor)) {
            return false;
        }
        OrgOrPerson this$insurer = this.insurer();
        OrgOrPerson other$insurer = other.insurer();
        if (this$insurer == null ? other$insurer != null : !((Object)this$insurer).equals(other$insurer)) {
            return false;
        }
        List<TpaWithAccountInfo> this$tpas = this.tpas();
        List<TpaWithAccountInfo> other$tpas = other.tpas();
        if (this$tpas == null ? other$tpas != null : !((Object)this$tpas).equals(other$tpas)) {
            return false;
        }
        String this$memberIndicator = this.memberIndicator();
        String other$memberIndicator = other.memberIndicator();
        if (this$memberIndicator == null ? other$memberIndicator != null : !this$memberIndicator.equals(other$memberIndicator)) {
            return false;
        }
        String this$relationshipCode = this.relationshipCode();
        String other$relationshipCode = other.relationshipCode();
        if (this$relationshipCode == null ? other$relationshipCode != null : !this$relationshipCode.equals(other$relationshipCode)) {
            return false;
        }
        String this$maintenanceTypeCode = this.maintenanceTypeCode();
        String other$maintenanceTypeCode = other.maintenanceTypeCode();
        if (this$maintenanceTypeCode == null ? other$maintenanceTypeCode != null : !this$maintenanceTypeCode.equals(other$maintenanceTypeCode)) {
            return false;
        }
        String this$maintenanceReasonCode = this.maintenanceReasonCode();
        String other$maintenanceReasonCode = other.maintenanceReasonCode();
        if (this$maintenanceReasonCode == null ? other$maintenanceReasonCode != null : !this$maintenanceReasonCode.equals(other$maintenanceReasonCode)) {
            return false;
        }
        String this$benefitStatusCode = this.benefitStatusCode();
        String other$benefitStatusCode = other.benefitStatusCode();
        if (this$benefitStatusCode == null ? other$benefitStatusCode != null : !this$benefitStatusCode.equals(other$benefitStatusCode)) {
            return false;
        }
        String this$cobraEventCode = this.cobraEventCode();
        String other$cobraEventCode = other.cobraEventCode();
        if (this$cobraEventCode == null ? other$cobraEventCode != null : !this$cobraEventCode.equals(other$cobraEventCode)) {
            return false;
        }
        String this$employmentStatusCode = this.employmentStatusCode();
        String other$employmentStatusCode = other.employmentStatusCode();
        if (this$employmentStatusCode == null ? other$employmentStatusCode != null : !this$employmentStatusCode.equals(other$employmentStatusCode)) {
            return false;
        }
        String this$studentStatusCode = this.studentStatusCode();
        String other$studentStatusCode = other.studentStatusCode();
        if (this$studentStatusCode == null ? other$studentStatusCode != null : !this$studentStatusCode.equals(other$studentStatusCode)) {
            return false;
        }
        String this$handicapIndicator = this.handicapIndicator();
        String other$handicapIndicator = other.handicapIndicator();
        if (this$handicapIndicator == null ? other$handicapIndicator != null : !this$handicapIndicator.equals(other$handicapIndicator)) {
            return false;
        }
        String this$confidentialityCode = this.confidentialityCode();
        String other$confidentialityCode = other.confidentialityCode();
        if (this$confidentialityCode == null ? other$confidentialityCode != null : !this$confidentialityCode.equals(other$confidentialityCode)) {
            return false;
        }
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$groupOrPolicyNumber = this.groupOrPolicyNumber();
        String other$groupOrPolicyNumber = other.groupOrPolicyNumber();
        if (this$groupOrPolicyNumber == null ? other$groupOrPolicyNumber != null : !this$groupOrPolicyNumber.equals(other$groupOrPolicyNumber)) {
            return false;
        }
        List<Reference> this$supplementalIdentifiers = this.supplementalIdentifiers();
        List<Reference> other$supplementalIdentifiers = other.supplementalIdentifiers();
        if (this$supplementalIdentifiers == null ? other$supplementalIdentifiers != null : !((Object)this$supplementalIdentifiers).equals(other$supplementalIdentifiers)) {
            return false;
        }
        List<DateTimePeriod> this$statusInfoEffectiveDates = this.statusInfoEffectiveDates();
        List<DateTimePeriod> other$statusInfoEffectiveDates = other.statusInfoEffectiveDates();
        if (this$statusInfoEffectiveDates == null ? other$statusInfoEffectiveDates != null : !((Object)this$statusInfoEffectiveDates).equals(other$statusInfoEffectiveDates)) {
            return false;
        }
        Member this$member = this.member();
        Member other$member = other.member();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        Member this$incorrectMember = this.incorrectMember();
        Member other$incorrectMember = other.incorrectMember();
        if (this$incorrectMember == null ? other$incorrectMember != null : !((Object)this$incorrectMember).equals(other$incorrectMember)) {
            return false;
        }
        List<Amount> this$contractAmounts = this.contractAmounts();
        List<Amount> other$contractAmounts = other.contractAmounts();
        if (this$contractAmounts == null ? other$contractAmounts != null : !((Object)this$contractAmounts).equals(other$contractAmounts)) {
            return false;
        }
        Address this$mailingAddress = this.mailingAddress();
        Address other$mailingAddress = other.mailingAddress();
        if (this$mailingAddress == null ? other$mailingAddress != null : !((Object)this$mailingAddress).equals(other$mailingAddress)) {
            return false;
        }
        List<OrgOrPerson> this$employers = this.employers();
        List<OrgOrPerson> other$employers = other.employers();
        if (this$employers == null ? other$employers != null : !((Object)this$employers).equals(other$employers)) {
            return false;
        }
        List<OrgOrPerson> this$schools = this.schools();
        List<OrgOrPerson> other$schools = other.schools();
        if (this$schools == null ? other$schools != null : !((Object)this$schools).equals(other$schools)) {
            return false;
        }
        OrgOrPerson this$custodialParent = this.custodialParent();
        OrgOrPerson other$custodialParent = other.custodialParent();
        if (this$custodialParent == null ? other$custodialParent != null : !((Object)this$custodialParent).equals(other$custodialParent)) {
            return false;
        }
        List<OrgOrPerson> this$responsiblePersons = this.responsiblePersons();
        List<OrgOrPerson> other$responsiblePersons = other.responsiblePersons();
        if (this$responsiblePersons == null ? other$responsiblePersons != null : !((Object)this$responsiblePersons).equals(other$responsiblePersons)) {
            return false;
        }
        OrgOrPerson this$dropOffLocation = this.dropOffLocation();
        OrgOrPerson other$dropOffLocation = other.dropOffLocation();
        if (this$dropOffLocation == null ? other$dropOffLocation != null : !((Object)this$dropOffLocation).equals(other$dropOffLocation)) {
            return false;
        }
        List<Disability> this$disabilities = this.disabilities();
        List<Disability> other$disabilities = other.disabilities();
        if (this$disabilities == null ? other$disabilities != null : !((Object)this$disabilities).equals(other$disabilities)) {
            return false;
        }
        List<ReportingCategory> this$reportingCategories = this.reportingCategories();
        List<ReportingCategory> other$reportingCategories = other.reportingCategories();
        if (this$reportingCategories == null ? other$reportingCategories != null : !((Object)this$reportingCategories).equals(other$reportingCategories)) {
            return false;
        }
        List<HealthCoverage> this$healthCoverages = this.healthCoverages();
        List<HealthCoverage> other$healthCoverages = other.healthCoverages();
        if (this$healthCoverages == null ? other$healthCoverages != null : !((Object)this$healthCoverages).equals(other$healthCoverages)) {
            return false;
        }
        EdiTransaction this$transaction = this.transaction();
        EdiTransaction other$transaction = other.transaction();
        if (this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction)) {
            return false;
        }
        EdiSeg this$seg = this.seg;
        EdiSeg other$seg = other.seg;
        return !(this$seg == null ? other$seg != null : !((Object)this$seg).equals(other$seg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemberCoverage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $birthSequenceNumber = this.birthSequenceNumber();
        result = result * 59 + ($birthSequenceNumber == null ? 43 : ((Object)$birthSequenceNumber).hashCode());
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ObjectType $objectType = this.objectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        String $fileName = this.fileName;
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $transactionControlNumber = this.transactionControlNumber;
        result = result * 59 + ($transactionControlNumber == null ? 43 : $transactionControlNumber.hashCode());
        String $transactionSetPurposeCode = this.transactionSetPurposeCode;
        result = result * 59 + ($transactionSetPurposeCode == null ? 43 : $transactionSetPurposeCode.hashCode());
        String $originatorApplicationTransactionId = this.originatorApplicationTransactionId;
        result = result * 59 + ($originatorApplicationTransactionId == null ? 43 : $originatorApplicationTransactionId.hashCode());
        LocalDateTime $transactionCreationDateTime = this.transactionCreationDateTime;
        result = result * 59 + ($transactionCreationDateTime == null ? 43 : ((Object)$transactionCreationDateTime).hashCode());
        String $transactionActionCode = this.transactionActionCode;
        result = result * 59 + ($transactionActionCode == null ? 43 : $transactionActionCode.hashCode());
        List<DateTimePeriod> $fileEffectiveDates = this.fileEffectiveDates;
        result = result * 59 + ($fileEffectiveDates == null ? 43 : ((Object)$fileEffectiveDates).hashCode());
        String $masterPolicyNumber = this.masterPolicyNumber();
        result = result * 59 + ($masterPolicyNumber == null ? 43 : $masterPolicyNumber.hashCode());
        OrgOrPerson $sponsor = this.sponsor();
        result = result * 59 + ($sponsor == null ? 43 : ((Object)$sponsor).hashCode());
        OrgOrPerson $insurer = this.insurer();
        result = result * 59 + ($insurer == null ? 43 : ((Object)$insurer).hashCode());
        List<TpaWithAccountInfo> $tpas = this.tpas();
        result = result * 59 + ($tpas == null ? 43 : ((Object)$tpas).hashCode());
        String $memberIndicator = this.memberIndicator();
        result = result * 59 + ($memberIndicator == null ? 43 : $memberIndicator.hashCode());
        String $relationshipCode = this.relationshipCode();
        result = result * 59 + ($relationshipCode == null ? 43 : $relationshipCode.hashCode());
        String $maintenanceTypeCode = this.maintenanceTypeCode();
        result = result * 59 + ($maintenanceTypeCode == null ? 43 : $maintenanceTypeCode.hashCode());
        String $maintenanceReasonCode = this.maintenanceReasonCode();
        result = result * 59 + ($maintenanceReasonCode == null ? 43 : $maintenanceReasonCode.hashCode());
        String $benefitStatusCode = this.benefitStatusCode();
        result = result * 59 + ($benefitStatusCode == null ? 43 : $benefitStatusCode.hashCode());
        String $cobraEventCode = this.cobraEventCode();
        result = result * 59 + ($cobraEventCode == null ? 43 : $cobraEventCode.hashCode());
        String $employmentStatusCode = this.employmentStatusCode();
        result = result * 59 + ($employmentStatusCode == null ? 43 : $employmentStatusCode.hashCode());
        String $studentStatusCode = this.studentStatusCode();
        result = result * 59 + ($studentStatusCode == null ? 43 : $studentStatusCode.hashCode());
        String $handicapIndicator = this.handicapIndicator();
        result = result * 59 + ($handicapIndicator == null ? 43 : $handicapIndicator.hashCode());
        String $confidentialityCode = this.confidentialityCode();
        result = result * 59 + ($confidentialityCode == null ? 43 : $confidentialityCode.hashCode());
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $groupOrPolicyNumber = this.groupOrPolicyNumber();
        result = result * 59 + ($groupOrPolicyNumber == null ? 43 : $groupOrPolicyNumber.hashCode());
        List<Reference> $supplementalIdentifiers = this.supplementalIdentifiers();
        result = result * 59 + ($supplementalIdentifiers == null ? 43 : ((Object)$supplementalIdentifiers).hashCode());
        List<DateTimePeriod> $statusInfoEffectiveDates = this.statusInfoEffectiveDates();
        result = result * 59 + ($statusInfoEffectiveDates == null ? 43 : ((Object)$statusInfoEffectiveDates).hashCode());
        Member $member = this.member();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        Member $incorrectMember = this.incorrectMember();
        result = result * 59 + ($incorrectMember == null ? 43 : ((Object)$incorrectMember).hashCode());
        List<Amount> $contractAmounts = this.contractAmounts();
        result = result * 59 + ($contractAmounts == null ? 43 : ((Object)$contractAmounts).hashCode());
        Address $mailingAddress = this.mailingAddress();
        result = result * 59 + ($mailingAddress == null ? 43 : ((Object)$mailingAddress).hashCode());
        List<OrgOrPerson> $employers = this.employers();
        result = result * 59 + ($employers == null ? 43 : ((Object)$employers).hashCode());
        List<OrgOrPerson> $schools = this.schools();
        result = result * 59 + ($schools == null ? 43 : ((Object)$schools).hashCode());
        OrgOrPerson $custodialParent = this.custodialParent();
        result = result * 59 + ($custodialParent == null ? 43 : ((Object)$custodialParent).hashCode());
        List<OrgOrPerson> $responsiblePersons = this.responsiblePersons();
        result = result * 59 + ($responsiblePersons == null ? 43 : ((Object)$responsiblePersons).hashCode());
        OrgOrPerson $dropOffLocation = this.dropOffLocation();
        result = result * 59 + ($dropOffLocation == null ? 43 : ((Object)$dropOffLocation).hashCode());
        List<Disability> $disabilities = this.disabilities();
        result = result * 59 + ($disabilities == null ? 43 : ((Object)$disabilities).hashCode());
        List<ReportingCategory> $reportingCategories = this.reportingCategories();
        result = result * 59 + ($reportingCategories == null ? 43 : ((Object)$reportingCategories).hashCode());
        List<HealthCoverage> $healthCoverages = this.healthCoverages();
        result = result * 59 + ($healthCoverages == null ? 43 : ((Object)$healthCoverages).hashCode());
        EdiTransaction $transaction = this.transaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        EdiSeg $seg = this.seg;
        result = result * 59 + ($seg == null ? 43 : ((Object)$seg).hashCode());
        return result;
    }

    @Generated
    public MemberCoverage() {
    }

    @Generated
    public MemberCoverage id(String id) {
        this.id = id;
        return this;
    }

    @Override
    @Generated
    public EdiTransaction transaction() {
        return this.transaction;
    }
}

