/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiSeg;
import hdi.model.DateTimePeriod;
import hdi.model.Reference;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.ReferenceType;
import java.time.LocalDate;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ReportingCategory
extends BaseEdiEntity {
    @EdiElt(seg="N1", pos=2)
    private String name;
    @Prop(edi={"REF01"})
    private String identifierQualifierCode;
    @Prop(edi={"REF01"})
    private ReferenceType identifierType;
    @Prop(edi={"REF02"})
    private String identifier;
    @Prop(dateType={DateType.EFFECTIVE}, desc={"Effective date"})
    private LocalDate date;
    @Prop(edi={"DTP03"}, isDerived=true, desc={"End date"})
    private LocalDate dateTo;

    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        if (segEnt instanceof DateTimePeriod) {
            DateTimePeriod dt = (DateTimePeriod)segEnt;
            this.date = dt.date();
            this.dateTo = dt.dateTo();
        }
        if (segEnt instanceof Reference) {
            Reference reference = (Reference)segEnt;
            this.identifier = reference.identification();
            this.identifierQualifierCode = reference.qualifierCode();
            this.identifierType = reference.type();
        }
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String identifierQualifierCode() {
        return this.identifierQualifierCode;
    }

    @Generated
    public ReferenceType identifierType() {
        return this.identifierType;
    }

    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Generated
    public LocalDate date() {
        return this.date;
    }

    @Generated
    public LocalDate dateTo() {
        return this.dateTo;
    }

    @Generated
    public String toString() {
        return "ReportingCategory(name=" + this.name() + ", identifierQualifierCode=" + this.identifierQualifierCode() + ", identifierType=" + String.valueOf(this.identifierType()) + ", identifier=" + this.identifier() + ", date=" + String.valueOf(this.date()) + ", dateTo=" + String.valueOf(this.dateTo()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportingCategory)) {
            return false;
        }
        ReportingCategory other = (ReportingCategory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$identifierQualifierCode = this.identifierQualifierCode();
        String other$identifierQualifierCode = other.identifierQualifierCode();
        if (this$identifierQualifierCode == null ? other$identifierQualifierCode != null : !this$identifierQualifierCode.equals(other$identifierQualifierCode)) {
            return false;
        }
        ReferenceType this$identifierType = this.identifierType();
        ReferenceType other$identifierType = other.identifierType();
        if (this$identifierType == null ? other$identifierType != null : !this$identifierType.equals(other$identifierType)) {
            return false;
        }
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        LocalDate this$date = this.date();
        LocalDate other$date = other.date();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        LocalDate this$dateTo = this.dateTo();
        LocalDate other$dateTo = other.dateTo();
        return !(this$dateTo == null ? other$dateTo != null : !((Object)this$dateTo).equals(other$dateTo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReportingCategory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $identifierQualifierCode = this.identifierQualifierCode();
        result = result * 59 + ($identifierQualifierCode == null ? 43 : $identifierQualifierCode.hashCode());
        ReferenceType $identifierType = this.identifierType();
        result = result * 59 + ($identifierType == null ? 43 : $identifierType.hashCode());
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        LocalDate $date = this.date();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        LocalDate $dateTo = this.dateTo();
        result = result * 59 + ($dateTo == null ? 43 : ((Object)$dateTo).hashCode());
        return result;
    }
}

