/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.X12CodeTypeEnt;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum AmountType implements EdiQualifier
{
    PATIENT_PAID("F5", "Patient Amount Paid"),
    PATIENT_RESP("F3", "Patient Responsibility - Estimated"),
    OWED("EAF", "Amount Owed"),
    NON_COVERED("A8", "Non covered Charges - Actual"),
    PAYER_PAID("D", "Payor Amount Paid"),
    COVERAGE_AMOUNT("AU", "Coverage Amount"),
    DISCOUNT_AMOUNT("D8", "Discount Amount"),
    ALLOWED_ACTUAL("B6", "Allowed - Actual"),
    DEDUCTION("KH", "Deduction Amount"),
    SERVICE_TAX("GT", "Goods and Services Tax"),
    TAX("T", "Tax"),
    POSTAGE("F4", "Postage Claimed"),
    MISC_TAX("N8", "Miscellaneous Taxes"),
    PAID("YW", "Paid"),
    PAID_FOR_THIS_FACILITY("YX", "Paid for This Facility"),
    RETURNED("YY", "Returned"),
    INTEREST("I", "Interest"),
    IN_PROCESS("YU", null),
    NONE("99999", "None");

    private final String ediValue;
    private final String desc;
    private static final EdiQualifier SUBTYPE_FOR_CODE_ENT;

    public static AmountType fromEdi(String ediCode) {
        for (AmountType v : AmountType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    @Override
    public String ediEltId() {
        return "AMT02";
    }

    @Override
    public CodeEntity toCodeEntity() {
        CodeEntity codeEnt = new CodeEntity(PrimaryCodeType.X12_AMOUNT_QUALIFIER_CODE, SUBTYPE_FOR_CODE_ENT, this.ediValue);
        codeEnt.desc(this.desc());
        codeEnt.enumName(this.name());
        return codeEnt;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    private AmountType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    static {
        SUBTYPE_FOR_CODE_ENT = new X12CodeTypeEnt(PrimaryCodeType.X12_AMOUNT_QUALIFIER_CODE.name(), "X12 Amount Qualifier Code");
    }
}

