/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.X12CodeTypeEnt;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum DateType implements EdiQualifier
{
    SERVICE("472", "Service Date"),
    STATEMENT("434", "Statement Dates"),
    ADMISSION("435", "Admission Date/Time"),
    DISCHARGE("096", "Discharge Time"),
    RECEIVED("050", "Received Date"),
    PROCESS("009", "Process Date"),
    ACUTE_MANIFESTATION("453", "Acute Manifestation Date"),
    INITIAL_TREATMENT("454", "Initial Treatment Date"),
    LAST_X_RAY("455", "Last X-Ray Date"),
    SERVICE_PERIOD_START("150", "Service Period Start Date"),
    SERVICE_PERIOD_END("151", "Service Period End Date"),
    STATEMENT_PERIOD_START("232", "Statement Period Start Date"),
    STATEMENT_PERIOD_END("233", "Statement Period End Date"),
    ONSET_OF_CURRENT_ILLNESS("431", "Onset of Current Symptoms Date"),
    LAST_SEEN("304", "Last Seen Date"),
    ACCIDENT("439", "Accident Date"),
    LAST_MENSTRUAL_PERIOD("484", "Last Menstrual Period Date"),
    PRESCRIPTION("471", "Prescription Date"),
    DISABILITY_FROM_TO("314", "Disability Period Start-End Dates"),
    DISABILITY_FROM("360", "Disability Period Start Date"),
    DISABILITY_TO("361", "Disability Period End Date"),
    ASSUMED_CARE("090", "Assumed Care Date"),
    RELINQUISHED_CARE("091", "Relinquished Care Date"),
    EXPIRATION("036", "Expiration Date"),
    PRODUCTION("405", "Production Date"),
    HEMOGLOBIN_TEST("738", "Most Recent Hemoglobin or Hematocrit Test Date"),
    CREATINE_TEST("739", "Most Recent Serum Creatine Test Date"),
    BEGIN_THERAPY("463", "Begin Therapy Date"),
    CLAIM_PAID("573", "Claim Paid Date"),
    COB_FROM("344", "Coordination of Benefits Start Date"),
    COB_TO("345", "Coordination of Benefits End Date"),
    EFFECTIVE("007", null),
    REPORT_START("090", null),
    REPORT_END("091", null),
    MAINTENANCE("303", null),
    ENROLLMENT("382", null),
    PAYMENT_COMMENCEMENT("388", null),
    DISABILITY_START("360", null),
    DISABILITY_END("361", null),
    LAST_DAY_WORKED("297", null),
    RETURN_TO_WORK("296", null),
    FIRST_VISIT_OR_CONSULTATION("444", null),
    APPLIANCE_PLACEMENT("452", null),
    REPLACEMENT("446", null),
    PRIOR_PLACEMENT("441", null),
    ESTIMATED("139", null),
    START("196", null),
    COMPLETION("198", null),
    NONE("99999", "None");

    private final String ediValue;
    private final String desc;
    private static final EdiQualifier SUBTYPE_FOR_CODE_ENT;

    public static DateType fromEdi(String ediCode) {
        for (DateType v : DateType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    @Override
    public CodeEntity toCodeEntity() {
        CodeEntity codeEnt = new CodeEntity(PrimaryCodeType.X12_DATE_TIME_QUALIFIER_CODE, SUBTYPE_FOR_CODE_ENT, this.ediValue);
        codeEnt.desc(this.desc());
        codeEnt.enumName(this.name());
        return codeEnt;
    }

    @Override
    public String ediEltId() {
        return "DTP03";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    private DateType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    static {
        SUBTYPE_FOR_CODE_ENT = new X12CodeTypeEnt(PrimaryCodeType.X12_DATE_TIME_QUALIFIER_CODE.name(), "X12 Date Time Qualifier Code");
    }
}

