/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DiagType implements EdiQualifier
{
    ICD_10_PRINCIPAL("ABK", "Principal Diagnosis"),
    ICD_9_PRINCIPAL("BK", "ICD-9-CM Principal Diagnosis"),
    ICD_10("ABF", "ICD-10-CM Diagnosis"),
    ICD_9("BF", "ICD-9-CM Diagnosis"),
    ICD_10_ADMITTING("ABJ", "Admitting Diagnosis"),
    ICD_10_REASON_FOR_VISIT("APR", "Reason for Visit Diagnosis"),
    ICD_10_EXTERNAL_CAUSE_OF_INJURY("ABN", "External Cause of Injury Diagnosis"),
    NONE("99999", "None");

    @Generated
    private static final Logger log;
    private final String ediValue;
    private final String desc;

    public static DiagType fromEdi(String ediCode) {
        for (DiagType v : DiagType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isMedicalCode() {
        return true;
    }

    @Override
    public String ediEltId() {
        return "HI";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private DiagType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    static {
        log = LoggerFactory.getLogger(DiagType.class);
    }
}

