/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.X12CodeTypeEnt;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReferenceType implements EdiQualifier
{
    PROVIDER_TAXONOMY("PXC", "Health Care Provider Taxonomy Code"),
    EIN("EI", "Employer\u2019s Identification Number"),
    SSN("SY", "Social Security Number"),
    MUTUALLY_DEFINED("ZZ", null),
    ACCOUNT_SUFFIX_CODE("60", null),
    MEDICARE_VERSION_CODE("F5", "Medicare Version Code"),
    REFERRAL_NUMBER("9F", "Referral Number"),
    MEDICAL_RECORD_NUMBER("EA", "Medical Record Number"),
    ORIGINAL_REFERENCE_NUMBER("F8", "Original Reference Number"),
    PRIOR_AUTHORIZATION_NUMBER("G1", "Prior Authorization Number"),
    LINK_SEQUENCE_NUMBER("VY", "Link Sequence Number"),
    PHARMACY_PRESCRIPTION_NUMBER("XZ", "Pharmacy Prescription Number"),
    PROVIDER_COMMERCIAL_NUMBER("G2", "Provider Commercial Number"),
    PROVIDER_UPIN_NUMBER("1G", "Provider UPIN Number"),
    CLAIM_NUMBER("D9", "Claim Number"),
    PROVIDER_CONTROL_NUMBER("6R", "Provider Control Number"),
    RECEIVER_IDENTIFICATION_NUMBER("EV", "Receiver Identification Number"),
    STATE_LICENSE_NUMBER("0B", "State License Number"),
    TAX_ID("TJ", "Tax ID"),
    MEDICARE_PROVIDER_NUMBER("1C", "Medicare Provider Number"),
    MEDICAID_PROVIDER_NUMBER("1D", "Medicaid Provider Number"),
    LOCATION_NUMBER("LU", "Location Number"),
    PROJECT_CODE("P4", "Project Code"),
    PROPERTY_CASUALTY_CLAIM_NUMBER("Y4", null),
    PAYER_IDENTIFICATION_NUMBER("2U", "Payer Identification Number"),
    SUBMITTER_IDENTIFICATION_NUMBER("EO", "Submitter Identification Number"),
    HEALTH_INDUSTRY_NUMBER("HI", "Health Industry Number"),
    CLAIM_OFFICE_NUMBER("FY", "Claim Office Number"),
    NAIC_CODE("NF", "NAIC Code"),
    PAYEE_IDENTIFICATION_NUMBER("PQ", "Payee Identification Number"),
    NCPDP_PHARMACY_NUMBER("D3", "NCPDP Pharmacy Number"),
    HEALTHCARE_POLICY_IDENTIFICATION("0K", "Healthcare Policy Identification"),
    GROUP_OR_POLICY_NUMBER("1L", "Group or Policy Number"),
    SUBSCRIBER_IDENTIFIER("0F", "Subscriber Identifier"),
    MEMBER_IDENTIFICATION_NUMBER("1W", "Member Identification Number"),
    EMPLOYEE_IDENTIFICATION_NUMBER("28", "Employee Identification Number"),
    GROUP_NUMBER("6P", "Group Number"),
    REPRICED_REFERENCE_NUMBER("9A", "Repriced Reference Number"),
    REPRICED_LINE_REFERENCE_NUMBER("9B", "Repriced Line Item Reference Number"),
    ADJUSTED_REPRICED_REFERENCE_NUMBER("9C", "Adjusted Repriced Reference Number"),
    ADJUSTED_REPRICED_LINE_REFERENCE_NUMBER("9D", "Adjusted Repriced Line Item Reference Number"),
    PPO_APPROVAL_NUMBER("G4", null),
    AUTHORIZATION_NUMBER("BB", "Authorization Number"),
    CLASS_OF_CONTRACT_CODE("CE", "Class of Contract Code"),
    PREDETERMINATION_OF_BENEFITS_NUMBER("G3", "Predetermination of Benefits Number"),
    INSURANCE_POLICY_NUMBER("IG", "Insurance Policy Number"),
    APG_NUMBER("1S", "Ambulatory Patient Group Number"),
    AMBULATORY_PAYMENT("APC", "Ambulatory Payment Classification"),
    ATTACHMENT_CODE("E9", "Attachment Code"),
    RATE_CODE_NUMBER("RB", "Rate Code Number"),
    BLUE_CROSS_PROVIDER_NUMBER("1A", "Blue Cross Provider Number"),
    BLUE_SHIELD_PROVIDER_NUMBER("1B", "Blue Shield Provider Number"),
    CHAMPUS_ID("1H", "CHAMPUS Identification Number"),
    FACILITY_ID("1J", "Facility ID Number"),
    CMS_NPI("HPI", "NPI"),
    NPI("XX", "NPI"),
    LINE_ITEM_CONTROL_NUMBER("FJ", "Line Item Control Number"),
    MEDICAL_ASSISTANCE_CATEGORY("M7", "Medical Assistance Category"),
    SPECIAL_PAYMENT_REFERENCE_NUMBER("4N", "Special Payment Reference Number"),
    UNIT_NUMBER("QQ", "Unit Number"),
    MASTER_POLICY_NUMBER("34", null),
    CONTRACTING_DISTRICT_NUMBER("00", null),
    CLIENT_REPORTING_CATEGORY("17", null),
    PLAN_NUMBER("18", null),
    DIVISION_IDENTIFIER("19", null),
    UNION_NUMBER("26", null),
    BRANCH_IDENTIFIER("3L", null),
    APPLICATION_NUMBER("6M", null),
    PAYMENT_CATEGORY("9V", null),
    ACCOUNT_CATEGORY("9X", null),
    GEOGRAPHIC_NUMBER("GE", null),
    PROGRAM_IDENTIFICATION_NUMBER("PID", null),
    SPECIAL_PROGRAM_CODE("XX1", null),
    SERVICE_AREA_CODE("XX2", null),
    GEOGRAPHIC_KEY("YY", null),
    PAYER_CLAIM_NUMBER("1K", null),
    BILL_TYPE("BLT", null),
    NONE("99999", "None");

    private final String ediValue;
    private final String desc;
    private static final EdiQualifier SUBTYPE_FOR_CODE_ENT;

    public static ReferenceType fromEdi(String ediCode) {
        for (ReferenceType v : ReferenceType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isMedicalCode() {
        return this == PROVIDER_TAXONOMY;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    @Override
    public String ediEltId() {
        return "REF02";
    }

    @Override
    public CodeEntity toCodeEntity() {
        CodeEntity codeEnt = new CodeEntity(PrimaryCodeType.X12_REFERENCE_IDENTIFICATION_QUALIFIER_CODE, SUBTYPE_FOR_CODE_ENT, this.ediValue);
        codeEnt.desc(this.desc());
        codeEnt.enumName(this.name());
        return codeEnt;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    private ReferenceType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    static {
        SUBTYPE_FOR_CODE_ENT = new X12CodeTypeEnt(PrimaryCodeType.X12_REFERENCE_IDENTIFICATION_QUALIFIER_CODE.name(), "X12 Reference Identification Qualifier Code");
    }
}

