/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum TransactionSetType implements EdiQualifier
{
    CLAIM("837", "Health Care Claim"),
    CLAIM_STATUS("277", "Health Care Claim Status"),
    PAYMENT("835", "Health Care Claim Payment/Advice"),
    MEMBER_COVERAGE("834", "Benefit Enrollment and Maintenance");

    private final String ediValue;
    private final String desc;

    public static TransactionSetType fromEdi(String ediCode) {
        for (TransactionSetType v : TransactionSetType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private TransactionSetType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

