/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.GeneralException;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import java.io.File;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum UbCodeType implements EdiQualifier
{
    OCCURRENCE_SPAN("BI", "Occurrence Span", "National Uniform Billing Committee (NUBC) Codes", "_span", PrimaryCodeType.UB04_OCCURRENCE_SPAN_CODE),
    OCCURRENCE("BH", "Occurrence", "National Uniform Billing Committee (NUBC) Codes", "occurrence", PrimaryCodeType.UB04_OCCURRENCE_CODE),
    CONDITION("BG", "Condition Code", "National Uniform Billing Committee (NUBC) Codes", "condition", PrimaryCodeType.UB04_CONDITION_CODE),
    VALUE("BE", "Value Code", "National Uniform Billing Committee (NUBC) Codes", "value", PrimaryCodeType.UB04_VALUE_CODE),
    DRG("DR", "Diagnosis-related group", "Diagnosis-related group", null, PrimaryCodeType.DRG),
    REVENUE_CODE("RC,NU", "Revenue Code", "National Uniform Billing Committee (NUBC) Codes", "revenue", PrimaryCodeType.UB04_REVENUE_CODE),
    TYPE_OF_BILL("TOB", "Type of Bill", "National Uniform Billing Committee (NUBC) Codes", "of_bill", PrimaryCodeType.UB04_TYPE_OF_BILL),
    FREQUENCY_CODE("FQ", "Frequency Code", "National Uniform Billing Committee (NUBC) Codes", "frequency", PrimaryCodeType.FREQUENCY_CODE),
    FACILITY_TYPE("FT", "Facility Type", "National Uniform Billing Committee (NUBC) Codes", "facility_codes", PrimaryCodeType.FACILITY_TYPE),
    PLACE_OF_SERVICE("POS", "Place of Service", "Place of Service", null, PrimaryCodeType.FACILITY_TYPE),
    NONE("99999", "None", null, null, PrimaryCodeType.NONE);

    @Generated
    private static final Logger log;
    private final String ediValue;
    private final String desc;
    private final String longDesc;
    private final String fileNameFragment;
    private final PrimaryCodeType primaryCodeType;

    public static UbCodeType fromEdi(String ediCode) {
        for (UbCodeType v : UbCodeType.values()) {
            String[] ediValues;
            for (String ediValue : ediValues = StringUtils.split((String)v.ediValue, (String)",")) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)ediValue)) continue;
                return v;
            }
        }
        return null;
    }

    @Override
    public boolean isMedicalCode() {
        return true;
    }

    public static UbCodeType fromFile(@NotNull File file) {
        return UbCodeType.fromFileName(file.getName());
    }

    private static UbCodeType fromFileName(String fileName) {
        fileName = fileName.toLowerCase(Locale.ROOT);
        for (UbCodeType v : UbCodeType.values()) {
            if (v.fileNameFragment == null || !fileName.contains(v.fileNameFragment)) continue;
            return v;
        }
        throw new GeneralException("Can't determine UB type from file %s", fileName);
    }

    public String normalize(String code) {
        if (this == FACILITY_TYPE) {
            int maxLength = 2;
            return UbCodeType.normalizeUbCode(code, maxLength);
        }
        return code;
    }

    public static String normalizeUbCode(String code, int maxLength) {
        if (code.length() > maxLength && code.startsWith("0")) {
            code = StringUtils.right((String)code, (int)maxLength);
        }
        return code;
    }

    @Override
    public String ediEltId() {
        return "HI";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String longDesc() {
        return this.longDesc;
    }

    @Generated
    public String fileNameFragment() {
        return this.fileNameFragment;
    }

    @Override
    @Generated
    public PrimaryCodeType primaryCodeType() {
        return this.primaryCodeType;
    }

    @Generated
    private UbCodeType(String ediValue, String desc, String longDesc, String fileNameFragment, PrimaryCodeType primaryCodeType) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.longDesc = longDesc;
        this.fileNameFragment = fileNameFragment;
        this.primaryCodeType = primaryCodeType;
    }

    static {
        log = LoggerFactory.getLogger(UbCodeType.class);
    }

    static final class Constants {
        static final String UB_LONG_DESC = "National Uniform Billing Committee (NUBC) Codes";

        Constants() {
        }
    }
}

