/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum UnitType implements EdiQualifier
{
    DAYS("DA", "Days"),
    MONTH("MO", "Months"),
    UNIT("UN", "Units"),
    MINUTES("MJ", "Minutes"),
    POUND("LB", "Pound"),
    MILES("DH", "Miles"),
    INTERNATIONAL_UNIT("F2", "International Unit"),
    GRAM("GR", "Gram"),
    MILLIGRAM("ME", "Milligram"),
    MILLILITER("ML", "Milliliter"),
    NONE("99999", "None");

    private final String ediValue;
    private final String desc;

    public static UnitType fromEdi(String ediCode) {
        for (UnitType v : UnitType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    public static String unitLabel(UnitType unitType, Number quantity) {
        String labelS = UNIT.desc();
        if (unitType != null) {
            labelS = unitType.desc();
        }
        return WordStringUtils.singularize(labelS, quantity);
    }

    @Override
    public String ediEltId() {
        return "DTP03";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private UnitType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

