/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.orgperson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.model.enumtype.IdentificationType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.EntityType;
import hdi.util.FormattingUtils;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PartyIdName
implements EdiEntity {
    @Prop(edi={"NM101", "N101"}, codeLookupQuery="type=X12_ENTITY_IDENTIFIER_CODE", isRequired=true)
    @EdiElt(value={"entity_identifier_code"})
    protected EntityRole entityRole;
    @EdiElt(value={"entity_type_qualifier"})
    @Prop(edi={"NM102"}, desc={"Type of this entity: 'BUSINESS' for organization, 'INDIVIDUAL' for person"}, isRequired=true)
    protected EntityType entityType;
    @Prop(edi={"NM108", "N103"}, desc={"Identification type, e.g., NPI or EIN. This is a qualifier code translated to a string constant (enum)"})
    @EdiElt(value={"identification_code_qualifier"})
    protected IdentificationType identificationType;
    @EdiElt(value={"identification_code", "identifier", "id_code", "Payer_Identifier", "corrected_priority_payer_id", "cob_carrier_identifier", "corrected_insurer_identifier"})
    @Prop(edi={"NM109", "N104"})
    protected String identifier;
    @EdiElt.Exclude
    @Prop(refType={ReferenceType.TAX_ID, ReferenceType.SSN, ReferenceType.EIN})
    protected String taxId;
    @JsonIgnore
    protected ReferenceType taxIdType;
    @EdiElt(pos=3, seg="NM1")
    @Prop(edi={"NM103", "N102"}, desc={"Organization name or person last name"})
    protected String lastNameOrOrgName;
    @EdiElt(pos=4, seg="NM1")
    protected String firstName;
    @EdiElt(pos=5, seg="NM1")
    protected String middleName;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults ediParsingResults) {
        mapper.populate(this, seg);
        if (seg.isInType(SegmentType.N1)) {
            this.entityType = EntityType.BUSINESS;
        }
    }

    @EdiElt(pos=2, seg="N1")
    public PartyIdName name(String name) {
        this.lastNameOrOrgName = name;
        return this;
    }

    @JsonIgnore
    public String getIdAndName() {
        String nm = "";
        nm = FormattingUtils.concat(nm, this.identifier(), "");
        nm = FormattingUtils.concat(nm, this.lastNameOrOrgName, " - ");
        return nm;
    }

    @JsonIgnore
    public String getIdAndNameAndRoleDesc() {
        String nm = "";
        nm = FormattingUtils.concat(nm, this.identifier, "");
        nm = FormattingUtils.concat(nm, this.lastNameOrOrgName, " - ");
        nm = FormattingUtils.concat(nm, this.entityRole.desc(), " (", ")");
        return nm;
    }

    protected String prepIdAndNameAndRole() {
        String nm = "";
        nm = FormattingUtils.concat(nm, this.identifier(), "");
        nm = FormattingUtils.concat(nm, this.lastNameOrOrgName, " - ");
        nm = FormattingUtils.concat(nm, this.entityRole.shortDesc(), " (", ")");
        return nm;
    }

    public String fullName() {
        String nm = "";
        nm = FormattingUtils.concat(nm, this.lastNameOrOrgName, "");
        nm = FormattingUtils.concat(nm, this.firstName, ", ");
        nm = FormattingUtils.concat(nm, this.middleName, " ");
        return nm;
    }

    public void setEntityRole(EntityRole entityRole) {
        this.entityRole = entityRole;
    }

    @Generated
    public EntityRole entityRole() {
        return this.entityRole;
    }

    @Generated
    public EntityType entityType() {
        return this.entityType;
    }

    @Generated
    public IdentificationType identificationType() {
        return this.identificationType;
    }

    @Generated
    public String identifier() {
        return this.identifier;
    }

    @Generated
    public String taxId() {
        return this.taxId;
    }

    @JsonIgnore
    @Generated
    public ReferenceType taxIdType() {
        return this.taxIdType;
    }

    @Generated
    public String lastNameOrOrgName() {
        return this.lastNameOrOrgName;
    }

    @Generated
    public String firstName() {
        return this.firstName;
    }

    @Generated
    public String middleName() {
        return this.middleName;
    }

    @Generated
    public PartyIdName taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @JsonIgnore
    @Generated
    public PartyIdName taxIdType(ReferenceType taxIdType) {
        this.taxIdType = taxIdType;
        return this;
    }

    @Generated
    public PartyIdName lastNameOrOrgName(String lastNameOrOrgName) {
        this.lastNameOrOrgName = lastNameOrOrgName;
        return this;
    }

    @Generated
    public PartyIdName firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Generated
    public PartyIdName middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartyIdName)) {
            return false;
        }
        PartyIdName other = (PartyIdName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EntityRole this$entityRole = this.entityRole();
        EntityRole other$entityRole = other.entityRole();
        if (this$entityRole == null ? other$entityRole != null : !this$entityRole.equals(other$entityRole)) {
            return false;
        }
        String this$identifier = this.identifier();
        String other$identifier = other.identifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$lastNameOrOrgName = this.lastNameOrOrgName();
        String other$lastNameOrOrgName = other.lastNameOrOrgName();
        return !(this$lastNameOrOrgName == null ? other$lastNameOrOrgName != null : !this$lastNameOrOrgName.equals(other$lastNameOrOrgName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PartyIdName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EntityRole $entityRole = this.entityRole();
        result = result * 59 + ($entityRole == null ? 43 : $entityRole.hashCode());
        String $identifier = this.identifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $lastNameOrOrgName = this.lastNameOrOrgName();
        result = result * 59 + ($lastNameOrOrgName == null ? 43 : $lastNameOrOrgName.hashCode());
        return result;
    }

    @Generated
    public PartyIdName() {
    }

    @Generated
    public String toString() {
        return "PartyIdName(entityRole=" + String.valueOf(this.entityRole()) + ", entityType=" + String.valueOf(this.entityType()) + ", identificationType=" + String.valueOf(this.identificationType()) + ", identifier=" + this.identifier() + ", taxId=" + this.taxId() + ", taxIdType=" + String.valueOf(this.taxIdType()) + ", lastNameOrOrgName=" + this.lastNameOrOrgName() + ", firstName=" + this.firstName() + ", middleName=" + this.middleName() + ")";
    }

    @Generated
    public PartyIdName entityRole(EntityRole entityRole) {
        this.entityRole = entityRole;
        return this;
    }

    @Generated
    public PartyIdName entityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @Generated
    public PartyIdName identificationType(IdentificationType identificationType) {
        this.identificationType = identificationType;
        return this;
    }

    @Generated
    public PartyIdName identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public record IdWithLabel(String id, String label) {
    }
}

