/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.patientsubscriber;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum RelationshipType implements EdiQualifier
{
    SPOUSE("1", "Spouse"),
    CHILD("19", "Child"),
    EMPLOYEE("20", "Employee"),
    UNKNOWN("21", "Organ Donor"),
    ORGAN_DONOR("39", "Individual"),
    CADAVER_DONOR("40", "Cadaver Donor"),
    LIFE_PARTNER("53", "Life Partner"),
    OTHER("G8", "Other"),
    SELF("18", "Self");

    private final String code;
    private final String desc;

    @Override
    public String ediValue() {
        return this.code;
    }

    public static RelationshipType fromEdi(String ediCode) {
        ediCode = StringUtils.removeStart((String)ediCode, (String)"0");
        for (RelationshipType v : RelationshipType.values()) {
            if (!v.code.equals(ediCode)) continue;
            return v;
        }
        return UNKNOWN;
    }

    @Generated
    public String code() {
        return this.code;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private RelationshipType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

