/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.model.payment.AdjustmentGroup;
import hdi.util.NumbersUtils;
import java.math.BigDecimal;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"CAS"})
public class Adjustment {
    public static final EdiObjectMapper<Adjustment> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    @JsonIgnore
    @Transient
    private int index;
    @EdiElt.Exclude
    @Prop(edi={"CAS01"}, desc={"Claim adjustment group code as a string constant (enum)"}, isRequired=true)
    private AdjustmentGroup group;
    private String reasonCode;
    @Prop(edi={"CAS02"}, desc={"Claim adjustment reason code"}, codeType=PrimaryCodeType.CLAIM_ADJUSTMENT_REASON_CODE, isRequired=true, objType=ObjType.CODE)
    private CodeEntity reason;
    @Prop(edi={"CAS03"}, desc={"Adjustment amount"}, isRequired=true)
    private BigDecimal amount;
    @Prop(edi={"CAS04"}, desc={"Adjustment quantity"})
    private BigDecimal quantity;

    public Adjustment reasonCode(String reasonCode) {
        this.reasonCode = StringUtils.strip((String)reasonCode);
        return this;
    }

    public BigDecimal amountOrZero() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void quantity(BigDecimal quantity) {
        this.quantity = NumbersUtils.removeTrailingZerosUpToDecimal(quantity);
    }

    public String reasonDescription() {
        String desc = "";
        if (this.reason != null && this.reason.desc() != null) {
            desc = this.reason.desc();
        }
        return desc;
    }

    public static BigDecimal sumAdjustments(Collection<Adjustment> adjustments, String reasonCode) {
        BigDecimal totalAdjustmentAmount = BigDecimal.ZERO;
        if (adjustments != null) {
            for (Adjustment adjustment : adjustments) {
                if (!StringUtils.isBlank((CharSequence)reasonCode) && !reasonCode.equals(adjustment.reasonCode)) continue;
                totalAdjustmentAmount = totalAdjustmentAmount.add(adjustment.amountOrZero());
            }
        }
        return totalAdjustmentAmount;
    }

    @JsonIgnore
    @Generated
    public int index() {
        return this.index;
    }

    @Generated
    public AdjustmentGroup group() {
        return this.group;
    }

    @Generated
    public String reasonCode() {
        return this.reasonCode;
    }

    @Generated
    public CodeEntity reason() {
        return this.reason;
    }

    @Generated
    public BigDecimal amount() {
        return this.amount;
    }

    @Generated
    public BigDecimal quantity() {
        return this.quantity;
    }

    @Generated
    public String toString() {
        return "Adjustment(group=" + String.valueOf(this.group()) + ", reasonCode=" + this.reasonCode() + ", reason=" + String.valueOf(this.reason()) + ", amount=" + String.valueOf(this.amount()) + ", quantity=" + String.valueOf(this.quantity()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adjustment)) {
            return false;
        }
        Adjustment other = (Adjustment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.index() != other.index()) {
            return false;
        }
        AdjustmentGroup this$group = this.group();
        AdjustmentGroup other$group = other.group();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$reasonCode = this.reasonCode();
        String other$reasonCode = other.reasonCode();
        if (this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode)) {
            return false;
        }
        CodeEntity this$reason = this.reason();
        CodeEntity other$reason = other.reason();
        if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
            return false;
        }
        BigDecimal this$amount = this.amount();
        BigDecimal other$amount = other.amount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        BigDecimal this$quantity = this.quantity();
        BigDecimal other$quantity = other.quantity();
        return !(this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Adjustment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index();
        AdjustmentGroup $group = this.group();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $reasonCode = this.reasonCode();
        result = result * 59 + ($reasonCode == null ? 43 : $reasonCode.hashCode());
        CodeEntity $reason = this.reason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        BigDecimal $amount = this.amount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        BigDecimal $quantity = this.quantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        return result;
    }

    @JsonIgnore
    @Generated
    public Adjustment index(int index) {
        this.index = index;
        return this;
    }

    @Generated
    public Adjustment group(AdjustmentGroup group) {
        this.group = group;
        return this;
    }

    @Generated
    public Adjustment reason(CodeEntity reason) {
        this.reason = reason;
        return this;
    }
}

