/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum AdjustmentGroup implements EdiQualifier
{
    CONTRACTUAL("CO", "Contractual Obligations"),
    CORRECTION("CR", "Correction and Reversals"),
    OTHER("OA", "Other adjustments"),
    PAYOR_INITIATED("PI", "Payor Initiated Reductions"),
    PATIENT_RESPONSIBILITY("PR", "Patient Responsibility");

    private final String ediValue;
    private final String desc;

    public static AdjustmentGroup fromEdi(String ediCode) {
        for (AdjustmentGroup v : AdjustmentGroup.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private AdjustmentGroup(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<AdjustmentGroup, String> {
        public String convert(AdjustmentGroup enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, AdjustmentGroup> {
        public AdjustmentGroup convert(@NotNull String s) {
            return (AdjustmentGroup)EnumUtils.getEnumIgnoreCase(AdjustmentGroup.class, (String)s);
        }
    }
}

