/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum ClaimStatus implements EdiQualifier
{
    PRIMARY("1", "Processed as Primary", "Paid", true),
    SECONDARY("2", "Processed as Secondary", "Paid (Secondary)", true),
    TERTIARY("3", "Processed as Tertiary", "Paid (Tertiary)", true),
    DENIED("4", "Denied", null, false),
    PRIMARY_FORWARDED("19", "Processed as Primary, Forwarded to Additional Payers", null, true),
    SECONDARY_FORWARDED("20", "Processed as Secondary, Forwarded to Additional Payers", null, true),
    TERTIARY_FORWARDED("21", "Processed as Tertiary, Forwarded to Additional Payers", null, true),
    REVERSAL("22", "Reversal of Previous Payment", "Reversal", false),
    NOT_OUR_CLAIM("23", "Not Our Claim", null, false),
    PREDETERMINATION_NO_PAYMENT("25", "Predetermination Pricing Only - No Payment", "Predetermination", false);

    private final String ediValue;
    private final String desc;
    private final String shortDesc;
    private final boolean isPayment;

    @Override
    public String shortDesc() {
        return this.shortDesc != null ? this.shortDesc : this.desc;
    }

    public static ClaimStatus fromEdi(String ediCode) {
        for (ClaimStatus v : ClaimStatus.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public boolean isPayment() {
        return this.isPayment;
    }

    @Generated
    private ClaimStatus(String ediValue, String desc, String shortDesc, boolean isPayment) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.shortDesc = shortDesc;
        this.isPayment = isPayment;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<ClaimStatus, String> {
        public String convert(ClaimStatus enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, ClaimStatus> {
        public ClaimStatus convert(@NotNull String s) {
            return (ClaimStatus)EnumUtils.getEnumIgnoreCase(ClaimStatus.class, (String)s);
        }
    }
}

