/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum DfiQualifier implements EdiQualifier
{
    ABA("01", "ABA transit routing number incl. check digits"),
    CANADIAN("04", "Canadian bank branch and institution number");

    private final String ediValue;
    private final String desc;

    public static DfiQualifier fromEdi(String ediCode) {
        for (DfiQualifier v : DfiQualifier.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private DfiQualifier(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

