/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.codeent.CodeEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.enumtype.CarcRarcType;
import hdi.model.payment.Adjustment;
import hdi.model.payment.AdjustmentGroup;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.Transient;

public class GroupedAdjustments
implements EdiEntity {
    public static final EdiObjectMapper<GroupedAdjustments> mapper = new EdiObjectMapper();
    @EdiElt(value={"adjustment_group_code"})
    private AdjustmentGroup group;
    @EdiElt.Exclude
    private List<Adjustment> adjustments;
    @EdiElt.Exclude
    @Transient
    private EdiSeg seg;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults ediParsingResults) {
        this.seg = seg;
        mapper.populate(this, seg);
        Set<String> trioNames = Set.of("adjustment_reason_code", "adjustment_amount", "adjustment_quantity");
        this.adjustments = Adjustment.mapper.mapRepeating(trioNames, seg.eltSet(), Adjustment::new);
        this.adjustments.forEach(adj -> adj.group(this.group));
    }

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType() == CarcRarcType.CARC) {
            for (Adjustment adjustment : this.adjustments) {
                if (!codeEntity.code().equals(adjustment.reasonCode())) continue;
                adjustment.reason(codeEntity);
            }
        }
    }

    @Generated
    public AdjustmentGroup group() {
        return this.group;
    }

    @Generated
    public List<Adjustment> adjustments() {
        return this.adjustments;
    }

    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public String toString() {
        return "GroupedAdjustments(group=" + String.valueOf(this.group()) + ", adjustments=" + String.valueOf(this.adjustments()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupedAdjustments)) {
            return false;
        }
        GroupedAdjustments other = (GroupedAdjustments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AdjustmentGroup this$group = this.group();
        AdjustmentGroup other$group = other.group();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        List<Adjustment> this$adjustments = this.adjustments();
        List<Adjustment> other$adjustments = other.adjustments();
        if (this$adjustments == null ? other$adjustments != null : !((Object)this$adjustments).equals(other$adjustments)) {
            return false;
        }
        EdiSeg this$seg = this.seg();
        EdiSeg other$seg = other.seg();
        return !(this$seg == null ? other$seg != null : !((Object)this$seg).equals(other$seg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupedAdjustments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AdjustmentGroup $group = this.group();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        List<Adjustment> $adjustments = this.adjustments();
        result = result * 59 + ($adjustments == null ? 43 : ((Object)$adjustments).hashCode());
        EdiSeg $seg = this.seg();
        result = result * 59 + ($seg == null ? 43 : ((Object)$seg).hashCode());
        return result;
    }
}

