/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.model.enumtype.CarcRarcType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"MIA"}, desc={"Contains Remittance Advice Remark Codes at the claim level and/or Medicare or Medicaid-specific amounts for inpatient institutional claims"})
public class InpatientAdjudication
extends BaseEdiEntity {
    @EdiElt(pos=1, seg="MIA", isRequired=true)
    private Integer coveredDaysOrVisitsCount;
    @EdiElt(pos=2, seg="MIA")
    private BigDecimal ppsOperatingOutlierAmount;
    @EdiElt(pos=3, seg="MIA")
    private Integer lifetimePsychiatricDaysCount;
    @EdiElt(pos=4, seg="MIA")
    private BigDecimal drgAmount;
    @EdiElt(pos=6, seg="MIA")
    private BigDecimal disproportionateShareAmount;
    @EdiElt(pos=7, seg="MIA")
    private BigDecimal mspPassThroughAmount;
    @EdiElt(pos=8, seg="MIA")
    private BigDecimal ppsCapitalAmount;
    @EdiElt(pos=9, seg="MIA")
    private BigDecimal ppsCapitalFspDrgAmount;
    @EdiElt(pos=10, seg="MIA")
    private BigDecimal ppsCapitalHspDrgAmount;
    @EdiElt(pos=11, seg="MIA")
    private BigDecimal ppsCapitalDshDrgAmount;
    @EdiElt(pos=12, seg="MIA")
    private BigDecimal oldCapitalAmount;
    @EdiElt(pos=13, seg="MIA")
    private BigDecimal ppsCapitalImeAmount;
    @EdiElt(pos=14, seg="MIA")
    private BigDecimal ppsOperatingHospitalSpecificDrgAmount;
    @EdiElt(pos=15, seg="MIA")
    private Integer costReportDayCount;
    @EdiElt(pos=16, seg="MIA")
    private BigDecimal ppsOperatingFederalSpecificDrgAmount;
    @EdiElt(pos=17, seg="MIA")
    private BigDecimal ppsCapitalOutlierAmount;
    @EdiElt(pos=18, seg="MIA")
    private BigDecimal indirectTeachingAmount;
    @EdiElt(pos=19, seg="MIA")
    private BigDecimal nonPayableProfessionalComponentAmount;
    @EdiElt(pos=24, seg="MIA")
    private BigDecimal ppsCapitalExceptionAmount;
    @Prop(desc={"Remark codes"}, edi={"MIA3"}, codeType=PrimaryCodeType.REMITTANCE_ADVICE_REMARK_CODE, objType=ObjType.CODE)
    private List<CodeEntity> remarks;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        this.addRemarkCode(results, seg.eltByPosition(5));
        int startPos = 20;
        int lastPos = 23;
        for (int pos = startPos; pos <= lastPos && pos <= seg.eltSet().elts().size(); ++pos) {
            Elt remarkCode = seg.eltByPosition(pos);
            this.addRemarkCode(results, remarkCode);
        }
    }

    private void addRemarkCode(EdiParsingResults results, Elt remarkCode) {
        if (remarkCode != null) {
            if (this.remarks == null) {
                this.remarks = new ArrayList<CodeEntity>();
            }
            CodeEntity remark = new CodeEntity(PrimaryCodeType.CARC_RARC, CarcRarcType.RARC, remarkCode.stringVal());
            this.remarks.add(remark);
            results.addCodeEntity(remark);
        }
    }

    public List<CodeEntity> remarks() {
        return this.remarks == null ? List.of() : this.remarks;
    }

    @Generated
    public Integer coveredDaysOrVisitsCount() {
        return this.coveredDaysOrVisitsCount;
    }

    @Generated
    public BigDecimal ppsOperatingOutlierAmount() {
        return this.ppsOperatingOutlierAmount;
    }

    @Generated
    public Integer lifetimePsychiatricDaysCount() {
        return this.lifetimePsychiatricDaysCount;
    }

    @Generated
    public BigDecimal drgAmount() {
        return this.drgAmount;
    }

    @Generated
    public BigDecimal disproportionateShareAmount() {
        return this.disproportionateShareAmount;
    }

    @Generated
    public BigDecimal mspPassThroughAmount() {
        return this.mspPassThroughAmount;
    }

    @Generated
    public BigDecimal ppsCapitalAmount() {
        return this.ppsCapitalAmount;
    }

    @Generated
    public BigDecimal ppsCapitalFspDrgAmount() {
        return this.ppsCapitalFspDrgAmount;
    }

    @Generated
    public BigDecimal ppsCapitalHspDrgAmount() {
        return this.ppsCapitalHspDrgAmount;
    }

    @Generated
    public BigDecimal ppsCapitalDshDrgAmount() {
        return this.ppsCapitalDshDrgAmount;
    }

    @Generated
    public BigDecimal oldCapitalAmount() {
        return this.oldCapitalAmount;
    }

    @Generated
    public BigDecimal ppsCapitalImeAmount() {
        return this.ppsCapitalImeAmount;
    }

    @Generated
    public BigDecimal ppsOperatingHospitalSpecificDrgAmount() {
        return this.ppsOperatingHospitalSpecificDrgAmount;
    }

    @Generated
    public Integer costReportDayCount() {
        return this.costReportDayCount;
    }

    @Generated
    public BigDecimal ppsOperatingFederalSpecificDrgAmount() {
        return this.ppsOperatingFederalSpecificDrgAmount;
    }

    @Generated
    public BigDecimal ppsCapitalOutlierAmount() {
        return this.ppsCapitalOutlierAmount;
    }

    @Generated
    public BigDecimal indirectTeachingAmount() {
        return this.indirectTeachingAmount;
    }

    @Generated
    public BigDecimal nonPayableProfessionalComponentAmount() {
        return this.nonPayableProfessionalComponentAmount;
    }

    @Generated
    public BigDecimal ppsCapitalExceptionAmount() {
        return this.ppsCapitalExceptionAmount;
    }

    @Generated
    public String toString() {
        return "InpatientAdjudication(coveredDaysOrVisitsCount=" + this.coveredDaysOrVisitsCount() + ", ppsOperatingOutlierAmount=" + String.valueOf(this.ppsOperatingOutlierAmount()) + ", lifetimePsychiatricDaysCount=" + this.lifetimePsychiatricDaysCount() + ", drgAmount=" + String.valueOf(this.drgAmount()) + ", disproportionateShareAmount=" + String.valueOf(this.disproportionateShareAmount()) + ", mspPassThroughAmount=" + String.valueOf(this.mspPassThroughAmount()) + ", ppsCapitalAmount=" + String.valueOf(this.ppsCapitalAmount()) + ", ppsCapitalFspDrgAmount=" + String.valueOf(this.ppsCapitalFspDrgAmount()) + ", ppsCapitalHspDrgAmount=" + String.valueOf(this.ppsCapitalHspDrgAmount()) + ", ppsCapitalDshDrgAmount=" + String.valueOf(this.ppsCapitalDshDrgAmount()) + ", oldCapitalAmount=" + String.valueOf(this.oldCapitalAmount()) + ", ppsCapitalImeAmount=" + String.valueOf(this.ppsCapitalImeAmount()) + ", ppsOperatingHospitalSpecificDrgAmount=" + String.valueOf(this.ppsOperatingHospitalSpecificDrgAmount()) + ", costReportDayCount=" + this.costReportDayCount() + ", ppsOperatingFederalSpecificDrgAmount=" + String.valueOf(this.ppsOperatingFederalSpecificDrgAmount()) + ", ppsCapitalOutlierAmount=" + String.valueOf(this.ppsCapitalOutlierAmount()) + ", indirectTeachingAmount=" + String.valueOf(this.indirectTeachingAmount()) + ", nonPayableProfessionalComponentAmount=" + String.valueOf(this.nonPayableProfessionalComponentAmount()) + ", ppsCapitalExceptionAmount=" + String.valueOf(this.ppsCapitalExceptionAmount()) + ", remarks=" + String.valueOf(this.remarks()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InpatientAdjudication)) {
            return false;
        }
        InpatientAdjudication other = (InpatientAdjudication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$coveredDaysOrVisitsCount = this.coveredDaysOrVisitsCount();
        Integer other$coveredDaysOrVisitsCount = other.coveredDaysOrVisitsCount();
        if (this$coveredDaysOrVisitsCount == null ? other$coveredDaysOrVisitsCount != null : !((Object)this$coveredDaysOrVisitsCount).equals(other$coveredDaysOrVisitsCount)) {
            return false;
        }
        Integer this$lifetimePsychiatricDaysCount = this.lifetimePsychiatricDaysCount();
        Integer other$lifetimePsychiatricDaysCount = other.lifetimePsychiatricDaysCount();
        if (this$lifetimePsychiatricDaysCount == null ? other$lifetimePsychiatricDaysCount != null : !((Object)this$lifetimePsychiatricDaysCount).equals(other$lifetimePsychiatricDaysCount)) {
            return false;
        }
        Integer this$costReportDayCount = this.costReportDayCount();
        Integer other$costReportDayCount = other.costReportDayCount();
        if (this$costReportDayCount == null ? other$costReportDayCount != null : !((Object)this$costReportDayCount).equals(other$costReportDayCount)) {
            return false;
        }
        BigDecimal this$ppsOperatingOutlierAmount = this.ppsOperatingOutlierAmount();
        BigDecimal other$ppsOperatingOutlierAmount = other.ppsOperatingOutlierAmount();
        if (this$ppsOperatingOutlierAmount == null ? other$ppsOperatingOutlierAmount != null : !((Object)this$ppsOperatingOutlierAmount).equals(other$ppsOperatingOutlierAmount)) {
            return false;
        }
        BigDecimal this$drgAmount = this.drgAmount();
        BigDecimal other$drgAmount = other.drgAmount();
        if (this$drgAmount == null ? other$drgAmount != null : !((Object)this$drgAmount).equals(other$drgAmount)) {
            return false;
        }
        BigDecimal this$disproportionateShareAmount = this.disproportionateShareAmount();
        BigDecimal other$disproportionateShareAmount = other.disproportionateShareAmount();
        if (this$disproportionateShareAmount == null ? other$disproportionateShareAmount != null : !((Object)this$disproportionateShareAmount).equals(other$disproportionateShareAmount)) {
            return false;
        }
        BigDecimal this$mspPassThroughAmount = this.mspPassThroughAmount();
        BigDecimal other$mspPassThroughAmount = other.mspPassThroughAmount();
        if (this$mspPassThroughAmount == null ? other$mspPassThroughAmount != null : !((Object)this$mspPassThroughAmount).equals(other$mspPassThroughAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalAmount = this.ppsCapitalAmount();
        BigDecimal other$ppsCapitalAmount = other.ppsCapitalAmount();
        if (this$ppsCapitalAmount == null ? other$ppsCapitalAmount != null : !((Object)this$ppsCapitalAmount).equals(other$ppsCapitalAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalFspDrgAmount = this.ppsCapitalFspDrgAmount();
        BigDecimal other$ppsCapitalFspDrgAmount = other.ppsCapitalFspDrgAmount();
        if (this$ppsCapitalFspDrgAmount == null ? other$ppsCapitalFspDrgAmount != null : !((Object)this$ppsCapitalFspDrgAmount).equals(other$ppsCapitalFspDrgAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalHspDrgAmount = this.ppsCapitalHspDrgAmount();
        BigDecimal other$ppsCapitalHspDrgAmount = other.ppsCapitalHspDrgAmount();
        if (this$ppsCapitalHspDrgAmount == null ? other$ppsCapitalHspDrgAmount != null : !((Object)this$ppsCapitalHspDrgAmount).equals(other$ppsCapitalHspDrgAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalDshDrgAmount = this.ppsCapitalDshDrgAmount();
        BigDecimal other$ppsCapitalDshDrgAmount = other.ppsCapitalDshDrgAmount();
        if (this$ppsCapitalDshDrgAmount == null ? other$ppsCapitalDshDrgAmount != null : !((Object)this$ppsCapitalDshDrgAmount).equals(other$ppsCapitalDshDrgAmount)) {
            return false;
        }
        BigDecimal this$oldCapitalAmount = this.oldCapitalAmount();
        BigDecimal other$oldCapitalAmount = other.oldCapitalAmount();
        if (this$oldCapitalAmount == null ? other$oldCapitalAmount != null : !((Object)this$oldCapitalAmount).equals(other$oldCapitalAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalImeAmount = this.ppsCapitalImeAmount();
        BigDecimal other$ppsCapitalImeAmount = other.ppsCapitalImeAmount();
        if (this$ppsCapitalImeAmount == null ? other$ppsCapitalImeAmount != null : !((Object)this$ppsCapitalImeAmount).equals(other$ppsCapitalImeAmount)) {
            return false;
        }
        BigDecimal this$ppsOperatingHospitalSpecificDrgAmount = this.ppsOperatingHospitalSpecificDrgAmount();
        BigDecimal other$ppsOperatingHospitalSpecificDrgAmount = other.ppsOperatingHospitalSpecificDrgAmount();
        if (this$ppsOperatingHospitalSpecificDrgAmount == null ? other$ppsOperatingHospitalSpecificDrgAmount != null : !((Object)this$ppsOperatingHospitalSpecificDrgAmount).equals(other$ppsOperatingHospitalSpecificDrgAmount)) {
            return false;
        }
        BigDecimal this$ppsOperatingFederalSpecificDrgAmount = this.ppsOperatingFederalSpecificDrgAmount();
        BigDecimal other$ppsOperatingFederalSpecificDrgAmount = other.ppsOperatingFederalSpecificDrgAmount();
        if (this$ppsOperatingFederalSpecificDrgAmount == null ? other$ppsOperatingFederalSpecificDrgAmount != null : !((Object)this$ppsOperatingFederalSpecificDrgAmount).equals(other$ppsOperatingFederalSpecificDrgAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalOutlierAmount = this.ppsCapitalOutlierAmount();
        BigDecimal other$ppsCapitalOutlierAmount = other.ppsCapitalOutlierAmount();
        if (this$ppsCapitalOutlierAmount == null ? other$ppsCapitalOutlierAmount != null : !((Object)this$ppsCapitalOutlierAmount).equals(other$ppsCapitalOutlierAmount)) {
            return false;
        }
        BigDecimal this$indirectTeachingAmount = this.indirectTeachingAmount();
        BigDecimal other$indirectTeachingAmount = other.indirectTeachingAmount();
        if (this$indirectTeachingAmount == null ? other$indirectTeachingAmount != null : !((Object)this$indirectTeachingAmount).equals(other$indirectTeachingAmount)) {
            return false;
        }
        BigDecimal this$nonPayableProfessionalComponentAmount = this.nonPayableProfessionalComponentAmount();
        BigDecimal other$nonPayableProfessionalComponentAmount = other.nonPayableProfessionalComponentAmount();
        if (this$nonPayableProfessionalComponentAmount == null ? other$nonPayableProfessionalComponentAmount != null : !((Object)this$nonPayableProfessionalComponentAmount).equals(other$nonPayableProfessionalComponentAmount)) {
            return false;
        }
        BigDecimal this$ppsCapitalExceptionAmount = this.ppsCapitalExceptionAmount();
        BigDecimal other$ppsCapitalExceptionAmount = other.ppsCapitalExceptionAmount();
        if (this$ppsCapitalExceptionAmount == null ? other$ppsCapitalExceptionAmount != null : !((Object)this$ppsCapitalExceptionAmount).equals(other$ppsCapitalExceptionAmount)) {
            return false;
        }
        List<CodeEntity> this$remarks = this.remarks();
        List<CodeEntity> other$remarks = other.remarks();
        return !(this$remarks == null ? other$remarks != null : !((Object)this$remarks).equals(other$remarks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InpatientAdjudication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $coveredDaysOrVisitsCount = this.coveredDaysOrVisitsCount();
        result = result * 59 + ($coveredDaysOrVisitsCount == null ? 43 : ((Object)$coveredDaysOrVisitsCount).hashCode());
        Integer $lifetimePsychiatricDaysCount = this.lifetimePsychiatricDaysCount();
        result = result * 59 + ($lifetimePsychiatricDaysCount == null ? 43 : ((Object)$lifetimePsychiatricDaysCount).hashCode());
        Integer $costReportDayCount = this.costReportDayCount();
        result = result * 59 + ($costReportDayCount == null ? 43 : ((Object)$costReportDayCount).hashCode());
        BigDecimal $ppsOperatingOutlierAmount = this.ppsOperatingOutlierAmount();
        result = result * 59 + ($ppsOperatingOutlierAmount == null ? 43 : ((Object)$ppsOperatingOutlierAmount).hashCode());
        BigDecimal $drgAmount = this.drgAmount();
        result = result * 59 + ($drgAmount == null ? 43 : ((Object)$drgAmount).hashCode());
        BigDecimal $disproportionateShareAmount = this.disproportionateShareAmount();
        result = result * 59 + ($disproportionateShareAmount == null ? 43 : ((Object)$disproportionateShareAmount).hashCode());
        BigDecimal $mspPassThroughAmount = this.mspPassThroughAmount();
        result = result * 59 + ($mspPassThroughAmount == null ? 43 : ((Object)$mspPassThroughAmount).hashCode());
        BigDecimal $ppsCapitalAmount = this.ppsCapitalAmount();
        result = result * 59 + ($ppsCapitalAmount == null ? 43 : ((Object)$ppsCapitalAmount).hashCode());
        BigDecimal $ppsCapitalFspDrgAmount = this.ppsCapitalFspDrgAmount();
        result = result * 59 + ($ppsCapitalFspDrgAmount == null ? 43 : ((Object)$ppsCapitalFspDrgAmount).hashCode());
        BigDecimal $ppsCapitalHspDrgAmount = this.ppsCapitalHspDrgAmount();
        result = result * 59 + ($ppsCapitalHspDrgAmount == null ? 43 : ((Object)$ppsCapitalHspDrgAmount).hashCode());
        BigDecimal $ppsCapitalDshDrgAmount = this.ppsCapitalDshDrgAmount();
        result = result * 59 + ($ppsCapitalDshDrgAmount == null ? 43 : ((Object)$ppsCapitalDshDrgAmount).hashCode());
        BigDecimal $oldCapitalAmount = this.oldCapitalAmount();
        result = result * 59 + ($oldCapitalAmount == null ? 43 : ((Object)$oldCapitalAmount).hashCode());
        BigDecimal $ppsCapitalImeAmount = this.ppsCapitalImeAmount();
        result = result * 59 + ($ppsCapitalImeAmount == null ? 43 : ((Object)$ppsCapitalImeAmount).hashCode());
        BigDecimal $ppsOperatingHospitalSpecificDrgAmount = this.ppsOperatingHospitalSpecificDrgAmount();
        result = result * 59 + ($ppsOperatingHospitalSpecificDrgAmount == null ? 43 : ((Object)$ppsOperatingHospitalSpecificDrgAmount).hashCode());
        BigDecimal $ppsOperatingFederalSpecificDrgAmount = this.ppsOperatingFederalSpecificDrgAmount();
        result = result * 59 + ($ppsOperatingFederalSpecificDrgAmount == null ? 43 : ((Object)$ppsOperatingFederalSpecificDrgAmount).hashCode());
        BigDecimal $ppsCapitalOutlierAmount = this.ppsCapitalOutlierAmount();
        result = result * 59 + ($ppsCapitalOutlierAmount == null ? 43 : ((Object)$ppsCapitalOutlierAmount).hashCode());
        BigDecimal $indirectTeachingAmount = this.indirectTeachingAmount();
        result = result * 59 + ($indirectTeachingAmount == null ? 43 : ((Object)$indirectTeachingAmount).hashCode());
        BigDecimal $nonPayableProfessionalComponentAmount = this.nonPayableProfessionalComponentAmount();
        result = result * 59 + ($nonPayableProfessionalComponentAmount == null ? 43 : ((Object)$nonPayableProfessionalComponentAmount).hashCode());
        BigDecimal $ppsCapitalExceptionAmount = this.ppsCapitalExceptionAmount();
        result = result * 59 + ($ppsCapitalExceptionAmount == null ? 43 : ((Object)$ppsCapitalExceptionAmount).hashCode());
        List<CodeEntity> $remarks = this.remarks();
        result = result * 59 + ($remarks == null ? 43 : ((Object)$remarks).hashCode());
        return result;
    }
}

