/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum PaymentMethodType implements EdiQualifier
{
    ACH("ACH", "Automated Clearing House (ACH)", "ACH"),
    CHECK("CHK", "Check", "Check"),
    WIRE_TRANSFER("FWT", "Wire Transfer", "Wire Transfer"),
    BOP("BOP", "Financial Institution Option", "Financial Institution Option"),
    NON_PAYMENT("NON", "Non-Payment Data", "Non-Payment Data");

    private final String ediValue;
    private final String desc;
    private final String shortDesc;

    public static PaymentMethodType fromEdi(String ediCode) {
        for (PaymentMethodType v : PaymentMethodType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Override
    @Generated
    public String shortDesc() {
        return this.shortDesc;
    }

    @Generated
    private PaymentMethodType(String ediValue, String desc, String shortDesc) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.shortDesc = shortDesc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<PaymentMethodType, String> {
        public String convert(PaymentMethodType enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, PaymentMethodType> {
        public PaymentMethodType convert(@NotNull String s) {
            return (PaymentMethodType)EnumUtils.getEnumIgnoreCase(PaymentMethodType.class, (String)s);
        }
    }
}

