/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.model.enumtype.CarcRarcType;
import java.math.BigDecimal;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(desc={"Provider-level payment adjustment containing the reason code and the amount"})
public class ProviderAdjustmentReasonAmount {
    @Prop(edi={"PLB03-1"}, desc={"Provider adjustment reason code"}, codeType=PrimaryCodeType.PROVIDER_ADJUSTMENT_REASON_CODE, isRequired=true, objType=ObjType.CODE)
    private CodeEntity reason;
    @Prop(edi={"PLB03-2"})
    private String referenceIdentification;
    @Prop(edi={"PLB04"}, isRequired=true)
    private BigDecimal amount;

    public ProviderAdjustmentReasonAmount(String reasonCode, String referenceIdentification, BigDecimal amount) {
        this.reason = new CodeEntity(PrimaryCodeType.CARC_RARC, CarcRarcType.PROVIDER_ADJUSTMENT_REASON_CODE, reasonCode);
        this.referenceIdentification = referenceIdentification;
        this.amount = amount;
    }

    @Generated
    public CodeEntity reason() {
        return this.reason;
    }

    @Generated
    public String referenceIdentification() {
        return this.referenceIdentification;
    }

    @Generated
    public BigDecimal amount() {
        return this.amount;
    }

    @Generated
    public String toString() {
        return "ProviderAdjustmentReasonAmount(reason=" + String.valueOf(this.reason()) + ", referenceIdentification=" + this.referenceIdentification() + ", amount=" + String.valueOf(this.amount()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderAdjustmentReasonAmount)) {
            return false;
        }
        ProviderAdjustmentReasonAmount other = (ProviderAdjustmentReasonAmount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CodeEntity this$reason = this.reason();
        CodeEntity other$reason = other.reason();
        if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
            return false;
        }
        String this$referenceIdentification = this.referenceIdentification();
        String other$referenceIdentification = other.referenceIdentification();
        if (this$referenceIdentification == null ? other$referenceIdentification != null : !this$referenceIdentification.equals(other$referenceIdentification)) {
            return false;
        }
        BigDecimal this$amount = this.amount();
        BigDecimal other$amount = other.amount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProviderAdjustmentReasonAmount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CodeEntity $reason = this.reason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        String $referenceIdentification = this.referenceIdentification();
        result = result * 59 + ($referenceIdentification == null ? 43 : $referenceIdentification.hashCode());
        BigDecimal $amount = this.amount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    public ProviderAdjustmentReasonAmount() {
    }
}

