/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiSeg;
import hdi.model.Amount;
import hdi.model.Quantity;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.QuantityType;
import hdi.model.status.StatusInfo;
import hdi.util.CollectionUtils;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(desc={"Status of multiple claims provided at a provider or a receiver level. At the receiver level, this is a status of all claims in the transaction."})
public class BatchStatus
extends BaseEdiEntity {
    @EdiElt(pos=2, seg="TRN")
    @Prop(edi={"TRN02"}, desc={"Transaction control number from 837 for the status at the receiver level. It is a dummy number for the provider-level status; should be ignored."})
    private String traceIdentifier;
    @Prop(objType=ObjType.STATUS_INFO)
    private List<StatusInfo> statusInfos;
    @Prop(quantityType={QuantityType.APPROVED})
    private BigDecimal acceptedQuantity;
    @Prop(amtType=AmountType.IN_PROCESS)
    private BigDecimal acceptedAmount;
    @Prop(quantityType={QuantityType.REJECTED})
    private BigDecimal rejectedQuantity;
    @Prop(amtType=AmountType.RETURNED)
    private BigDecimal rejectedAmount;

    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        Quantity quantity;
        Amount amount;
        if (segEnt instanceof StatusInfo) {
            StatusInfo statusInfo = (StatusInfo)segEnt;
            this.statusInfos = CollectionUtils.addWithInit(this.statusInfos, statusInfo);
        } else if (segEnt instanceof Amount && (amount = (Amount)segEnt).type() != null) {
            switch (amount.type()) {
                case IN_PROCESS: {
                    this.acceptedAmount = amount.amount();
                    break;
                }
                case RETURNED: {
                    this.rejectedAmount = amount.amount();
                }
            }
        } else if (segEnt instanceof Quantity && (quantity = (Quantity)segEnt).type() != null) {
            switch (quantity.type()) {
                case APPROVED: 
                case ACKNOWLEDGED: {
                    this.acceptedQuantity = quantity.quantity();
                    break;
                }
                case REJECTED: 
                case UNACKNOWLEDGED: {
                    this.rejectedQuantity = quantity.quantity();
                }
            }
        }
    }

    @Generated
    public String traceIdentifier() {
        return this.traceIdentifier;
    }

    @Generated
    public List<StatusInfo> statusInfos() {
        return this.statusInfos;
    }

    @Generated
    public BigDecimal acceptedQuantity() {
        return this.acceptedQuantity;
    }

    @Generated
    public BigDecimal acceptedAmount() {
        return this.acceptedAmount;
    }

    @Generated
    public BigDecimal rejectedQuantity() {
        return this.rejectedQuantity;
    }

    @Generated
    public BigDecimal rejectedAmount() {
        return this.rejectedAmount;
    }

    @Generated
    public String toString() {
        return "BatchStatus(traceIdentifier=" + this.traceIdentifier() + ", statusInfos=" + String.valueOf(this.statusInfos()) + ", acceptedQuantity=" + String.valueOf(this.acceptedQuantity()) + ", acceptedAmount=" + String.valueOf(this.acceptedAmount()) + ", rejectedQuantity=" + String.valueOf(this.rejectedQuantity()) + ", rejectedAmount=" + String.valueOf(this.rejectedAmount()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchStatus)) {
            return false;
        }
        BatchStatus other = (BatchStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$traceIdentifier = this.traceIdentifier();
        String other$traceIdentifier = other.traceIdentifier();
        if (this$traceIdentifier == null ? other$traceIdentifier != null : !this$traceIdentifier.equals(other$traceIdentifier)) {
            return false;
        }
        List<StatusInfo> this$statusInfos = this.statusInfos();
        List<StatusInfo> other$statusInfos = other.statusInfos();
        if (this$statusInfos == null ? other$statusInfos != null : !((Object)this$statusInfos).equals(other$statusInfos)) {
            return false;
        }
        BigDecimal this$acceptedQuantity = this.acceptedQuantity();
        BigDecimal other$acceptedQuantity = other.acceptedQuantity();
        if (this$acceptedQuantity == null ? other$acceptedQuantity != null : !((Object)this$acceptedQuantity).equals(other$acceptedQuantity)) {
            return false;
        }
        BigDecimal this$acceptedAmount = this.acceptedAmount();
        BigDecimal other$acceptedAmount = other.acceptedAmount();
        if (this$acceptedAmount == null ? other$acceptedAmount != null : !((Object)this$acceptedAmount).equals(other$acceptedAmount)) {
            return false;
        }
        BigDecimal this$rejectedQuantity = this.rejectedQuantity();
        BigDecimal other$rejectedQuantity = other.rejectedQuantity();
        if (this$rejectedQuantity == null ? other$rejectedQuantity != null : !((Object)this$rejectedQuantity).equals(other$rejectedQuantity)) {
            return false;
        }
        BigDecimal this$rejectedAmount = this.rejectedAmount();
        BigDecimal other$rejectedAmount = other.rejectedAmount();
        return !(this$rejectedAmount == null ? other$rejectedAmount != null : !((Object)this$rejectedAmount).equals(other$rejectedAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BatchStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $traceIdentifier = this.traceIdentifier();
        result = result * 59 + ($traceIdentifier == null ? 43 : $traceIdentifier.hashCode());
        List<StatusInfo> $statusInfos = this.statusInfos();
        result = result * 59 + ($statusInfos == null ? 43 : ((Object)$statusInfos).hashCode());
        BigDecimal $acceptedQuantity = this.acceptedQuantity();
        result = result * 59 + ($acceptedQuantity == null ? 43 : ((Object)$acceptedQuantity).hashCode());
        BigDecimal $acceptedAmount = this.acceptedAmount();
        result = result * 59 + ($acceptedAmount == null ? 43 : ((Object)$acceptedAmount).hashCode());
        BigDecimal $rejectedQuantity = this.rejectedQuantity();
        result = result * 59 + ($rejectedQuantity == null ? 43 : ((Object)$rejectedQuantity).hashCode());
        BigDecimal $rejectedAmount = this.rejectedAmount();
        result = result * 59 + ($rejectedAmount == null ? 43 : ((Object)$rejectedAmount).hashCode());
        return result;
    }
}

