/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.ObjectType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.status.BaseProviderReceiverStatus;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ProviderStatus;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"objectType", "id", "receiver", "batchStatus", "transaction"})
@EdiObj(desc={"Status of claims at a transaction level. This object is returned only if all claims have been rejected and no individual claim statuses have been provided."})
public class ReceiverStatus
extends BaseProviderReceiverStatus {
    @Prop(masterClass=ClaimStatus.class)
    private OrgOrPerson receiver;

    public ReceiverStatus() {
        super(ObjectType.RECEIVER_STATUS);
    }

    @Override
    protected void populateFromDescendantSeg(EdiSeg seg, EdiEntity segEnt, EdiParsingResults results) {
        super.populateFromDescendantSeg(seg, segEnt, results);
        if (segEnt instanceof ProviderStatus) {
            ProviderStatus ps = (ProviderStatus)segEnt;
            ps.setReceiverStatus(this);
            results.statuses().remove(this);
        } else if (segEnt instanceof ClaimStatus) {
            ClaimStatus claimStatus = (ClaimStatus)segEnt;
            results.statuses().remove(this);
            claimStatus.setReceiverStatus(this);
        }
    }

    public OrgOrPerson getReceiver() {
        return this.party();
    }

    @Override
    @Generated
    public String toString() {
        return "ReceiverStatus(super=" + super.toString() + ", receiver=" + String.valueOf(this.receiver) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReceiverStatus)) {
            return false;
        }
        ReceiverStatus other = (ReceiverStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrgOrPerson this$receiver = this.receiver;
        OrgOrPerson other$receiver = other.receiver;
        return !(this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReceiverStatus;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OrgOrPerson $receiver = this.receiver;
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        return result;
    }
}

