/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.edi.csv.PaymentLineCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiSeg;
import hdi.model.DateTimePeriod;
import hdi.model.Reference;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.status.StatusInfo;
import hdi.util.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2220D"}, desc={"Service line information and its status"})
public class ServiceLineStatus
extends BaseEdiEntity {
    @Prop(refType={ReferenceType.PROVIDER_CONTROL_NUMBER}, desc={"Line item control number from 837"})
    private String controlNumber;
    @EdiElt(seg="SVC", pos=2)
    private BigDecimal chargeAmount;
    @EdiElt(seg="SVC", pos=7)
    private BigDecimal unitCount;
    @EdiElt.Exclude
    @Prop(edi={"SVC01"}, objType=ObjType.PROCEDURE)
    private CodeEntity procedure;
    @EdiElt.Exclude
    @Prop(edi={"SVC01,SVC04"}, objType=ObjType.REV_CODE)
    private CodeEntity revenueCode;
    @Prop(refType={ReferenceType.PHARMACY_PRESCRIPTION_NUMBER})
    private String prescriptionNumber;
    @Prop(masterClass=PaymentLineCsv.class)
    private LocalDate serviceDateFrom;
    @Prop(masterClass=PaymentLineCsv.class)
    private LocalDate serviceDateTo;
    @Prop(objType=ObjType.STATUS_INFO)
    private List<StatusInfo> statusInfos;

    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        Reference reference;
        if (segEnt instanceof Reference && (reference = (Reference)segEnt).type() != null) {
            switch (reference.type()) {
                case PROVIDER_CONTROL_NUMBER: {
                    this.controlNumber = reference.identification();
                    break;
                }
                case PHARMACY_PRESCRIPTION_NUMBER: {
                    this.prescriptionNumber = reference.identification();
                }
            }
        } else if (segEnt instanceof DateTimePeriod) {
            DateTimePeriod dt = (DateTimePeriod)segEnt;
            if (dt.type() == DateType.SERVICE) {
                this.serviceDateFrom = dt.date();
                this.serviceDateTo = dt.dateTo();
                if (this.serviceDateTo == null) {
                    this.serviceDateTo = this.serviceDateFrom;
                }
            }
        } else if (segEnt instanceof StatusInfo) {
            StatusInfo statusInfo = (StatusInfo)segEnt;
            this.statusInfos = CollectionUtils.addWithInit(this.statusInfos, statusInfo);
        }
    }

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType().equals(UbCodeType.REVENUE_CODE)) {
            this.revenueCode = codeEntity;
        } else if (codeEntity.subType() instanceof ProcType) {
            this.procedure = codeEntity;
        }
    }

    @Generated
    public String controlNumber() {
        return this.controlNumber;
    }

    @Generated
    public BigDecimal chargeAmount() {
        return this.chargeAmount;
    }

    @Generated
    public BigDecimal unitCount() {
        return this.unitCount;
    }

    @Generated
    public CodeEntity procedure() {
        return this.procedure;
    }

    @Generated
    public CodeEntity revenueCode() {
        return this.revenueCode;
    }

    @Generated
    public String prescriptionNumber() {
        return this.prescriptionNumber;
    }

    @Generated
    public LocalDate serviceDateFrom() {
        return this.serviceDateFrom;
    }

    @Generated
    public LocalDate serviceDateTo() {
        return this.serviceDateTo;
    }

    @Generated
    public List<StatusInfo> statusInfos() {
        return this.statusInfos;
    }

    @Generated
    public String toString() {
        return "ServiceLineStatus(controlNumber=" + this.controlNumber() + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", unitCount=" + String.valueOf(this.unitCount()) + ", procedure=" + String.valueOf(this.procedure()) + ", revenueCode=" + String.valueOf(this.revenueCode()) + ", prescriptionNumber=" + this.prescriptionNumber() + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom()) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo()) + ", statusInfos=" + String.valueOf(this.statusInfos()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceLineStatus)) {
            return false;
        }
        ServiceLineStatus other = (ServiceLineStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$controlNumber = this.controlNumber();
        String other$controlNumber = other.controlNumber();
        if (this$controlNumber == null ? other$controlNumber != null : !this$controlNumber.equals(other$controlNumber)) {
            return false;
        }
        BigDecimal this$chargeAmount = this.chargeAmount();
        BigDecimal other$chargeAmount = other.chargeAmount();
        if (this$chargeAmount == null ? other$chargeAmount != null : !((Object)this$chargeAmount).equals(other$chargeAmount)) {
            return false;
        }
        BigDecimal this$unitCount = this.unitCount();
        BigDecimal other$unitCount = other.unitCount();
        if (this$unitCount == null ? other$unitCount != null : !((Object)this$unitCount).equals(other$unitCount)) {
            return false;
        }
        CodeEntity this$procedure = this.procedure();
        CodeEntity other$procedure = other.procedure();
        if (this$procedure == null ? other$procedure != null : !((Object)this$procedure).equals(other$procedure)) {
            return false;
        }
        CodeEntity this$revenueCode = this.revenueCode();
        CodeEntity other$revenueCode = other.revenueCode();
        if (this$revenueCode == null ? other$revenueCode != null : !((Object)this$revenueCode).equals(other$revenueCode)) {
            return false;
        }
        String this$prescriptionNumber = this.prescriptionNumber();
        String other$prescriptionNumber = other.prescriptionNumber();
        if (this$prescriptionNumber == null ? other$prescriptionNumber != null : !this$prescriptionNumber.equals(other$prescriptionNumber)) {
            return false;
        }
        LocalDate this$serviceDateFrom = this.serviceDateFrom();
        LocalDate other$serviceDateFrom = other.serviceDateFrom();
        if (this$serviceDateFrom == null ? other$serviceDateFrom != null : !((Object)this$serviceDateFrom).equals(other$serviceDateFrom)) {
            return false;
        }
        LocalDate this$serviceDateTo = this.serviceDateTo();
        LocalDate other$serviceDateTo = other.serviceDateTo();
        if (this$serviceDateTo == null ? other$serviceDateTo != null : !((Object)this$serviceDateTo).equals(other$serviceDateTo)) {
            return false;
        }
        List<StatusInfo> this$statusInfos = this.statusInfos();
        List<StatusInfo> other$statusInfos = other.statusInfos();
        return !(this$statusInfos == null ? other$statusInfos != null : !((Object)this$statusInfos).equals(other$statusInfos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceLineStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $controlNumber = this.controlNumber();
        result = result * 59 + ($controlNumber == null ? 43 : $controlNumber.hashCode());
        BigDecimal $chargeAmount = this.chargeAmount();
        result = result * 59 + ($chargeAmount == null ? 43 : ((Object)$chargeAmount).hashCode());
        BigDecimal $unitCount = this.unitCount();
        result = result * 59 + ($unitCount == null ? 43 : ((Object)$unitCount).hashCode());
        CodeEntity $procedure = this.procedure();
        result = result * 59 + ($procedure == null ? 43 : ((Object)$procedure).hashCode());
        CodeEntity $revenueCode = this.revenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : ((Object)$revenueCode).hashCode());
        String $prescriptionNumber = this.prescriptionNumber();
        result = result * 59 + ($prescriptionNumber == null ? 43 : $prescriptionNumber.hashCode());
        LocalDate $serviceDateFrom = this.serviceDateFrom();
        result = result * 59 + ($serviceDateFrom == null ? 43 : ((Object)$serviceDateFrom).hashCode());
        LocalDate $serviceDateTo = this.serviceDateTo();
        result = result * 59 + ($serviceDateTo == null ? 43 : ((Object)$serviceDateTo).hashCode());
        List<StatusInfo> $statusInfos = this.statusInfos();
        result = result * 59 + ($statusInfos == null ? 43 : ((Object)$statusInfos).hashCode());
        return result;
    }
}

