/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.legacyparser.EdiDataType;
import hdi.edi.openedi.ElementSchema;
import hdi.edi.openedi.SegSchema;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parserhelper.ParsingError;
import hdi.ncpdp.NcpdpValueConverter;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpField {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpField.class);
    public static final int FIELD_ID_LENGTH = 2;
    private ElementSchema schema;
    private final String id;
    private final String rawVal;
    private Object val;
    private String rawString;
    private boolean isFixedWidth;
    private final NcpdpValueConverter ncpdpValueConverter = new NcpdpValueConverter();
    private String name;

    public static NcpdpField parse(SegSchema segSchema, String str) {
        ElementSchema eltSchema;
        NcpdpField field = NcpdpField.parseWithPrefix(str);
        if (segSchema != null && field.id != null && (eltSchema = segSchema.findElementById(field.id)) != null) {
            field.updateFromSchema(eltSchema);
        }
        return field;
    }

    public static NcpdpField parseWithPrefix(String rawString) {
        String prefix = null;
        if (StringUtils.length((CharSequence)rawString) >= 2) {
            prefix = StringUtils.left((String)rawString, (int)2);
        }
        String rawVal = StringUtils.substring((String)rawString, (int)2);
        return new NcpdpField(prefix, rawVal, rawString);
    }

    public static NcpdpField parseFixedLength(ElementSchema eltSchema, String rawString) {
        NcpdpField field = new NcpdpField(null, rawString, rawString);
        field.updateFromSchema(eltSchema);
        field.isFixedWidth = true;
        return field;
    }

    private NcpdpField(String prefix, String rawVal, String rawString) {
        this.id = prefix;
        this.rawVal = rawVal;
        this.rawString = rawString;
    }

    private void updateFromSchema(ElementSchema schema) {
        this.name = schema.name();
        this.schema = schema;
        ArrayList<ParsingError> errors = new ArrayList<ParsingError>();
        this.val = this.ncpdpValueConverter.parseValue(schema.toFieldMeta(), this.rawVal, errors);
    }

    public Elt toElt(EltSet eltSet) {
        Elt elt = Elt.fromSimpleVal(eltSet, this.name, this.val, null);
        elt.rawEdiString(this.rawVal);
        elt.ncpdpId(this.id);
        elt.isFixedWidth(this.isFixedWidth);
        if (this.schema != null) {
            elt.isCurrency(this.schema.type() == EdiDataType.DECIMAL && this.schema.scale() == 2);
        }
        return elt;
    }

    @Generated
    public ElementSchema schema() {
        return this.schema;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String rawVal() {
        return this.rawVal;
    }

    @Generated
    public Object val() {
        return this.val;
    }

    @Generated
    public String rawString() {
        return this.rawString;
    }

    @Generated
    public boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    @Generated
    public NcpdpValueConverter ncpdpValueConverter() {
        return this.ncpdpValueConverter;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String toString() {
        return "NcpdpField(id=" + this.id() + ", rawVal=" + this.rawVal() + ", val=" + String.valueOf(this.val()) + ", rawString=" + this.rawString() + ", name=" + this.name() + ")";
    }

    @Generated
    public NcpdpField(String id, String rawVal) {
        this.id = id;
        this.rawVal = rawVal;
    }

    @Generated
    public NcpdpField name(String name) {
        this.name = name;
        return this;
    }
}

