/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.openedi.SegSchema;
import hdi.edi.openedi.TransactionSchema;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.EdiSeparators;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.ncpdp.NcpdpField;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpSegment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpSegment.class);
    public static final String SEGMENT_ID_FIELD_NAME = "AM";
    private SegSchema schema;
    private TransactionSchema transactionSchema;
    private final List<NcpdpField> fields = new ArrayList<NcpdpField>();
    private String id;
    private String name;

    public NcpdpSegment(TransactionSchema transactionSchema) {
        this.transactionSchema = transactionSchema;
    }

    public NcpdpSegment(String id, TransactionSchema transactionSchema) {
        this.id = id;
        this.transactionSchema = transactionSchema;
        this.populateSchema(id);
    }

    public void addField(NcpdpField field) {
        if (this.id == null && StringUtils.equalsIgnoreCase((CharSequence)field.id(), (CharSequence)SEGMENT_ID_FIELD_NAME)) {
            this.setIdFromField(field);
        } else {
            this.fields.add(field);
        }
    }

    public Object findFieldVal(String fieldName) {
        for (NcpdpField f : this.fields) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)fieldName, (CharSequence)f.name())) continue;
            return f.val();
        }
        return null;
    }

    private void setIdFromField(NcpdpField idField) {
        this.id = idField.id() + idField.rawVal();
        this.populateSchema(this.id);
    }

    private void populateSchema(String segId) {
        SegSchema segSchema = this.transactionSchema.findFirstSegById(segId);
        if (segSchema != null) {
            this.setSchema(segSchema);
        } else {
            log.warn("Didn't find schema for segment {}", (Object)segId);
        }
    }

    void setSchema(SegSchema segSchema) {
        if (segSchema == null) {
            return;
        }
        this.name = segSchema.name();
        this.schema = segSchema;
    }

    public String toFriendlyString() {
        StringBuilder buf = new StringBuilder("Segment ");
        if (this.id != null) {
            buf.append(this.id);
            if (this.name != null) {
                buf.append(" ").append(this.name);
            }
            buf.append("\n");
        }
        for (NcpdpField f : this.fields) {
            buf.append(f.toString()).append("\n");
        }
        return buf.toString();
    }

    public EdiSeg toEdiSeg() {
        EdiSeg ediSeg = new EdiSeg(this.id, this.name);
        EltSet eltSet = new EltSet(ediSeg);
        ediSeg.eltSet(eltSet);
        int position = 1;
        ArrayList<String> rawStrings = new ArrayList<String>();
        for (NcpdpField field : this.fields) {
            rawStrings.add(field.rawString());
            Elt elt = field.toElt(eltSet);
            elt.position(position++);
            eltSet.add(elt);
        }
        ediSeg.rawElts().addAll(rawStrings);
        ediSeg.ediSeparators(EdiSeparators.NCPDP_SEPARATORS);
        return ediSeg;
    }

    @Generated
    public SegSchema schema() {
        return this.schema;
    }

    @Generated
    public TransactionSchema transactionSchema() {
        return this.transactionSchema;
    }

    @Generated
    public List<NcpdpField> fields() {
        return this.fields;
    }

    @Generated
    public String id() {
        return this.id;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public String toString() {
        return "NcpdpSegment(fields=" + String.valueOf(this.fields()) + ", id=" + this.id() + ", name=" + this.name() + ")";
    }

    @Generated
    public NcpdpSegment transactionSchema(TransactionSchema transactionSchema) {
        this.transactionSchema = transactionSchema;
        return this;
    }

    @Generated
    public NcpdpSegment id(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public NcpdpSegment name(String name) {
        this.name = name;
        return this;
    }
}

