/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public enum NcpdpSeparator {
    FIELD('\u001c'),
    SEGMENT('\u001e'),
    GROUP('\u001d'),
    START_OF_HEADER_OR_TRAN('\u0002'),
    END_OF_HEADER_OR_TRAN('\u0003'),
    END_OF_FILE('\u0000'),
    START_OF_FILE('\u0000');

    private final char ch;
    private final char printableCh;
    public static final List<NcpdpSeparator> segmentTerminators;
    public static final List<NcpdpSeparator> realSeparators;

    private NcpdpSeparator(char ch) {
        this.ch = ch;
        this.printableCh = (char)(ch | 0x2400);
    }

    public String desc() {
        return this.name().toLowerCase();
    }

    public String printableStr() {
        return Character.toString(this.printableCh);
    }

    public static List<String> strings() {
        ArrayList<String> strs = new ArrayList<String>();
        for (NcpdpSeparator v : NcpdpSeparator.values()) {
            if (v == END_OF_FILE) continue;
            strs.add(Character.toString(v.ch));
        }
        return strs;
    }

    public static List<String> printableStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        for (NcpdpSeparator v : NcpdpSeparator.values()) {
            if (v == END_OF_FILE) continue;
            strs.add(v.printableStr());
        }
        return strs;
    }

    @Generated
    public char ch() {
        return this.ch;
    }

    @Generated
    public char printableCh() {
        return this.printableCh;
    }

    static {
        segmentTerminators = List.of(SEGMENT, START_OF_HEADER_OR_TRAN, END_OF_HEADER_OR_TRAN, GROUP);
        realSeparators = List.of(FIELD, SEGMENT, START_OF_HEADER_OR_TRAN, END_OF_HEADER_OR_TRAN, GROUP);
    }
}

