/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.legacyparser.EdiDataType;
import hdi.edi.legacyparser.FieldMeta;
import hdi.edi.openedi.InputStandardType;
import hdi.edi.parserhelper.ParsingError;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpValueConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpValueConverter.class);
    public static final String ALLOWED_NUMERIC_LAST_CHARS = "{ABCDEFGHI}JKLMNOPQR";
    public static final DateTimeFormatter NCPDP_DATE_FORMAT = DateTimeFormatter.ofPattern("uuuuMMdd");

    public Object parseValue(FieldMeta fieldMeta, String rawVal, List<ParsingError> errors) {
        String val;
        if (rawVal == null) {
            return null;
        }
        if (fieldMeta.standard() == InputStandardType.NCPDP) {
            rawVal = StringUtils.stripEnd((String)rawVal, null);
        }
        try {
            val = switch (fieldMeta.type()) {
                case EdiDataType.DECIMAL -> this.parseDecimal(fieldMeta, rawVal, errors);
                case EdiDataType.NUMERIC -> this.parseNumeric(fieldMeta, rawVal, errors);
                case EdiDataType.DATE -> this.parseDate(rawVal);
                default -> rawVal;
            };
        }
        catch (Exception exception) {
            String errorMsgFormat = "Error converting '%s' to %s";
            ParsingError error = new ParsingError(String.format(errorMsgFormat, rawVal, fieldMeta.type()));
            log.warn("Field '{}': {}", (Object)fieldMeta.name(), (Object)error.error());
            errors.add(error);
            val = rawVal;
        }
        return val;
    }

    private Number parseNumeric(FieldMeta fieldMeta, String rawVal, List<ParsingError> errors) {
        if (StringUtils.isBlank((CharSequence)(rawVal = StringUtils.stripStart((String)rawVal, (String)"0")))) {
            return 0;
        }
        Number result = fieldMeta.scale() == null || fieldMeta.scale() == 0 ? Integer.valueOf(Integer.parseInt(rawVal)) : this.convertStringToBigDecimal(rawVal, fieldMeta.scale());
        return result;
    }

    private BigDecimal parseDecimal(FieldMeta fieldMeta, String rawVal, List<ParsingError> errors) {
        if (fieldMeta.standard() == InputStandardType.NCPDP) {
            return this.parseNcpdpSignedOverpunch(rawVal, fieldMeta.scale(), errors);
        }
        return new BigDecimal(rawVal);
    }

    private BigDecimal parseNcpdpSignedOverpunch(String rawVal, int scale, List<ParsingError> errors) {
        if (StringUtils.isBlank((CharSequence)(rawVal = StringUtils.stripStart((String)rawVal, (String)"0")))) {
            return BigDecimal.ZERO;
        }
        OverpunchInfo overpunchInfo = null;
        String lastChar = StringUtils.right((String)rawVal, (int)1);
        if (StringUtils.isAlpha((CharSequence)lastChar) || StringUtils.containsIgnoreCase((CharSequence)ALLOWED_NUMERIC_LAST_CHARS, (CharSequence)lastChar)) {
            rawVal = StringUtils.substringBeforeLast((String)rawVal, (String)lastChar);
            overpunchInfo = this.overpunchCharToDigit(lastChar, errors);
            int lastDigit = overpunchInfo.digit();
            if (lastDigit >= 0) {
                rawVal = (String)rawVal + lastDigit;
            }
        }
        BigDecimal bd = this.convertStringToBigDecimal((String)rawVal, scale);
        if (overpunchInfo != null && overpunchInfo.isNegative) {
            bd = bd.negate();
        }
        return bd;
    }

    private BigDecimal convertStringToBigDecimal(String numericString, int scale) {
        numericString = StringUtils.leftPad((String)numericString, (int)(scale + 1), (String)"0");
        StringBuilder stringBuilder = new StringBuilder(numericString);
        int decimalPosition = numericString.length() - scale;
        stringBuilder.insert(decimalPosition, ".");
        BigDecimal number = new BigDecimal(stringBuilder.toString());
        return number.setScale(scale, RoundingMode.HALF_UP);
    }

    private OverpunchInfo overpunchCharToDigit(String lastChar, List<ParsingError> errors) {
        int digit = StringUtils.indexOfIgnoreCase((CharSequence)ALLOWED_NUMERIC_LAST_CHARS, (CharSequence)lastChar);
        if (digit < 0) {
            log.warn("Not a valid numeric last character {}. Must be one of: {}", (Object)lastChar, (Object)ALLOWED_NUMERIC_LAST_CHARS);
        }
        boolean isNegative = false;
        if (digit > 10) {
            isNegative = true;
            digit -= 10;
        }
        return new OverpunchInfo(digit, isNegative);
    }

    private LocalDate parseDate(String rawVal) {
        return LocalDate.parse(rawVal, NCPDP_DATE_FORMAT);
    }

    record OverpunchInfo(int digit, boolean isNegative) {
    }
}

