/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.codeent.CodeEntity;
import hdi.model.ServiceLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static void addLineCodeEnt(ServiceLine line, List<CodeEntity> codeEntities, CodeEntity codeEntity) {
        if (codeEntity == null) {
            return;
        }
        codeEntity.line(line);
        codeEntities.add(codeEntity);
        if (codeEntity.modifiers() != null) {
            codeEntities.addAll(codeEntity.modifiers());
        }
    }

    public static <T> void addIfNotNull(Collection<T> accumulator, T entity) {
        if (entity != null) {
            accumulator.add(entity);
        }
    }

    public static <T> List<T> getOrEmpty(List<T> list) {
        if (list == null) {
            return List.of();
        }
        return list;
    }

    public static <T> void addIfNotNull(Collection<T> accumulator, Collection<T> list) {
        if (list != null) {
            accumulator.addAll(list);
        }
    }

    public static Set<String> caseInsensitiveDiff(Set<String> set1, Set<String> set2) {
        Set insens = set2.stream().map(String::toLowerCase).collect(Collectors.toSet());
        TreeSet<String> diff = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String i : set1) {
            if (insens.contains(i.toLowerCase())) continue;
            diff.add(i);
        }
        return diff;
    }

    public static String firstNToString(Collection<?> lst, int n, String delim) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Object item : lst) {
            if (i >= n) break;
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(item.toString());
            ++i;
        }
        if (n < lst.size()) {
            if (!buf.isEmpty()) {
                buf.append(delim);
            }
            buf.append(" ... ");
        }
        return buf.toString();
    }

    public static <T> List<T> addWithInit(List<T> list, T obj) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        list.add(obj);
        return list;
    }

    public static <T> List<T> addAllWithInit(List<T> destList, List<T> sourceList) {
        if (sourceList != null) {
            if (destList == null) {
                destList = new ArrayList<T>();
            }
            destList.addAll(sourceList);
        }
        return destList;
    }
}

