/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.util.TimePeriod;
import java.time.LocalDate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DateRange {
    private LocalDate from;
    private LocalDate to;
    private TimePeriod timePeriod;

    public DateRange() {
    }

    public DateRange(LocalDate from, LocalDate to) {
        this.from = from;
        this.to = to;
        this.timePeriod = TimePeriod.CUSTOM;
    }

    public DateRange(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
    }

    public LocalDate from() {
        if (this.timePeriod.type() == TimePeriod.Type.CUSTOM) {
            return this.from;
        }
        if (this.timePeriod.type() == TimePeriod.Type.ALL) {
            return null;
        }
        return this.timePeriod.getStartDate(LocalDate.now());
    }

    public LocalDate to() {
        if (this.timePeriod.type() == TimePeriod.Type.CUSTOM) {
            return this.to;
        }
        if (this.timePeriod.type() == TimePeriod.Type.ALL) {
            return null;
        }
        return this.timePeriod.getEndDate(LocalDate.now());
    }

    public static DateRange fromPeriodString(String periodString) {
        if ((periodString = StringUtils.trimToNull((String)periodString)) != null && periodString.length() == 4) {
            int year = Integer.parseInt(periodString);
            LocalDate from = LocalDate.of(year, 1, 1);
            LocalDate to = LocalDate.of(year, 12, 31);
            return new DateRange(from, to);
        }
        return new DateRange(null, null);
    }

    @Generated
    public TimePeriod timePeriod() {
        return this.timePeriod;
    }

    @Generated
    public String toString() {
        return "DateRange(from=" + String.valueOf(this.from()) + ", to=" + String.valueOf(this.to()) + ")";
    }
}

