/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.util.DateUtils;
import hdi.util.NumbersUtils;
import hdi.util.WordStringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormattingUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FormattingUtils.class);

    public static String formatDescCode(String code, String desc) {
        String s = code;
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            s = desc;
            s = FormattingUtils.concat(s, code, " (", ")");
        }
        return s;
    }

    public static String formatCodeDesc(String code, String desc) {
        String s = code;
        s = FormattingUtils.concat(s, desc, " - ");
        return s;
    }

    public static String concat(String s1, String s2, String sep) {
        Object result = "";
        if (StringUtils.isNotBlank((CharSequence)s1)) {
            result = s1;
        }
        if (StringUtils.isNotBlank((CharSequence)s2)) {
            if (StringUtils.isNotBlank((CharSequence)result)) {
                result = (String)result + sep;
            }
            result = (String)result + s2;
        }
        return result;
    }

    public static String concat(String s1, String s2, String before, String after) {
        Object result = "";
        if (StringUtils.isNotBlank((CharSequence)s1)) {
            result = s1;
        }
        if (after == null) {
            after = "";
        }
        if (StringUtils.isNotBlank((CharSequence)s2)) {
            result = StringUtils.isNotBlank((CharSequence)result) ? (String)result + before + s2 + after : (String)result + s2;
        }
        return result;
    }

    public static String formatPropsForDesc(String desc, Map<String, String> props) {
        for (Map.Entry<String, String> prop : props.entrySet()) {
            Object propName;
            if (!StringUtils.isNotBlank((CharSequence)prop.getValue())) continue;
            if (StringUtils.isNotBlank((CharSequence)desc)) {
                desc = (String)desc + "; ";
            }
            if (!StringUtils.endsWith((CharSequence)(propName = StringUtils.strip((String)prop.getKey())), (CharSequence)":")) {
                propName = (String)propName + ":";
            }
            propName = (String)propName + " ";
            desc = (String)desc + (String)propName + StringUtils.strip((String)prop.getValue());
        }
        return desc;
    }

    public static String encloseInParen(String s) {
        if (s == null) {
            return null;
        }
        return "(" + s + ")";
    }

    public static String encloseInParen(int i) {
        return FormattingUtils.encloseInParen(Integer.toString(i));
    }

    public static String formatNumber(Number number) {
        return FormattingUtils.formatNumber(number, 2);
    }

    public static String formatNumber(Number number, int scale) {
        return FormattingUtils.formatIntLongBigDec(number, scale, false);
    }

    public static String formatValue(Object val, int scale) {
        String formattedValue;
        String string = formattedValue = val == null ? "" : val.toString();
        if (val instanceof Number) {
            formattedValue = FormattingUtils.formatNumberOrCurrency((Number)val, scale);
        }
        if (val instanceof LocalDate) {
            formattedValue = FormattingUtils.formatDateShort((LocalDate)val);
        }
        return formattedValue;
    }

    public static String formatNumberOrCurrency(Number number, int scale) {
        return FormattingUtils.formatIntLongBigDec(number, scale, true);
    }

    private static String formatIntLongBigDec(Number number, int scale, boolean isFormatAsCurrency) {
        String formattedValue;
        if (number == null) {
            formattedValue = "0";
        } else if (number instanceof Integer) {
            formattedValue = FormattingUtils.formatInt((Integer)number);
        } else if (number instanceof Long) {
            formattedValue = FormattingUtils.formatLong((Long)number);
        } else if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            formattedValue = isFormatAsCurrency ? FormattingUtils.formatAmountAsCurrency(bigDecimal, scale) : FormattingUtils.formatAmount(bigDecimal, scale);
        } else {
            formattedValue = number.toString();
        }
        return formattedValue;
    }

    public static String formatAmountAsCurrency(BigDecimal amount) {
        return FormattingUtils.formatAmountAsCurrency(amount, -1);
    }

    public static String formatAmountAsCurrency(BigDecimal amount, int scale) {
        if (amount == null) {
            return "";
        }
        NumberFormat format = NumberFormat.getCurrencyInstance(Locale.US);
        if (scale >= 0) {
            format.setMinimumFractionDigits(scale);
            format.setMaximumFractionDigits(scale);
            format.setRoundingMode(RoundingMode.HALF_UP);
        }
        return format.format(amount);
    }

    public static String formatAmount(BigDecimal amount, int scale) {
        if (amount == null) {
            return "";
        }
        if (scale < 0) {
            scale = 2;
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(scale);
        format.setMaximumFractionDigits(scale);
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format.format(amount);
    }

    public static String formatNumberBasedOnIntrinsicScale(Number number) {
        if (number == null) {
            return "";
        }
        BigDecimal bigDecVal = number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString());
        bigDecVal = NumbersUtils.removeTrailingZerosUpToDecimal(bigDecVal);
        return FormattingUtils.formatAmount(bigDecVal, bigDecVal.scale());
    }

    public static String formatInt(Integer intVal) {
        if (intVal == null) {
            return "";
        }
        NumberFormat format = NumberFormat.getIntegerInstance(Locale.US);
        return format.format(intVal);
    }

    public static String formatLong(Long intVal) {
        if (intVal == null) {
            return "";
        }
        NumberFormat format = NumberFormat.getIntegerInstance(Locale.US);
        return format.format(intVal);
    }

    public static String formatCount(Long val, String label) {
        return FormattingUtils.formatLong(val) + " " + WordStringUtils.pluralize(label, val);
    }

    public static String formatPercentage(BigDecimal val, int decimalPlaces) {
        val = val.setScale(decimalPlaces, RoundingMode.HALF_UP);
        return String.valueOf(val) + "%";
    }

    public static String formatDateLong(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG));
    }

    public static String formatDateFull(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL));
    }

    public static String formatDateMedium(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
    }

    public static String formatDateShort(LocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
    }

    public static String formatDateTimeMedium(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
    }

    public static String formatDateTimeShort(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return FormattingUtils.formatTemporal(dateTime, null, FormatStyle.SHORT, FormatStyle.SHORT);
    }

    public static String formatTemporal(Temporal from, Temporal to, FormatStyle dateFormatStyle, FormatStyle timeFormatStyle) {
        Object formatted = FormattingUtils.formatTemporal(from, dateFormatStyle, timeFormatStyle);
        if (to != null && !to.equals(from)) {
            formatted = (String)formatted + " - " + FormattingUtils.formatTemporal(to, dateFormatStyle, timeFormatStyle);
        }
        return formatted;
    }

    public static String formatTemporal(Temporal temporal, FormatStyle dateFormatStyle, FormatStyle timeFormatStyle) {
        String formatted = "";
        if (temporal instanceof LocalDate) {
            formatted = ((LocalDate)temporal).format(DateTimeFormatter.ofLocalizedDate(dateFormatStyle));
        } else if (temporal instanceof LocalDateTime) {
            formatted = ((LocalDateTime)temporal).format(DateTimeFormatter.ofLocalizedDateTime(dateFormatStyle, timeFormatStyle));
        } else if (temporal instanceof LocalTime) {
            formatted = ((LocalTime)temporal).format(DateTimeFormatter.ofLocalizedTime(timeFormatStyle));
        }
        return formatted;
    }

    public static String formatDates(LocalDate from, LocalDate to, boolean withDayCount, boolean withAge, LocalDate ageOnThisDate) {
        if (from == null) {
            return "";
        }
        if (to != null && !from.equals(to)) {
            String d1 = FormattingUtils.formatDateShort(from);
            String d2 = FormattingUtils.formatDateShort(to);
            String s = d1 + " - " + d2;
            if (withDayCount) {
                long numberOfDays = ChronoUnit.DAYS.between(from, to) + 1L;
                String days = numberOfDays > 1L ? "days" : "day";
                s = s + " (" + numberOfDays + " " + days + ")";
            }
            return s;
        }
        Object formattedDate = FormattingUtils.formatDateShort(from);
        if (withAge) {
            formattedDate = FormattingUtils.formatDateMedium(from);
            if (ageOnThisDate == null) {
                ageOnThisDate = LocalDate.now();
            }
            Integer age = DateUtils.age(from, ageOnThisDate);
            formattedDate = (String)formattedDate + " (" + age + " " + WordStringUtils.pluralize("year", age.intValue()) + " old)";
        }
        return formattedDate;
    }

    public static String enumToString(Enum<?> enumInstance) {
        if (enumInstance == null) {
            return "";
        }
        String text = enumInstance.name();
        text = StringUtils.replaceChars((String)text, (char)'_', (char)' ');
        text = StringUtils.capitalize((String)StringUtils.toRootLowerCase((String)text));
        return text;
    }

    public static String formatCategoriesPath(String ... catLevels) {
        return FormattingUtils.formatCategoriesPath(List.of(catLevels));
    }

    public static String formatCategoriesPath(Collection<String> catLevels) {
        ArrayList<String> catLevelsToJoin = new ArrayList<String>();
        for (String catLevel : catLevels) {
            if (!StringUtils.isNotBlank((CharSequence)catLevel)) continue;
            catLevelsToJoin.add(catLevel);
        }
        return StringUtils.join(catLevelsToJoin, (String)" / ");
    }

    @Generated
    private FormattingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

