/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import hdi.GeneralException;

public class JsonUtils {
    public static ObjectMapper SERIALIZATION_OBJECT_MAPPER = new ObjectMapper();

    public static String serialize(Object obj) {
        try {
            return SERIALIZATION_OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new GeneralException(e);
        }
    }

    public static String formatJsonString(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        Object jsonData = objectMapper.readValue(jsonString, Object.class);
        ObjectWriter writer = objectMapper.writerWithDefaultPrettyPrinter();
        return writer.writeValueAsString(jsonData);
    }

    static {
        SERIALIZATION_OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new JavaTimeModule());
    }
}

