/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import org.apache.commons.lang3.StringUtils;

public class NdcUtils {
    public static final int LABELER_LENGTH = 5;
    public static final int PRODUCT_CODE_LENGTH = 4;

    public static String normalizeLabelerAndProductCode(String code) {
        if (StringUtils.contains((CharSequence)code, (int)45)) {
            code = NdcUtils.productNdcTo54(code);
        } else {
            int labelerAndProductLength = 9;
            if (StringUtils.length((CharSequence)(code = StringUtils.left((String)code, (int)labelerAndProductLength))) < labelerAndProductLength) {
                code = StringUtils.leftPad((String)code, (int)labelerAndProductLength, (char)'0');
            }
        }
        return code;
    }

    public static String productNdcTo54(String productNdc) {
        String[] tokens = StringUtils.split((String)productNdc, (char)'-');
        if (tokens.length == 0) {
            return productNdc;
        }
        String labeler = tokens[0];
        labeler = StringUtils.leftPad((String)labeler, (int)5, (char)'0');
        if (tokens.length < 2) {
            return labeler;
        }
        String productCode = tokens[1];
        productCode = StringUtils.leftPad((String)productCode, (int)4, (char)'0');
        return labeler + productCode;
    }

    public static String packageCodeFromEdiCode(String codeFromEdi) {
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)codeFromEdi, (String)"-");
        String productCode = null;
        if (tokens.length == 1) {
            if (StringUtils.length((CharSequence)codeFromEdi) >= 11) {
                productCode = StringUtils.right((String)codeFromEdi, (int)2);
            }
        } else if (tokens.length >= 3) {
            productCode = tokens[2];
        }
        return productCode;
    }
}

