/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import java.math.BigDecimal;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumbersUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NumbersUtils.class);

    public static BigDecimal calcPercentage(Number part, Number total) {
        BigDecimal bg;
        log.debug("Calculating %%, total {}, part {}", (Object)total, (Object)part);
        float result = part.floatValue() * 100.0f / total.floatValue();
        try {
            bg = new BigDecimal(result);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Big decimal exception: {}, {}", (Object)part, (Object)total);
            bg = BigDecimal.ZERO;
        }
        return bg;
    }

    public static Number nullToZero(Number val) {
        if (val != null) {
            return val;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal subtract(Number from, Number what) {
        BigDecimal fromBg = NumbersUtils.convertToBigDecimal(from);
        BigDecimal whatBg = NumbersUtils.convertToBigDecimal(what);
        return fromBg.subtract(whatBg);
    }

    public static BigDecimal convertToBigDecimal(Number number) {
        if (number == null) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer) {
            return new BigDecimal(number.intValue());
        }
        if (number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        throw new IllegalArgumentException("Don't know how to convert number of type " + number.getClass().getName());
    }

    public static BigDecimal removeTrailingZerosUpToDecimal(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value.stripTrailingZeros().toPlainString());
    }

    public static BigDecimal convertToBigDecimalAccordingToScale(String numberString, int scale) {
        if (numberString == null || numberString.isEmpty()) {
            throw new IllegalArgumentException("Input string cannot be null or empty.");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("Scale cannot be negative.");
        }
        BigDecimal value = new BigDecimal(numberString);
        if (!StringUtils.contains((CharSequence)numberString, (CharSequence)".")) {
            value = value.movePointLeft(scale);
        }
        return value;
    }
}

