/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class WordStringUtils {
    public static String pluralize(String word, long count) {
        if (count == 1L) {
            return word;
        }
        return word + "s";
    }

    public static String capitalize(String s) {
        return StringUtils.capitalize((String)StringUtils.toRootLowerCase((String)s));
    }

    public static String singularize(String word, Number count) {
        if (count == null || count.intValue() != 1) {
            return word;
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)word, (CharSequence)"s")) {
            return StringUtils.stripEnd((String)word, (String)"s");
        }
        return word;
    }

    public static String enumNameToDesc(Enum<?> e) {
        String lowercase = e.name().toLowerCase().replace('_', ' ');
        return WordUtils.capitalize((String)lowercase);
    }

    public static String enumNameToObjName(Enum<?> e) {
        String s = WordStringUtils.enumNameToDesc(e);
        return StringUtils.remove((String)s, (char)' ');
    }

    public static List<String> createList(String ... items) {
        ArrayList<String> l = new ArrayList<String>();
        for (String i : items) {
            if (StringUtils.stripToNull((String)i) == null) continue;
            l.add(i);
        }
        return l;
    }

    public static String decodeYN(String yn) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"Y", (CharSequence)yn)) {
            return "Yes";
        }
        return "No";
    }

    public static List<String> listStringToList(String patternString) {
        List<String> patternList = List.of(StringUtils.splitByWholeSeparator((String)patternString, (String)","));
        return patternList.stream().map(StringUtils::strip).toList();
    }

    public static int countNumberOfCharInWhitespace(String s, char c) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char curChar = s.charAt(i);
            if (curChar == c) {
                ++count;
            }
            if (!Character.isWhitespace(curChar)) break;
        }
        return count;
    }
}

