/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public enum CloudProvider {
    Azure{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/metadata/instance/compute/vmId?api-version=2021-02-01&format=text", "Metadata", "true");
        }
    }
    ,
    AWS{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/latest/meta-data/instance-id", "Metadata", "true");
        }
    }
    ,
    Google{

        @Override
        public String getInstanceId() {
            return CloudProvider.instanceIdFor("http://169.254.169.254/computeMetadata/v1/instance?alt=text", "Metadata-Flavor", "Google");
        }
    };


    public abstract String getInstanceId();

    private static String instanceIdFor(String instanceIdUrl, String ... headers) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(new URI(instanceIdUrl)).headers(headers).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

