/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Network {

    public static class Interface {

        public static class Selector {
            private final Set<String> allowedInterfaceNames = new HashSet<String>();
            private final Set<String> deniedInterfaceNames = new HashSet<String>();

            private static boolean matchesAny(String string, Set<String> regexSet) {
                return regexSet.stream().anyMatch(string::matches);
            }

            private boolean matchesRegexLists(NetworkInterface netIf) {
                String name = netIf.getDisplayName();
                return !Selector.matchesAny(name, this.deniedInterfaceNames) && (this.allowedInterfaceNames.isEmpty() || Selector.matchesAny(name, this.allowedInterfaceNames));
            }

            public void interfaceAllowed(String regex) {
                this.allowedInterfaceNames.add(regex);
            }

            public void interfaceDenied(String regex) {
                this.deniedInterfaceNames.add(regex);
            }

            boolean usable(NetworkInterface netIf) {
                return !this.isSpecial(netIf) && this.matchesRegexLists(netIf);
            }

            boolean isSpecial(NetworkInterface netIf) {
                try {
                    return netIf.isLoopback() || netIf.isVirtual() || netIf.isPointToPoint();
                }
                catch (SocketException e) {
                    return true;
                }
            }
        }

        public static class Data {
            public final String name;
            byte[] hwAddress;

            private Data(NetworkInterface networkInterface) {
                this.name = networkInterface.getName();
                try {
                    this.hwAddress = networkInterface.getHardwareAddress();
                }
                catch (SocketException e) {
                    throw new RuntimeException(e);
                }
            }

            static Stream<Data> gatherUsing(Selector selector) throws SocketException {
                return Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(selector::usable).map(Data::new);
            }
        }
    }

    public static class NetworkInterface {
        private final java.net.NetworkInterface ni;

        private NetworkInterface(java.net.NetworkInterface ni) {
            this.ni = ni;
        }

        public String getName() {
            return this.ni.getName();
        }

        public byte[] getHardwareAddress() throws SocketException {
            return this.ni.getHardwareAddress();
        }

        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        public boolean isLoopback() throws SocketException {
            return this.ni.isLoopback();
        }

        public boolean isVirtual() throws SocketException {
            return this.ni.isVirtual();
        }

        public boolean isPointToPoint() throws SocketException {
            return this.ni.isPointToPoint();
        }

        public static Enumeration<NetworkInterface> getNetworkInterfaces() throws SocketException {
            return Collections.enumeration(Collections.list(java.net.NetworkInterface.getNetworkInterfaces()).stream().map(ni -> new NetworkInterface((java.net.NetworkInterface)ni)).collect(Collectors.toList()));
        }
    }
}

