/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.hardware;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax0.license3j.hardware.CloudProvider;
import javax0.license3j.hardware.HashCalculator;
import javax0.license3j.hardware.Network;

public class UUIDCalculator {
    private final HashCalculator calculator;

    public UUIDCalculator(Network.Interface.Selector selector) {
        this.calculator = new HashCalculator(selector);
    }

    public UUID getMachineId(CloudProvider cloudProvider, boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        if (cloudProvider != null) {
            this.calculator.updateWithCloudInstanceId(md5, cloudProvider);
        }
        if (useNetwork) {
            this.calculator.updateWithNetworkData(md5);
        }
        if (useHostName) {
            this.calculator.updateWithHostName(md5);
        }
        if (useArchitecture) {
            this.calculator.updateWithArchitecture(md5);
        }
        byte[] digest = md5.digest();
        return UUID.nameUUIDFromBytes(digest);
    }

    public String getMachineIdString(CloudProvider cloudProvider, boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        UUID uuid = this.getMachineId(cloudProvider, useNetwork, useHostName, useArchitecture);
        return uuid.toString();
    }

    public boolean assertUUID(UUID uuid, CloudProvider cloudProvider, boolean useNetwork, boolean useHostName, boolean useArchitecture) throws SocketException, UnknownHostException, NoSuchAlgorithmException {
        UUID machineUUID = this.getMachineId(cloudProvider, useNetwork, useHostName, useArchitecture);
        return machineUUID != null && machineUUID.equals(uuid);
    }

    public boolean assertUUID(String uuid, CloudProvider cloudProvider, boolean useNetwork, boolean useHostName, boolean useArchitecture) {
        try {
            return this.assertUUID(UUID.fromString(uuid), cloudProvider, useNetwork, useHostName, useArchitecture);
        }
        catch (Exception e) {
            return false;
        }
    }
}

