/*
 * Decompiled with CFR 0.152.
 */
package javax0.license3j.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax0.license3j.crypto.LicenseKeyPair;
import javax0.license3j.io.IOFormat;

public class KeyPairWriter
implements Closeable {
    private final OutputStream osPrivate;
    private final OutputStream osPublic;
    final AtomicBoolean closed = new AtomicBoolean(false);

    public KeyPairWriter(OutputStream privateKeyOutputStream, OutputStream publicKeyOutputStream) {
        this.osPrivate = Objects.requireNonNull(privateKeyOutputStream);
        this.osPublic = Objects.requireNonNull(publicKeyOutputStream);
    }

    public KeyPairWriter(File privateKeyFile, File publicKeyFile) throws FileNotFoundException {
        this(new FileOutputStream(privateKeyFile), new FileOutputStream(publicKeyFile));
    }

    public KeyPairWriter(String privateKeyFileName, String publicKeyFileName) throws FileNotFoundException {
        this(new File(privateKeyFileName), new File(publicKeyFileName));
    }

    public void write(LicenseKeyPair pair, IOFormat format) throws IOException {
        switch (format) {
            case BINARY: {
                this.osPrivate.write(pair.getPrivate());
                this.osPublic.write(pair.getPublic());
                this.close();
                return;
            }
            case BASE64: {
                this.osPrivate.write(Base64.getEncoder().encode(pair.getPrivate()));
                this.osPublic.write(Base64.getEncoder().encode(pair.getPublic()));
                this.close();
                return;
            }
        }
        throw new IllegalArgumentException("Key format " + format + " is unknown.");
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            IOException caught = null;
            try {
                this.osPrivate.close();
            }
            catch (IOException e) {
                caught = e;
            }
            this.osPublic.close();
            if (caught != null) {
                throw caught;
            }
        }
    }
}

